/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.util.lang;

import java.io.IOException;

public final class Hex {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static Appendable append(Appendable a, short in) {
        return Hex.append(a, (long)in, 4);
    }

    public static Appendable append(Appendable a, short in, int length) {
        return Hex.append(a, (long)in, length);
    }

    public static Appendable append(Appendable a, int in) {
        return Hex.append(a, (long)in, 8);
    }

    public static Appendable append(Appendable a, int in, int length) {
        return Hex.append(a, (long)in, length);
    }

    public static Appendable append(Appendable a, long in) {
        return Hex.append(a, in, 16);
    }

    public static Appendable append(Appendable a, long in, int length) {
        try {
            for (int lim = (length << 2) - 4; lim >= 0; lim -= 4) {
                a.append(DIGITS[(byte)(in >> lim) & 0xF]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return a;
    }

    public static Appendable append(Appendable a, byte[] bytes) {
        try {
            for (byte b : bytes) {
                a.append(DIGITS[(byte)((b & 0xF0) >> 4)]);
                a.append(DIGITS[(byte)(b & 0xF)]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return a;
    }

    public static long parseLong(CharSequence s) {
        long out = 0L;
        int shifts = 0;
        for (int i = 0; i < s.length() && shifts < 16; ++i) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 48);
                continue;
            }
            if (c > '@' && c < 'G') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 55);
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            shifts = (byte)(shifts + 1);
            out <<= 4;
            out |= (long)(c - 87);
        }
        return out;
    }

    public static short parseShort(String s) {
        short out = 0;
        int shifts = 0;
        for (int i = 0; i < s.length() && shifts < 4; ++i) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c - 48);
                continue;
            }
            if (c > '@' && c < 'G') {
                shifts = (byte)(shifts + 1);
                out = (short)(out << 4);
                out = (short)(out | c - 55);
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            shifts = (byte)(shifts + 1);
            out = (short)(out << 4);
            out = (short)(out | c - 87);
        }
        return out;
    }
}

