/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.InScopeNamespaces;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyNodeImpl;

public class NamespaceIterator
implements Iterator<NamespaceBinding> {
    private NodeInfo element;
    private int index;
    private NamespaceBinding next;
    private NamespaceBinding[] localDeclarations;
    HashSet<String> undeclaredPrefixes;

    public static Iterator<NamespaceBinding> iterateNamespaces(NodeInfo element) {
        if (element.getNodeKind() == 1) {
            return new NamespaceIterator(element);
        }
        List e = Collections.emptyList();
        return e.iterator();
    }

    public static void sendNamespaces(NodeInfo element, Receiver receiver) throws XPathException {
        if (element instanceof TinyNodeImpl && !((TinyNodeImpl)element).getTree().isUsesNamespaces()) {
            return;
        }
        while (element != null && element.getNodeKind() == 1) {
            NamespaceBinding[] localNamespaces = element.getDeclaredNamespaces(null);
            if (localNamespaces.length > 0) {
                receiver.namespace(new InScopeNamespaces(element), 0);
                return;
            }
            element = element.getParent();
        }
    }

    private NamespaceIterator(NodeInfo element) {
        this.element = element;
        this.undeclaredPrefixes = new HashSet(8);
        this.index = 0;
        this.localDeclarations = element.getDeclaredNamespaces(null);
    }

    @Override
    public boolean hasNext() {
        if (this.element == null || this.next == null && this.index != 0) {
            return false;
        }
        this.advance();
        return this.next != null;
    }

    @Override
    public NamespaceBinding next() {
        return this.next;
    }

    private void advance() {
        NamespaceBinding nsCode;
        while (true) {
            boolean ascend = this.index >= this.localDeclarations.length;
            nsCode = null;
            if (!ascend) {
                boolean bl = ascend = (nsCode = this.localDeclarations[this.index++]) == null;
            }
            if (ascend) {
                this.element = this.element.getParent();
                if (this.element != null && this.element.getNodeKind() == 1) {
                    this.localDeclarations = this.element.getDeclaredNamespaces(this.localDeclarations);
                    this.index = 0;
                    continue;
                }
                this.next = null;
                return;
            }
            String uri = nsCode.getURI();
            String prefix = nsCode.getPrefix();
            if (uri.isEmpty()) {
                this.undeclaredPrefixes.add(prefix);
                continue;
            }
            if (this.undeclaredPrefixes.add(prefix)) break;
        }
        this.next = nsCode;
    }
}

