/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.dsql;

import java.util.Collections;
import java.util.List;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.DsqlQuery;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Expression;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.extension.internal.expression.EmptyExpression;

public final class DefaultDsqlQuery
extends DsqlQuery {
    private final EntityType type;
    private final List<Field> fields;
    private final List<Field> orderByFields;
    private final Direction direction;
    private final Expression filterExpression;
    private final Integer limit;
    private final Integer offset;

    public DefaultDsqlQuery(EntityType type, List<Field> fields, List<Field> orderByFields, Direction direction, Expression filterExpression, Integer limit, Integer offset) {
        this.type = type;
        this.fields = fields;
        this.orderByFields = orderByFields;
        this.direction = direction == null ? Direction.ASC : direction;
        this.filterExpression = filterExpression == null ? new EmptyExpression() : filterExpression;
        this.limit = limit;
        this.offset = offset;
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<Field> getOrderByFields() {
        return Collections.unmodifiableList(this.orderByFields);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public EntityType getType() {
        return this.type;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public String translate(QueryTranslator queryTranslator) {
        queryTranslator.translateFields(this.fields);
        queryTranslator.translateTypes(this.type);
        if (!this.filterExpression.isEmpty()) {
            queryTranslator.translateBeginExpression();
            this.filterExpression.accept(queryTranslator);
        }
        if (this.orderByFields.size() > 0) {
            queryTranslator.translateOrderByFields(this.orderByFields, this.direction);
        }
        if (this.limit != null) {
            queryTranslator.translateLimit(this.limit.intValue());
        }
        if (this.offset != null) {
            queryTranslator.translateOffset(this.offset.intValue());
        }
        return queryTranslator.getTranslation();
    }
}

