/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.internal;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.util.Optional;

public class IPAddressValidator {
    protected Optional<InetAddress> asInetAddress(String subject) {
        try {
            if (InetAddresses.isInetAddress((String)subject)) {
                return Optional.of(InetAddresses.forString((String)subject));
            }
            return Optional.empty();
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    protected Optional<String> checkIpAddress(String subject, int expectedLength, String failureFormat) {
        return this.asInetAddress(subject).filter(addr -> addr.getAddress().length == expectedLength).map(addr -> this.emptyString()).orElse(Optional.of(String.format(failureFormat, subject)));
    }

    private Optional<String> emptyString() {
        return Optional.empty();
    }
}

