/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.math.BigDecimal;
import java.util.Objects;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.internal.JSONPrinter;

public class NumberSchema
extends Schema {
    private final boolean requiresNumber;
    private final Number minimum;
    private final Number maximum;
    private final Number multipleOf;
    private final boolean exclusiveMinimum;
    private final boolean exclusiveMaximum;
    private final boolean requiresInteger;

    public static Builder builder() {
        return new Builder();
    }

    public NumberSchema() {
        this(NumberSchema.builder());
    }

    public NumberSchema(Builder builder) {
        super(builder);
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.exclusiveMinimum = builder.exclusiveMinimum;
        this.exclusiveMaximum = builder.exclusiveMaximum;
        this.multipleOf = builder.multipleOf;
        this.requiresNumber = builder.requiresNumber;
        this.requiresInteger = builder.requiresInteger;
    }

    private void checkMaximum(double subject) {
        if (this.maximum != null) {
            if (this.exclusiveMaximum && this.maximum.doubleValue() <= subject) {
                throw new ValidationException((Schema)this, subject + " is not lower than " + this.maximum, "exclusiveMaximum");
            }
            if (this.maximum.doubleValue() < subject) {
                throw new ValidationException((Schema)this, subject + " is not lower or equal to " + this.maximum, "maximum");
            }
        }
    }

    private void checkMinimum(double subject) {
        if (this.minimum != null) {
            if (this.exclusiveMinimum && subject <= this.minimum.doubleValue()) {
                throw new ValidationException((Schema)this, subject + " is not higher than " + this.minimum, "exclusiveMinimum");
            }
            if (subject < this.minimum.doubleValue()) {
                throw new ValidationException((Schema)this, subject + " is not higher or equal to " + this.minimum, "minimum");
            }
        }
    }

    private void checkMultipleOf(double subject) {
        BigDecimal remainder;
        if (this.multipleOf != null && (remainder = BigDecimal.valueOf(subject).remainder(BigDecimal.valueOf(this.multipleOf.doubleValue()))).compareTo(BigDecimal.ZERO) != 0) {
            throw new ValidationException((Schema)this, subject + " is not a multiple of " + this.multipleOf, "multipleOf");
        }
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public boolean isExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public boolean isExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public boolean requiresInteger() {
        return this.requiresInteger;
    }

    @Override
    public void validate(Object subject) {
        if (!(subject instanceof Number)) {
            if (this.requiresNumber) {
                throw new ValidationException((Schema)this, Number.class, subject);
            }
        } else {
            if (!(subject instanceof Integer) && !(subject instanceof Long) && this.requiresInteger) {
                throw new ValidationException((Schema)this, Integer.class, subject, "type");
            }
            double intSubject = ((Number)subject).doubleValue();
            this.checkMinimum(intSubject);
            this.checkMaximum(intSubject);
            this.checkMultipleOf(intSubject);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NumberSchema) {
            NumberSchema that = (NumberSchema)o;
            return that.canEqual(this) && this.requiresNumber == that.requiresNumber && this.exclusiveMinimum == that.exclusiveMinimum && this.exclusiveMaximum == that.exclusiveMaximum && this.requiresInteger == that.requiresInteger && Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum) && Objects.equals(this.multipleOf, that.multipleOf) && super.equals(that);
        }
        return false;
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        if (this.requiresInteger) {
            writer.key("type").value("integer");
        } else if (this.requiresNumber) {
            writer.key("type").value("number");
        }
        writer.ifPresent("minimum", this.minimum);
        writer.ifPresent("maximum", this.maximum);
        writer.ifPresent("multipleOf", this.multipleOf);
        writer.ifTrue("exclusiveMinimum", this.exclusiveMinimum);
        writer.ifTrue("exclusiveMaximum", this.exclusiveMaximum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.requiresNumber, this.minimum, this.maximum, this.multipleOf, this.exclusiveMinimum, this.exclusiveMaximum, this.requiresInteger);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NumberSchema;
    }

    public static class Builder
    extends Schema.Builder<NumberSchema> {
        private Number minimum;
        private Number maximum;
        private Number multipleOf;
        private boolean exclusiveMinimum = false;
        private boolean exclusiveMaximum = false;
        private boolean requiresNumber = true;
        private boolean requiresInteger = false;

        @Override
        public NumberSchema build() {
            return new NumberSchema(this);
        }

        public Builder exclusiveMaximum(boolean exclusiveMaximum) {
            this.exclusiveMaximum = exclusiveMaximum;
            return this;
        }

        public Builder exclusiveMinimum(boolean exclusiveMinimum) {
            this.exclusiveMinimum = exclusiveMinimum;
            return this;
        }

        public Builder maximum(Number maximum) {
            this.maximum = maximum;
            return this;
        }

        public Builder minimum(Number minimum) {
            this.minimum = minimum;
            return this;
        }

        public Builder multipleOf(Number multipleOf) {
            this.multipleOf = multipleOf;
            return this;
        }

        public Builder requiresInteger(boolean requiresInteger) {
            this.requiresInteger = requiresInteger;
            return this;
        }

        public Builder requiresNumber(boolean requiresNumber) {
            this.requiresNumber = requiresNumber;
            return this;
        }
    }
}

