/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.execution;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.util.ComponentLocationProvider;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;

@NoExtend
public abstract class LocationExecutionContextProvider
extends ComponentLocationProvider
implements ExceptionContextProvider {
    private static final Pattern URL_PATTERN = Pattern.compile("url=\"[a-z]*://([^@]*)@");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("address=\"[a-z]*://([^@]*)@");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("password=\"([^\"|\n]*)\"");
    private static final String PASSWORD_MASK = "<<credentials>>";
    public static final String PASSWORD_ATTRIBUTE_MASK = "password=\"%s\"";

    @Deprecated
    public static void addMetadataAnnotationsFromXml(Map<QName, Object> beanAnnotations, String sourceCode, Map<String, Object> customAttributes) {
        String documentationName;
        if (sourceCode != null) {
            beanAnnotations.put(Component.Annotations.SOURCE_ELEMENT_ANNOTATION_KEY, LocationExecutionContextProvider.maskPasswords(sourceCode));
        }
        if ((documentationName = (String)customAttributes.get(Component.Annotations.NAME_ANNOTATION_KEY.toString())) != null) {
            beanAnnotations.put(Component.Annotations.NAME_ANNOTATION_KEY, documentationName);
        }
        customAttributes.forEach((key, value) -> {
            if (!key.equals(Component.Annotations.NAME_ANNOTATION_KEY.toString())) {
                beanAnnotations.put(QName.valueOf(key), value);
            }
        });
    }

    @Deprecated
    public static void addMetadataAnnotationsFromDocAttributes(Map<QName, Object> beanAnnotations, String sourceCode, Map<String, String> docAttributes) {
        if (sourceCode != null) {
            beanAnnotations.put(Component.Annotations.SOURCE_ELEMENT_ANNOTATION_KEY, LocationExecutionContextProvider.maskPasswords(sourceCode));
        }
        beanAnnotations.putAll(docAttributes.entrySet().stream().collect(Collectors.toMap(e -> QName.valueOf((String)e.getKey()), e -> (String)e.getValue())));
    }

    public static String maskPasswords(String xml, String passwordMask) {
        xml = LocationExecutionContextProvider.maskUrlPassword(xml, URL_PATTERN, passwordMask);
        Matcher matcher = PASSWORD_PATTERN.matcher(xml = LocationExecutionContextProvider.maskUrlPassword(xml, ADDRESS_PATTERN, passwordMask));
        if (matcher.find() && matcher.groupCount() > 0) {
            xml = xml.replaceAll(Pattern.quote(LocationExecutionContextProvider.maskPasswordAttribute(matcher.group(1))), LocationExecutionContextProvider.maskPasswordAttribute(passwordMask));
        }
        xml = LocationExecutionContextProvider.maskUrlPassword(xml, PASSWORD_PATTERN, passwordMask);
        return xml;
    }

    public static String maskPasswords(String xml) {
        return LocationExecutionContextProvider.maskPasswords(xml, PASSWORD_MASK);
    }

    private static String maskUrlPassword(String xml, Pattern pattern, String passwordMask) {
        Matcher matcher = pattern.matcher(xml);
        if (matcher.find() && matcher.groupCount() > 0) {
            xml = xml.replaceAll(Pattern.quote(matcher.group(1)), passwordMask);
        }
        return xml;
    }

    private static String maskPasswordAttribute(String password) {
        return String.format(PASSWORD_ATTRIBUTE_MASK, password);
    }
}

