/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;

public class ClassLoaderInjectorInvocationHandler
implements InvocationHandler {
    private final ClassLoader classLoader;
    private final Object delegate;

    private ClassLoaderInjectorInvocationHandler(Object delegate, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object object = method.invoke(this.delegate, args);
            Thread.currentThread().setContextClassLoader(originalLoader);
            return object;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(originalLoader);
                throw throwable;
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
    }

    public static Object createClassLoaderInjectorInvocationHandler(Object delegate, ClassLoader classLoader) {
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0, (String)"delegate cannot be null");
        Preconditions.checkArgument((classLoader != null ? 1 : 0) != 0, (String)"classloader cannot be null");
        ClassLoaderInjectorInvocationHandler handler = new ClassLoaderInjectorInvocationHandler(delegate, classLoader);
        return Proxy.newProxyInstance(classLoader, ClassUtils.findImplementedInterfaces(delegate.getClass()), (InvocationHandler)handler);
    }
}

