/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.extension.incubator.metrics.ExtendedLongGaugeBuilder;
import io.opentelemetry.extension.incubator.metrics.LongGauge;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.List;
import java.util.function.Consumer;

final class SdkLongGauge
extends AbstractInstrument
implements LongGauge {
    private final WriteableMetricStorage storage;

    private SdkLongGauge(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    public void set(long increment, Attributes attributes) {
        this.storage.recordLong(increment, attributes, Context.root());
    }

    public void set(long increment) {
        this.set(increment, Attributes.empty());
    }

    static final class SdkLongGaugeBuilder
    extends AbstractInstrumentBuilder<SdkLongGaugeBuilder>
    implements ExtendedLongGaugeBuilder {
        SdkLongGaugeBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            super(meterProviderSharedState, sharedState, InstrumentType.OBSERVABLE_GAUGE, InstrumentValueType.LONG, name, description, unit, adviceBuilder);
        }

        @Override
        protected SdkLongGaugeBuilder getThis() {
            return this;
        }

        public SdkLongGauge build() {
            return this.buildSynchronousInstrument((x$0, x$1) -> new SdkLongGauge((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        public ExtendedLongGaugeBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.adviceBuilder.setAttributes(attributes);
            return this;
        }

        public ObservableLongGauge buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return this.registerLongAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback);
        }

        public ObservableLongMeasurement buildObserver() {
            return this.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }
    }
}

