/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metrics.exporter.impl.optel.resources.grpc;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mule.metrics.exporter.config.api.MeterExporterConfiguration;
import org.mule.metrics.exporter.impl.optel.resources.MeterExporterConfigurator;
import org.mule.metrics.exporter.impl.optel.resources.MeterExporterConfiguratorException;

public class GrpcMeterExporterConfigurator
implements MeterExporterConfigurator {
    @Override
    public MetricExporter configExporter(MeterExporterConfiguration meterExporterConfiguration) throws MeterExporterConfiguratorException {
        String timeout;
        String headers;
        String type;
        String endpoint = meterExporterConfiguration.getStringValue("mule.openTelemetry.meter.exporter.endpoint");
        OtlpGrpcMetricExporterBuilder builder = OtlpGrpcMetricExporter.builder();
        if (!StringUtils.isEmpty((CharSequence)endpoint)) {
            builder.setEndpoint(endpoint);
        }
        if ((type = meterExporterConfiguration.getStringValue("mule.openTelemetry.meter.exporter.compression")) != null) {
            builder.setCompression(type);
        }
        if (Boolean.parseBoolean(meterExporterConfiguration.getStringValue("mule.openTelemetry.meter.exporter.tls.enabled", "false"))) {
            this.configureTls(builder, meterExporterConfiguration);
        }
        if ((headers = meterExporterConfiguration.getStringValue("mule.openTelemetry.meter.exporter.headers")) != null) {
            this.configureHeaders(builder, headers);
        }
        if ((timeout = meterExporterConfiguration.getStringValue("mule.openTelemetry.meter.exporter.timeout")) != null) {
            this.configureTimeout(builder, timeout);
        }
        return builder.build();
    }

    private void configureTimeout(OtlpGrpcMetricExporterBuilder builder, String timeout) {
        builder.setTimeout(Long.parseLong(timeout), TimeUnit.MILLISECONDS);
    }

    private void configureHeaders(OtlpGrpcMetricExporterBuilder builder, String headers) throws MeterExporterConfiguratorException {
        try {
            Map retMap = (Map)new Gson().fromJson(headers, new TypeToken<HashMap<String, Object>>(){}.getType());
            retMap.forEach((arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)builder).addHeader(arg_0, arg_1));
        }
        catch (Exception e) {
            throw new MeterExporterConfiguratorException(e);
        }
    }

    private void configureTls(OtlpGrpcMetricExporterBuilder builder, MeterExporterConfiguration meterExporterConfiguration) throws MeterExporterConfiguratorException {
        GrpcMeterExporterConfigurator.configureTrustedCertificates(builder, meterExporterConfiguration);
        this.configureClientTls(builder, meterExporterConfiguration);
    }

    private static void configureTrustedCertificates(OtlpGrpcMetricExporterBuilder builder, MeterExporterConfiguration meterExporterConfiguration) throws MeterExporterConfiguratorException {
        String caFilePath = meterExporterConfiguration.getStringValue("mule.openTelemetry.meter.exporter.tls.caFileLocation");
        if (caFilePath != null) {
            try {
                byte[] caFileBytes = Files.readAllBytes(Paths.get(caFilePath, new String[0]));
                builder.setTrustedCertificates(caFileBytes);
            }
            catch (IOException e) {
                throw new MeterExporterConfiguratorException(e);
            }
        }
    }

    private void configureClientTls(OtlpGrpcMetricExporterBuilder builder, MeterExporterConfiguration meterExporterConfiguration) throws MeterExporterConfiguratorException {
        String certFilePath = meterExporterConfiguration.getStringValue("mule.openTelemetry.meter.exporter.tls.certFileLocation");
        String keyFilePath = meterExporterConfiguration.getStringValue("mule.openTelemetry.meter.exporter.tls.keyFileLocation");
        if (certFilePath != null && keyFilePath != null) {
            try {
                byte[] keyFileBytes = Files.readAllBytes(Paths.get(keyFilePath, new String[0]));
                byte[] certFileBytes = Files.readAllBytes(Paths.get(certFilePath, new String[0]));
                builder.setClientTls(keyFileBytes, certFileBytes);
            }
            catch (IOException e) {
                throw new MeterExporterConfiguratorException(e);
            }
        }
    }
}

