/*
 * Copyright 2024 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metrics.exporter.impl.optel.resources.inmemory;

import org.mule.metrics.exporter.config.api.MeterExporterConfiguration;
import org.mule.metrics.exporter.impl.OpenTelemetryMeterExporterFactory;
import org.mule.metrics.exporter.impl.optel.resources.MeterExporterConfigurator;
import org.mule.metrics.exporter.impl.optel.resources.MeterExporterConfiguratorException;

import io.opentelemetry.sdk.metrics.export.MetricExporter;

public class InMemoryMeterExporterConfigurator implements MeterExporterConfigurator {

  @Override
  public MetricExporter configExporter(MeterExporterConfiguration meterExporterConfiguration)
      throws MeterExporterConfiguratorException {
    return OpenTelemetryMeterExporterFactory.METER_SNIFFER_EXPORTER;
  }

}
