/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.api.tests;

import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class XMLDBTestCase
extends TestCase {
    protected Collection col = null;
    protected Document config = null;
    protected String driver = "org.xmldb.api.reference.DatabaseImpl";
    protected String rootCollection = "child1";
    protected String collectionURI = null;
    protected String uriPrefix = null;
    protected String username = null;
    protected String password = null;
    protected boolean quiet = false;
    protected boolean supportsXPath = false;
    protected boolean supportsBinary = false;
    protected boolean supportsTransactions = false;
    protected boolean supportsManagement = false;
    protected boolean supportsXUpdate = false;
    protected boolean supportsNested = false;

    public XMLDBTestCase(String string) {
        super(string);
        try {
            String string2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.config = documentBuilder.parse("config.xml");
            NodeList nodeList = this.config.getElementsByTagName("test");
            Element element = (Element)nodeList.item(0);
            this.driver = element.getAttribute("driver");
            this.collectionURI = element.getAttribute("uriPrefix") + this.rootCollection;
            this.uriPrefix = element.getAttribute("uriPrefix");
            this.username = element.getAttribute("username");
            this.password = element.getAttribute("password");
            String string3 = element.getAttribute("quietMode");
            if (string3 != null && string3.equals("true")) {
                this.quiet = true;
            }
            if ((string2 = element.getAttribute("supportsNested")) != null && string2.equals("true")) {
                this.supportsNested = true;
            }
        }
        catch (Exception exception) {
            System.out.println("Could not parse the configuration config.xml");
            System.exit(1);
        }
    }

    public void setUp() throws Exception {
        Class<?> clazz = Class.forName(this.driver);
        Database database = (Database)clazz.newInstance();
        DatabaseManager.registerDatabase(database);
        this.col = DatabaseManager.getCollection(this.uriPrefix, this.username, this.password);
        this.checkCapabilities(database);
        this.initRepository();
        this.col.close();
        this.col = DatabaseManager.getCollection(this.collectionURI, this.username, this.password);
        if (this.col == null) {
            System.out.println("Collection could not be created");
            System.exit(-1);
        }
    }

    public void tearDown() {
        try {
            if (this.supportsManagement) {
                this.col.close();
                this.col = DatabaseManager.getCollection(this.uriPrefix, this.username, this.password);
                CollectionManagementService collectionManagementService = (CollectionManagementService)this.col.getService("CollectionManagementService", "1.0");
                int n = 1;
                while (n <= 3) {
                    collectionManagementService.removeCollection("child" + n);
                    ++n;
                }
            }
            this.col.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void initRepository() throws Exception {
        Collection collection = null;
        if (this.supportsManagement) {
            try {
                CollectionManagementService collectionManagementService = (CollectionManagementService)this.col.getService("CollectionManagementService", "1.0");
                int n = 1;
                while (n <= 3) {
                    collectionManagementService.createCollection("child" + n);
                    ++n;
                }
                if (this.supportsNested) {
                    collection = DatabaseManager.getCollection(this.uriPrefix + "child2", this.username, this.password);
                    collectionManagementService = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                    collectionManagementService.createCollection("subchild1");
                }
                collection = DatabaseManager.getCollection(this.uriPrefix + "child1", this.username, this.password);
                if (this.supportsNested) {
                    collectionManagementService = (CollectionManagementService)collection.getService("CollectionManagementService", "1.0");
                    int n2 = 1;
                    while (n2 <= 2) {
                        collectionManagementService.createCollection("subchild" + n2);
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                collection = DatabaseManager.getCollection(this.uriPrefix + "child1", this.username, this.password);
            }
            this.insertResource(collection, "test1.xml", "XMLResource");
            this.insertResource(collection, "test2.xml", "XMLResource");
            this.insertResource(collection, "test3.xml", "XMLResource");
            if (this.supportsBinary) {
                this.insertResource(collection, "image.gif", "BinaryResource");
            }
        }
    }

    protected void insertResource(Collection collection, String string, String string2) throws Exception {
        FileInputStream fileInputStream = new FileInputStream("tests/files/" + string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        Resource resource = collection.createResource(string, string2);
        if (string2.equals("XMLResource")) {
            resource.setContent((Object)new String(byArray));
        } else {
            resource.setContent((Object)byArray);
        }
        collection.storeResource(resource);
    }

    protected void checkCapabilities(Database database) throws Exception {
        block14: {
            if (this.col.getService("CollectionManagementService", "1.0") != null) {
                this.supportsManagement = true;
            } else if (!this.quiet) {
                System.out.println("This driver does not appear to support the CollectionManagement Service. No auto set of the repository will possible. Make sure your repository has the necessary collections already created.");
            }
            if (Integer.parseInt(database.getConformanceLevel()) >= 1) {
                this.supportsXPath = true;
            } else if (!this.quiet) {
                System.out.println("This driver does not appear to support theXPathQueryService. No XPath tests will be performed.");
            }
            try {
                this.col.createResource(null, "BinaryResource");
                this.supportsBinary = true;
            }
            catch (XMLDBException xMLDBException) {
                if (xMLDBException.errorCode != 302 || this.quiet) break block14;
                System.out.println("This driver does not appear to supportBinaryResource. No BinaryResource tests will be performed.");
            }
        }
        if (this.col.getService("TransactionService", "1.0") != null) {
            this.supportsTransactions = true;
        } else if (!this.quiet) {
            System.out.println("This driver does not appear to support the TransactionService. No transaction functionality will be tested.");
        }
        if (this.col.getService("XUpdateQueryService", "1.0") != null) {
            this.supportsXUpdate = true;
        } else if (!this.quiet) {
            System.out.println("This driver does not appear to support the XUpdateQueryService. No XUpdate functionality will be tested.");
        }
    }
}

