/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.support;

import java.util.ArrayList;
import java.util.Collections;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.LocalVariableAttribute;
import org.aspectj.lang.reflect.MethodSignature;
import wiki.xsx.core.support.MethodInfo;

public class MethodParser {
    private static final ClassPool POOL = ClassPool.getDefault();

    public static CtMethod getMethod(String className, String methodName) throws NotFoundException {
        return POOL.get(className).getDeclaredMethod(methodName);
    }

    public static MethodInfo getMethodInfo(String className, String methodName) {
        try {
            return MethodParser.getMethodInfo(MethodParser.getMethod(className, methodName), null);
        }
        catch (Exception e) {
            return new MethodInfo(className, className.substring(className.lastIndexOf(".")), methodName, new ArrayList<String>(0), -2);
        }
    }

    public static MethodInfo getMethodInfo(String className, String methodName, String[] parameterNames) {
        try {
            return MethodParser.getMethodInfo(MethodParser.getMethod(className, methodName), parameterNames);
        }
        catch (Exception e) {
            return new MethodInfo(className, className.substring(className.lastIndexOf(".")), methodName, new ArrayList<String>(0), -2);
        }
    }

    public static MethodInfo getMethodInfo(CtMethod method, String[] parameterNames) {
        CtClass declaringClass = method.getDeclaringClass();
        try {
            ArrayList<String> paramNames;
            javassist.bytecode.MethodInfo methodInfo = method.getMethodInfo();
            int lineNumber = methodInfo.getLineNumber(0);
            if (parameterNames != null) {
                paramNames = new ArrayList<String>(parameterNames.length);
                Collections.addAll(paramNames, parameterNames);
            } else {
                LocalVariableAttribute attribute = (LocalVariableAttribute)methodInfo.getCodeAttribute().getAttribute("LocalVariableTable");
                if (attribute != null) {
                    int count = method.getParameterTypes().length;
                    paramNames = new ArrayList(count);
                    for (int i = 1; i <= count; ++i) {
                        paramNames.add(attribute.variableName(i));
                    }
                } else {
                    paramNames = new ArrayList(0);
                }
            }
            return new MethodInfo(declaringClass.getName(), declaringClass.getSimpleName(), method.getName(), paramNames, lineNumber);
        }
        catch (Exception e) {
            return new MethodInfo(declaringClass.getName(), declaringClass.getSimpleName(), method.getName(), new ArrayList<String>(0), -2);
        }
    }

    public static MethodInfo getMethodInfo(MethodSignature signature, int lineNumber) {
        Class declaringClass = signature.getDeclaringType();
        String[] parameterNames = signature.getParameterNames();
        ArrayList<String> paramNames = new ArrayList<String>(parameterNames.length);
        Collections.addAll(paramNames, parameterNames);
        return new MethodInfo(declaringClass.getName(), declaringClass.getSimpleName(), signature.getName(), paramNames, lineNumber);
    }
}

