/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.util;

import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.hash.HashMapper;
import wiki.xsx.core.handler.BitmapHandler;
import wiki.xsx.core.handler.ClusterHandler;
import wiki.xsx.core.handler.CustomCommandHandler;
import wiki.xsx.core.handler.DBHandler;
import wiki.xsx.core.handler.GeoHandler;
import wiki.xsx.core.handler.HandlerManagerProxy;
import wiki.xsx.core.handler.HandlerType;
import wiki.xsx.core.handler.HashHandler;
import wiki.xsx.core.handler.HyperLogLogHandler;
import wiki.xsx.core.handler.KeyHandler;
import wiki.xsx.core.handler.ListHandler;
import wiki.xsx.core.handler.NumberHandler;
import wiki.xsx.core.handler.PubSubHandler;
import wiki.xsx.core.handler.RedisLockHandler;
import wiki.xsx.core.handler.ScriptHandler;
import wiki.xsx.core.handler.SentinelHandler;
import wiki.xsx.core.handler.SetHandler;
import wiki.xsx.core.handler.StreamHandler;
import wiki.xsx.core.handler.StringHandler;
import wiki.xsx.core.handler.TransactionHandler;
import wiki.xsx.core.handler.ZsetHandler;

public class RedisUtil {
    private static final HandlerManagerProxy MANAGER = new HandlerManagerProxy();

    public static DBHandler getDBHandler() {
        return (DBHandler)MANAGER.getHandler(HandlerType.DB);
    }

    public static DBHandler getDBHandler(int dbIndex) {
        return (DBHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.DB);
    }

    public static KeyHandler getKeyHandler() {
        return (KeyHandler)MANAGER.getHandler(HandlerType.KEY);
    }

    public static KeyHandler getKeyHandler(int dbIndex) {
        return (KeyHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.KEY);
    }

    public static NumberHandler getNumberHandler() {
        return (NumberHandler)MANAGER.getHandler(HandlerType.NUMBER);
    }

    public static NumberHandler getNumberHandler(int dbIndex) {
        return (NumberHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.NUMBER);
    }

    public static StringHandler getStringHandler() {
        return (StringHandler)MANAGER.getHandler(HandlerType.STRING);
    }

    public static StringHandler getStringHandler(int dbIndex) {
        return (StringHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.STRING);
    }

    public static HashHandler getHashHandler() {
        return (HashHandler)MANAGER.getHandler(HandlerType.HASH);
    }

    public static HashHandler getHashHandler(int dbIndex) {
        return (HashHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.HASH);
    }

    public static ListHandler getListHandler() {
        return (ListHandler)MANAGER.getHandler(HandlerType.LIST);
    }

    public static ListHandler getListHandler(int dbIndex) {
        return (ListHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.LIST);
    }

    public static SetHandler getSetHandler() {
        return (SetHandler)MANAGER.getHandler(HandlerType.SET);
    }

    public static SetHandler getSetHandler(int dbIndex) {
        return (SetHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.SET);
    }

    public static ZsetHandler getZsetHandler() {
        return (ZsetHandler)MANAGER.getHandler(HandlerType.ZSET);
    }

    public static ZsetHandler getZsetHandler(int dbIndex) {
        return (ZsetHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.ZSET);
    }

    public static HyperLogLogHandler getHyperLogLogHandler() {
        return (HyperLogLogHandler)MANAGER.getHandler(HandlerType.HYPERLOGLOG);
    }

    public static HyperLogLogHandler getHyperLogLogHandler(int dbIndex) {
        return (HyperLogLogHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.HYPERLOGLOG);
    }

    public static BitmapHandler getBitmapHandler() {
        return (BitmapHandler)MANAGER.getHandler(HandlerType.BITMAP);
    }

    public static BitmapHandler getBitmapHandler(int dbIndex) {
        return (BitmapHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.BITMAP);
    }

    public static GeoHandler getGeoHandler() {
        return (GeoHandler)MANAGER.getHandler(HandlerType.GEO);
    }

    public static GeoHandler getGeoHandler(int dbIndex) {
        return (GeoHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.GEO);
    }

    public static ScriptHandler getScriptHandler() {
        return (ScriptHandler)MANAGER.getHandler(HandlerType.SCRIPT);
    }

    public static ScriptHandler getScriptHandler(int dbIndex) {
        return (ScriptHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.SCRIPT);
    }

    public static PubSubHandler getPubSubHandler() {
        return (PubSubHandler)MANAGER.getHandler(HandlerType.PUBSUB);
    }

    public static PubSubHandler getPubSubHandler(int dbIndex) {
        return (PubSubHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.PUBSUB);
    }

    public static StreamHandler getStreamHandler() {
        return (StreamHandler)MANAGER.getHandler(HandlerType.STREAM);
    }

    public static StreamHandler getStreamHandler(int dbIndex) {
        return (StreamHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.STREAM);
    }

    public static StreamHandler getStreamHandler(int dbIndex, HashMapper<String, String, Object> mapper) {
        return MANAGER.getStreamHandler(dbIndex, mapper);
    }

    public static RedisLockHandler getRedisLockHandler() {
        return (RedisLockHandler)MANAGER.getHandler(HandlerType.REDISLOCK);
    }

    public static RedisLockHandler getRedisLockHandler(int dbIndex) {
        return (RedisLockHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.REDISLOCK);
    }

    public static SentinelHandler getSentinelHandler() {
        return (SentinelHandler)MANAGER.getHandler(HandlerType.SENTINEL);
    }

    public static SentinelHandler getSentinelHandler(int dbIndex) {
        return (SentinelHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.SENTINEL);
    }

    public static ClusterHandler getClusterHandler() {
        return (ClusterHandler)MANAGER.getHandler(HandlerType.CLUSTER);
    }

    public static CustomCommandHandler getCustomCommandHandler() {
        return (CustomCommandHandler)MANAGER.getHandler(HandlerType.CUSTOMCOMMAND);
    }

    public static CustomCommandHandler getCustomCommandHandler(int dbIndex) {
        return (CustomCommandHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.CUSTOMCOMMAND);
    }

    public static TransactionHandler getTransactionHandler() {
        return (TransactionHandler)MANAGER.getHandler(HandlerType.TRANSACTION);
    }

    public static TransactionHandler getTransactionHandler(int dbIndex) {
        return (TransactionHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.TRANSACTION);
    }

    public static RedisTemplate<String, Object> getDefaultRedisTemplate() {
        return MANAGER.getDefaultRedisTemplate();
    }

    public static StringRedisTemplate getDefaultStringRedisTemplate() {
        return MANAGER.getDefaultStringRedisTemplate();
    }
}

