/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.util;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.management.openmbean.SimpleType;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;
import wiki.xsx.core.handler.StreamHandler;

public class ConvertUtil {
    public static byte[][] toByteArray(RedisSerializer serializer, String ... args) {
        byte[][] bytes = new byte[args.length][];
        for (int i = 0; i < args.length; ++i) {
            bytes[i] = ConvertUtil.toBytes(serializer, args[i]);
        }
        return bytes;
    }

    public static byte[][] toByteArray(RedisSerializer serializer, String[] args2, String ... args1) {
        int i;
        int len1 = args1.length;
        int len2 = args2 == null ? 0 : args2.length;
        byte[][] bytes = new byte[len1 + len2][];
        for (i = 0; i < len1; ++i) {
            bytes[i] = ConvertUtil.toBytes(serializer, args1[i]);
        }
        for (i = 0; i < len2; ++i) {
            bytes[i + len1] = ConvertUtil.toBytes(serializer, args2[i]);
        }
        return bytes;
    }

    public static <K> byte[][] toByteArray(RedisSerializer keySerializer, RedisSerializer argsSerializer, List<K> keys, Object[] args) {
        Assert.notNull((Object)keySerializer, (String)"keySerializer must not be null");
        Assert.notNull((Object)argsSerializer, (String)"argsSerializer must not be null");
        int keySize = keys != null ? keys.size() : 0;
        byte[][] keysAndArgs = new byte[args.length + keySize][];
        int i = 0;
        if (keys != null) {
            for (Object key : keys) {
                if (key instanceof byte[]) {
                    keysAndArgs[i++] = (byte[])key;
                    continue;
                }
                keysAndArgs[i++] = keySerializer.serialize(key);
            }
        }
        for (Object arg : args) {
            keysAndArgs[i++] = arg instanceof byte[] ? (byte[])arg : argsSerializer.serialize(arg);
        }
        return keysAndArgs;
    }

    public static <T> Set<ZSetOperations.TypedTuple<T>> toTypedTupleSet(Map<Double, T> map) {
        if (map == null) {
            return null;
        }
        HashSet<ZSetOperations.TypedTuple<T>> set = new HashSet<ZSetOperations.TypedTuple<T>>(map.size());
        for (Map.Entry<Double, T> entry : map.entrySet()) {
            set.add((ZSetOperations.TypedTuple<T>)new DefaultTypedTuple(entry.getValue(), entry.getKey()));
        }
        return set;
    }

    public static <T> List<T> toList(GeoResults<RedisGeoCommands.GeoLocation<T>> results) {
        ArrayList<Object> list;
        if (results != null) {
            list = new ArrayList(results.getContent().size());
            for (GeoResult result : results) {
                list.add(((RedisGeoCommands.GeoLocation)result.getContent()).getName());
            }
        } else {
            list = new ArrayList<Object>(0);
        }
        return list;
    }

    public static <T> Map<T, Point> toMap(GeoResults<RedisGeoCommands.GeoLocation<T>> results) {
        HashMap<Object, Point> map;
        if (results != null) {
            map = new HashMap(results.getContent().size());
            for (GeoResult result : results) {
                map.put(((RedisGeoCommands.GeoLocation)result.getContent()).getName(), ((RedisGeoCommands.GeoLocation)result.getContent()).getPoint());
            }
        } else {
            map = new HashMap<Object, Point>(0);
        }
        return map;
    }

    public static <T> Map<Double, T> toMap(Set<ZSetOperations.TypedTuple<T>> set) {
        if (set == null) {
            return null;
        }
        LinkedHashMap<Double, Object> map = new LinkedHashMap<Double, Object>(set.size());
        for (ZSetOperations.TypedTuple<T> typedTuple : set) {
            map.put(typedTuple.getScore(), typedTuple.getValue());
        }
        return map;
    }

    public static <T> Map<Double, T> toMap(T ... values) {
        if (values == null) {
            return null;
        }
        HashMap<Double, T> map = new HashMap<Double, T>(values.length);
        for (int i = 0; i < values.length; ++i) {
            map.put(Double.valueOf(i), values[i]);
        }
        return map;
    }

    public static <T> Map<String, T> toMap(List<? extends Record<String, T>> list, StreamHandler.StreamDataType type) {
        HashMap<String, Object> data;
        if (list != null && list.size() > 0) {
            if (type == StreamHandler.StreamDataType.LATEST) {
                data = new HashMap(1);
                Record<String, T> record = list.get(list.size() - 1);
                data.put(record.getId().getValue(), record.getValue());
            } else if (type == StreamHandler.StreamDataType.EARLIEST) {
                data = new HashMap(1);
                Record<String, T> record = list.get(0);
                data.put(record.getId().getValue(), record.getValue());
            } else {
                data = new HashMap(list.size());
                for (Record<String, T> records : list) {
                    data.put(records.getId().getValue(), records.getValue());
                }
            }
        } else {
            data = new HashMap<String, Object>(0);
        }
        return data;
    }

    public static byte[] toBytes(RedisSerializer serializer, Object value) {
        Assert.notNull((Object)serializer, (String)"serializer must not be null");
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return serializer.serialize(value);
    }

    public static String toStr(RedisSerializer serializer, byte[] bytes) {
        Assert.notNull((Object)serializer, (String)"serializer must not be null");
        Object o = serializer.deserialize(bytes);
        return o == null ? null : o.toString();
    }

    public static <T> Object toJavaType(Object t, Class<T> type) {
        if (t == null) {
            return null;
        }
        if (t instanceof JSONObject) {
            return JSONUtil.toBean((JSONObject)((JSONObject)t), type);
        }
        if (t instanceof JSONArray) {
            return JSONUtil.toList((JSONArray)((JSONArray)t), type);
        }
        if (ConvertUtil.equals(t.getClass(), type)) {
            return t;
        }
        String str = t.toString();
        if (NumberUtil.isNumber((CharSequence)str)) {
            String typeName = type.getName();
            if (NumberUtil.isDouble((String)str)) {
                BigDecimal value = new BigDecimal(str);
                if (SimpleType.FLOAT.getTypeName().equals(typeName)) {
                    return Float.valueOf(value.floatValue());
                }
                return value.doubleValue();
            }
            BigInteger value = new BigInteger(str);
            if (SimpleType.INTEGER.getTypeName().equals(typeName)) {
                return value.intValue();
            }
            if (SimpleType.SHORT.getTypeName().equals(typeName)) {
                return value.shortValue();
            }
            return value.longValue();
        }
        return t;
    }

    public static Object toJavaType(RedisSerializer serializer, Object result) {
        if (result == null) {
            return null;
        }
        if (result instanceof List) {
            ArrayList<Object> newList = new ArrayList<Object>(20);
            ConvertUtil.parseList(serializer, newList, result);
            return newList;
        }
        if (result instanceof byte[]) {
            return serializer.deserialize((byte[])result);
        }
        return result;
    }

    private static void parseList(RedisSerializer serializer, List<Object> list, Object result) {
        if (result instanceof List) {
            List resultList = (List)result;
            ArrayList<Object> newList = new ArrayList<Object>(resultList.size());
            for (Object o : resultList) {
                ConvertUtil.parseList(serializer, newList, o);
            }
            list.add(newList);
        } else if (result instanceof byte[]) {
            list.add(serializer.deserialize((byte[])result));
        } else {
            list.add(result);
        }
    }

    public static boolean equals(Type a, Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            return Objects.equals(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(pa.getActualTypeArguments(), pb.getActualTypeArguments());
        }
        if (a instanceof GenericArrayType) {
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return ConvertUtil.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)a;
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)a;
            TypeVariable vb = (TypeVariable)b;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }
}

