/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import wiki.xsx.core.handler.CustomCommandHandler;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;
import wiki.xsx.core.util.ConvertUtil;
import wiki.xsx.core.util.RedisUtil;

public final class ZsetHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private ZSetOperations<String, Object> zSetOperations;
    private ZSetOperations<String, String> stringZSetOperations;
    private int dbIndex;

    ZsetHandler(Integer dbIndex) {
        this.dbIndex = dbIndex;
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
        this.zSetOperations = this.redisTemplate.opsForZSet();
        this.stringZSetOperations = this.stringRedisTemplate.opsForZSet();
    }

    ZsetHandler(TransactionHandler transactionHandler) {
        this.dbIndex = transactionHandler.getDbIndex();
        this.redisTemplate = transactionHandler.getRedisTemplate();
        this.stringRedisTemplate = transactionHandler.getStringRedisTemplate();
        this.zSetOperations = this.redisTemplate.opsForZSet();
        this.stringZSetOperations = this.stringRedisTemplate.opsForZSet();
    }

    public Boolean addAsObj(String key, Object value, double score) {
        return this.zSetOperations.add((Object)key, value, score);
    }

    public Boolean add(String key, String value, double score) {
        return this.stringZSetOperations.add((Object)key, (Object)value, score);
    }

    public Long addAsObj(String key, Map<Double, Object> map) {
        return this.zSetOperations.add((Object)key, ConvertUtil.toTypedTupleSet(map));
    }

    public Long add(String key, Map<Double, String> map) {
        return this.stringZSetOperations.add((Object)key, ConvertUtil.toTypedTupleSet(map));
    }

    public Long addAsObj(String key, Object ... values) {
        return this.addAsObj(key, ConvertUtil.toMap(values));
    }

    public Long add(String key, String ... values) {
        return this.add(key, ConvertUtil.toMap(values));
    }

    public Long sizeAsObj(String key) {
        return this.zSetOperations.zCard((Object)key);
    }

    public Long size(String key) {
        return this.stringZSetOperations.zCard((Object)key);
    }

    public Long countAsObj(String key, Double min, Double max) {
        return this.zSetOperations.count((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Long count(String key, Double min, Double max) {
        return this.stringZSetOperations.count((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Set rangeAsObj(String key, Long startIndex, Long endIndex) {
        return this.zSetOperations.range((Object)key, startIndex.longValue(), endIndex.longValue());
    }

    public Set<String> range(String key, Long startIndex, Long endIndex) {
        return this.stringZSetOperations.range((Object)key, startIndex.longValue(), endIndex.longValue());
    }

    public Set rangeByLexAsObj(String key, Object startSortElement, boolean isContainsStart, Object endSortElement, boolean isContainsEnd) {
        return this.zSetOperations.rangeByLex((Object)key, this.getRange(startSortElement, isContainsStart, endSortElement, isContainsEnd));
    }

    public Set<String> rangeByLex(String key, String startSortElement, boolean isContainsStart, String endSortElement, boolean isContainsEnd) {
        return this.stringZSetOperations.rangeByLex((Object)key, this.getRange(startSortElement, isContainsStart, endSortElement, isContainsEnd));
    }

    public Set ascRangeByLexAsObj(String key, Object startSortElement, boolean isContainsStart, Object endSortElement, boolean isContainsEnd, Integer count, Integer offset) {
        return this.zSetOperations.rangeByLex((Object)key, this.getRange(startSortElement, isContainsStart, endSortElement, isContainsEnd), RedisZSetCommands.Limit.limit().count(count.intValue()).offset(offset.intValue()));
    }

    public Set<String> rangeByLex(String key, String startSortElement, boolean isContainsStart, String endSortElement, boolean isContainsEnd, Integer count, Integer offset) {
        return this.stringZSetOperations.rangeByLex((Object)key, this.getRange(startSortElement, isContainsStart, endSortElement, isContainsEnd), RedisZSetCommands.Limit.limit().count(count.intValue()).offset(offset.intValue()));
    }

    public Set rangeByScoreAsObj(String key, Double min, Double max, Long count, Long offset) {
        return this.zSetOperations.rangeByScore((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue());
    }

    public Set<String> rangeByScore(String key, Double min, Double max, Long count, Long offset) {
        return this.stringZSetOperations.rangeByScore((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue());
    }

    public Set reverseRangeByScoreAsObj(String key, Double min, Double max, Long count, Long offset) {
        return this.zSetOperations.reverseRangeByScore((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue());
    }

    public Set<String> reverseRangeByScore(String key, Double min, Double max, Long count, Long offset) {
        return this.stringZSetOperations.reverseRangeByScore((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue());
    }

    public Map<Double, Object> rangeByScoreAsObj(String key, Long startSortIndex, Long endSortIndex) {
        return ConvertUtil.toMap(this.zSetOperations.rangeWithScores((Object)key, startSortIndex.longValue(), endSortIndex.longValue()));
    }

    public Map<Double, String> rangeByScore(String key, Long startSortIndex, Long endSortIndex) {
        return ConvertUtil.toMap(this.stringZSetOperations.rangeWithScores((Object)key, startSortIndex.longValue(), endSortIndex.longValue()));
    }

    public Map<Double, Object> rangeByScoreWithScoresAsObj(String key, Double min, Double max) {
        return ConvertUtil.toMap(this.zSetOperations.rangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue()));
    }

    public Map<Double, String> rangeByScoreWithScores(String key, Double min, Double max) {
        return ConvertUtil.toMap(this.stringZSetOperations.rangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue()));
    }

    public Map<Double, Object> rangeByScoreWithScoresAsObj(String key, Double min, Double max, Long count, Long offset) {
        return ConvertUtil.toMap(this.zSetOperations.rangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue()));
    }

    public Map<Double, String> rangeByScoreWithScores(String key, Double min, Double max, Long count, Long offset) {
        return ConvertUtil.toMap(this.stringZSetOperations.rangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue()));
    }

    public Set getAllAsObj(String key) {
        return this.rangeAsObj(key, 0L, -1L);
    }

    public Set<String> getAll(String key) {
        return this.range(key, 0L, -1L);
    }

    public Map<Double, Object> getAllByScoreAsObj(String key) {
        return this.rangeByScoreAsObj(key, 0L, -1L);
    }

    public Map<Double, String> getAllByScore(String key) {
        return this.rangeByScore(key, 0L, -1L);
    }

    public Long sortIndexAsObj(String key, Object value) {
        return this.zSetOperations.rank((Object)key, value);
    }

    public Long sortIndex(String key, String value) {
        return this.stringZSetOperations.rank((Object)key, (Object)value);
    }

    public Double scoreAsObj(String key, Object value) {
        return this.zSetOperations.score((Object)key, value);
    }

    public Double score(String key, String value) {
        return this.stringZSetOperations.score((Object)key, (Object)value);
    }

    public Double incrementScoreAsObj(String key, Object value, Double score) {
        return this.zSetOperations.incrementScore((Object)key, value, score.doubleValue());
    }

    public Double incrementScore(String key, String value, Double score) {
        return this.stringZSetOperations.incrementScore((Object)key, (Object)value, score.doubleValue());
    }

    public Long removeAsObj(String key, Object ... values) {
        return this.zSetOperations.remove((Object)key, values);
    }

    public Long remove(String key, String ... values) {
        return this.stringZSetOperations.remove((Object)key, (Object[])values);
    }

    public Long ascRemoveRangeAsObj(String key, Long startSortIndex, Long endSortIndex) {
        return this.zSetOperations.removeRange((Object)key, startSortIndex.longValue(), endSortIndex.longValue());
    }

    public Long ascRemoveRange(String key, Long startSortIndex, Long endSortIndex) {
        return this.stringZSetOperations.removeRange((Object)key, startSortIndex.longValue(), endSortIndex.longValue());
    }

    public Long descRemoveRangeAsObj(String key, Long startSortIndex, Long endSortIndex) {
        return this.ascRemoveRangeAsObj(key, -endSortIndex.longValue() - 1L, -startSortIndex.longValue() - 1L);
    }

    public Long descRemoveRange(String key, Long startSortIndex, Long endSortIndex) {
        return this.ascRemoveRange(key, -endSortIndex.longValue() - 1L, -startSortIndex.longValue() - 1L);
    }

    public Long removeRangeByScoreAsObj(String key, Double min, Double max) {
        return this.zSetOperations.removeRangeByScore((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Long removeRangeByScore(String key, Double min, Double max) {
        return this.stringZSetOperations.removeRangeByScore((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Long intersectAndStoreAsObj(String key, String storeKey, String ... otherKys) {
        return this.zSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long intersectAndStore(String key, String storeKey, String ... otherKys) {
        return this.stringZSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long intersectAndStoreAsObj(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, String ... otherKys) {
        return this.zSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate);
    }

    public Long intersectAndStore(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, String ... otherKys) {
        return this.stringZSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate, weights);
    }

    public Long intersectAndStoreAsObj(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, String ... otherKys) {
        return this.zSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate, weights);
    }

    public Long intersectAndStore(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, Double weight, String ... otherKys) {
        return this.stringZSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate);
    }

    public Map<Double, Object> intersectByScoreAsObj(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.intersectAndStoreAsObj(key, tempKey, otherKys);
        Map<Double, Object> map = this.getAllByScoreAsObj(tempKey);
        this.redisTemplate.delete((Object)tempKey);
        return map;
    }

    public Map<Double, String> intersectByScore(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.intersectAndStore(key, tempKey, otherKys);
        Map<Double, String> map = this.getAllByScore(tempKey);
        this.stringRedisTemplate.delete((Object)tempKey);
        return map;
    }

    public Set intersectAsObj(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.intersectAndStoreAsObj(key, tempKey, otherKys);
        Set set = this.getAllAsObj(tempKey);
        this.redisTemplate.delete((Object)tempKey);
        return set;
    }

    public Set<String> intersect(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.intersectAndStore(key, tempKey, otherKys);
        Set<String> set = this.getAll(tempKey);
        this.stringRedisTemplate.delete((Object)tempKey);
        return set;
    }

    public Long unionAndStoreAsObj(String key, String storeKey, String ... otherKys) {
        return this.zSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long unionAndStore(String key, String storeKey, String ... otherKys) {
        return this.stringZSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long unionAndStoreAsObj(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, String ... otherKys) {
        return this.zSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate);
    }

    public Long unionAndStore(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, String ... otherKys) {
        return this.stringZSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate, weights);
    }

    public Long unionAndStoreAsObj(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, String ... otherKys) {
        return this.zSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate, weights);
    }

    public Long unionAndStore(String key, String storeKey, RedisZSetCommands.Aggregate aggregate, Double weight, String ... otherKys) {
        return this.stringZSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey, aggregate);
    }

    public Map<Double, Object> unionByScoreAsObj(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.unionAndStoreAsObj(key, tempKey, otherKys);
        Map<Double, Object> map = this.getAllByScoreAsObj(tempKey);
        this.redisTemplate.delete((Object)tempKey);
        return map;
    }

    public Map<Double, String> unionByScore(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.unionAndStore(key, tempKey, otherKys);
        Map<Double, String> map = this.getAllByScore(tempKey);
        this.stringRedisTemplate.delete((Object)tempKey);
        return map;
    }

    public Set unionAsObj(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.unionAndStore(key, tempKey, otherKys);
        Set set = this.getAllAsObj(tempKey);
        this.redisTemplate.delete((Object)tempKey);
        return set;
    }

    public Set<String> union(String key, String ... otherKys) {
        String tempKey = UUID.randomUUID().toString();
        this.unionAndStore(key, tempKey, otherKys);
        Set<String> set = this.getAll(tempKey);
        this.stringRedisTemplate.delete((Object)tempKey);
        return set;
    }

    public Long reverseSortIndexAsObj(String key, Object value) {
        return this.zSetOperations.reverseRank((Object)key, value);
    }

    public Long reverseSortIndex(String key, String value) {
        return this.stringZSetOperations.reverseRank((Object)key, (Object)value);
    }

    public Set reverseRangeAsObj(String key, Long startIndex, Long endIndex) {
        return this.zSetOperations.reverseRange((Object)key, startIndex.longValue(), endIndex.longValue());
    }

    public Set<String> reverseRange(String key, Long startIndex, Long endIndex) {
        return this.stringZSetOperations.reverseRange((Object)key, startIndex.longValue(), endIndex.longValue());
    }

    public Set reverseRangeByScoreAsObj(String key, Double min, Double max) {
        return this.zSetOperations.reverseRangeByScore((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Set<String> reverseRangeByScore(String key, Double min, Double max) {
        return this.stringZSetOperations.reverseRangeByScore((Object)key, min.doubleValue(), max.doubleValue());
    }

    public Map<Double, Object> reverseRangeByScoreAsObj(String key, Long startIndex, Long endIndex) {
        return ConvertUtil.toMap(this.zSetOperations.reverseRangeWithScores((Object)key, startIndex.longValue(), endIndex.longValue()));
    }

    public Map<Double, String> reverseRangeByScore(String key, Long startIndex, Long endIndex) {
        return ConvertUtil.toMap(this.stringZSetOperations.reverseRangeWithScores((Object)key, startIndex.longValue(), endIndex.longValue()));
    }

    public Map<Double, Object> reverseRangeByScoreWithScoresAsObj(String key, Double min, Double max) {
        return ConvertUtil.toMap(this.zSetOperations.reverseRangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue()));
    }

    public Map<Double, String> reverseRangeByScoreWithScores(String key, Double min, Double max) {
        return ConvertUtil.toMap(this.stringZSetOperations.reverseRangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue()));
    }

    public Map<Double, Object> reverseRangeByScoreWithScoresAsObj(String key, Double min, Double max, Long count, Long offset) {
        return ConvertUtil.toMap(this.zSetOperations.reverseRangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue()));
    }

    public Map<Double, String> reverseRangeByScoreWithScores(String key, Double min, Double max, Long count, Long offset) {
        return ConvertUtil.toMap(this.stringZSetOperations.reverseRangeByScoreWithScores((Object)key, min.doubleValue(), max.doubleValue(), offset.longValue(), count.longValue()));
    }

    public Cursor<ZSetOperations.TypedTuple<Object>> scanAsObj(String key, Long count, String pattern) {
        return this.zSetOperations.scan((Object)key, ScanOptions.scanOptions().count(count.longValue()).match(pattern).build());
    }

    public Cursor<ZSetOperations.TypedTuple<String>> scan(String key, Long count, String pattern) {
        return this.stringZSetOperations.scan((Object)key, ScanOptions.scanOptions().count(count.longValue()).match(pattern).build());
    }

    public Object popMaxAsObj(String key) {
        return this.popMaxAsObj(key, 1).get(0);
    }

    public String popMax(String key) {
        return this.popMax(key, 1).get(0);
    }

    public List popMaxAsObj(String key, int count) {
        return this.getPopResult("ZPOPMAX", key, count, this.redisTemplate.getValueSerializer()).get("values");
    }

    public List<String> popMax(String key, int count) {
        ArrayList<String> data = new ArrayList<String>(count);
        Map<String, List<Object>> popResult = this.getPopResult("ZPOPMAX", key, count, this.stringRedisTemplate.getValueSerializer());
        List<Object> valueList = popResult.get("values");
        for (int i = 0; i < count; ++i) {
            data.add(String.valueOf(valueList.get(i)));
        }
        return data;
    }

    public Map<Double, Object> popMaxByScoreAsObj(String key, int count) {
        return this.getPopMap("ZPOPMAX", key, count, true);
    }

    public Map<Double, String> popMaxByScore(String key, int count) {
        return this.getPopMap("ZPOPMAX", key, count, false);
    }

    public Object popMinAsObj(String key) {
        return this.popMinAsObj(key, 1).get(0);
    }

    public String popMin(String key) {
        return this.popMin(key, 1).get(0);
    }

    public List popMinAsObj(String key, int count) {
        return this.getPopResult("ZPOPMIN", key, count, this.redisTemplate.getValueSerializer()).get("values");
    }

    public List<String> popMin(String key, int count) {
        ArrayList<String> data = new ArrayList<String>(count);
        Map<String, List<Object>> popResult = this.getPopResult("ZPOPMIN", key, count, this.stringRedisTemplate.getValueSerializer());
        List<Object> valueList = popResult.get("values");
        for (int i = 0; i < count; ++i) {
            data.add(String.valueOf(valueList.get(i)));
        }
        return data;
    }

    public Map<Double, Object> popMinByScoreAsObj(String key, int count) {
        return this.getPopMap("ZPOPMIN", key, count, true);
    }

    public Map<Double, String> popMinByScore(String key, int count) {
        return this.getPopMap("ZPOPMIN", key, count, false);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    private RedisZSetCommands.Range getRange(Object startSortElement, boolean isContainsStart, Object endSortElement, boolean isContainsEnd) {
        RedisZSetCommands.Range range = RedisZSetCommands.Range.range();
        if (isContainsStart) {
            range.gte(startSortElement);
        } else {
            range.gt(startSortElement);
        }
        if (isContainsEnd) {
            range.lte(endSortElement);
        } else {
            range.lt(endSortElement);
        }
        return range;
    }

    private Map<Double, ?> getPopMap(String command, String key, int count, boolean isObject) {
        Map<String, List<Object>> popResult = this.getPopResult(command, key, count, this.stringRedisTemplate.getValueSerializer());
        List<Object> keyList = popResult.get("keys");
        List<Object> valueList = popResult.get("values");
        if (isObject) {
            LinkedHashMap<Double, String> data = new LinkedHashMap<Double, String>(count);
            for (int i = 0; i < count; ++i) {
                data.put(Double.valueOf(String.valueOf(keyList.get(i))), String.valueOf(valueList.get(i)));
            }
            return data;
        }
        HashMap<Double, Object> data = new HashMap<Double, Object>(count);
        for (int i = 0; i < count; ++i) {
            data.put(Double.valueOf(String.valueOf(keyList.get(i))), valueList.get(i));
        }
        return data;
    }

    private Map<String, List<Object>> getPopResult(String command, String key, int count, RedisSerializer redisSerializer) {
        CustomCommandHandler commandHandler = RedisUtil.getCustomCommandHandler(this.dbIndex);
        List list = (List)ConvertUtil.toJavaType(redisSerializer, commandHandler.execute(command, commandHandler.serialize(key), commandHandler.serialize(String.valueOf(count))));
        HashMap<String, List<Object>> data = new HashMap<String, List<Object>>(2);
        ArrayList keyList = new ArrayList(count);
        ArrayList valueList = new ArrayList(count);
        if (list != null && list.size() > 0) {
            List dataList = (List)list.get(0);
            for (int i = 0; i < count; ++i) {
                int scoreIndex = (i + 1) * 2 - 1;
                int valueIndex = i * 2;
                keyList.add(dataList.get(scoreIndex));
                valueList.add(dataList.get(valueIndex));
            }
        }
        data.put("keys", keyList);
        data.put("values", valueList);
        return data;
    }
}

