/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.hash.HashMapper;
import wiki.xsx.core.handler.BitmapHandler;
import wiki.xsx.core.handler.ClusterHandler;
import wiki.xsx.core.handler.CustomCommandHandler;
import wiki.xsx.core.handler.DBHandler;
import wiki.xsx.core.handler.GeoHandler;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.HashHandler;
import wiki.xsx.core.handler.HyperLogLogHandler;
import wiki.xsx.core.handler.KeyHandler;
import wiki.xsx.core.handler.ListHandler;
import wiki.xsx.core.handler.NumberHandler;
import wiki.xsx.core.handler.PubSubHandler;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.ScriptHandler;
import wiki.xsx.core.handler.SentinelHandler;
import wiki.xsx.core.handler.SetHandler;
import wiki.xsx.core.handler.StreamHandler;
import wiki.xsx.core.handler.StringHandler;
import wiki.xsx.core.handler.ZsetHandler;

public final class TransactionHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private int dbIndex;

    TransactionHandler(Integer dbIndex) {
        this.dbIndex = dbIndex;
        List<RedisTemplate> templateList = HandlerManager.createTemplate(this.dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
    }

    public List executeAsObj(Function<TransactionHandler, List> executor) {
        return this.execute(executor, this.redisTemplate);
    }

    public List execute(Function<TransactionHandler, List> executor) {
        return this.execute(executor, (RedisTemplate)this.stringRedisTemplate);
    }

    public void watchAsObj(String ... keys) {
        this.redisTemplate.watch(Arrays.asList(keys));
    }

    public void watch(String ... keys) {
        this.stringRedisTemplate.watch(Arrays.asList(keys));
    }

    public void unwatchAsObj() {
        this.redisTemplate.unwatch();
    }

    public void unwatch() {
        this.stringRedisTemplate.unwatch();
    }

    public void beginTransactionAsObj() {
        this.redisTemplate.multi();
    }

    public void beginTransaction() {
        this.stringRedisTemplate.multi();
    }

    public List commitAsObj() {
        return this.redisTemplate.exec();
    }

    public List commit() {
        return this.stringRedisTemplate.exec();
    }

    public void cancelTransactionAsObj() {
        this.redisTemplate.discard();
    }

    public void cancelTransaction() {
        this.stringRedisTemplate.discard();
    }

    public DBHandler getDBHandler() {
        return new DBHandler(this);
    }

    public KeyHandler getKeyHandler() {
        return new KeyHandler(this);
    }

    public NumberHandler getNumberHandler() {
        return new NumberHandler(this);
    }

    public StringHandler getStringHandler() {
        return new StringHandler(this);
    }

    public HashHandler getHashHandler() {
        return new HashHandler(this);
    }

    public ListHandler getListHandler() {
        return new ListHandler(this);
    }

    public SetHandler getSetHandler() {
        return new SetHandler(this);
    }

    public ZsetHandler getZsetHandler() {
        return new ZsetHandler(this);
    }

    public HyperLogLogHandler getHyperLogLogHandler() {
        return new HyperLogLogHandler(this);
    }

    public BitmapHandler getBitmapHandler() {
        return new BitmapHandler(this);
    }

    public GeoHandler getGeoHandler() {
        return new GeoHandler(this);
    }

    public ScriptHandler getScriptHandler() {
        return new ScriptHandler(this);
    }

    public PubSubHandler getPubSubHandler() {
        return new PubSubHandler(this);
    }

    public StreamHandler getStreamHandler() {
        return new StreamHandler(this);
    }

    public StreamHandler getStreamHandler(HashMapper<String, String, Object> hashMapper) {
        return new StreamHandler(this, hashMapper);
    }

    public SentinelHandler getSentinelHandler() {
        return new SentinelHandler(this);
    }

    public ClusterHandler getClusterHandler() {
        return new ClusterHandler(this);
    }

    public CustomCommandHandler getCustomCommandHandler() {
        return new CustomCommandHandler(this);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public int getDbIndex() {
        return this.dbIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List execute(Function<TransactionHandler, List> executor, RedisTemplate redisTemplate) {
        RedisConnectionFactory factory = redisTemplate.getRequiredConnectionFactory();
        RedisConnectionUtils.bindConnection((RedisConnectionFactory)factory, (boolean)true);
        try {
            List list = executor.apply(this);
            return list;
        }
        finally {
            RedisConnectionUtils.unbindConnection((RedisConnectionFactory)factory);
        }
    }
}

