/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.data.redis.hash.HashMapper;
import wiki.xsx.core.handler.CustomCommandHandler;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;
import wiki.xsx.core.util.ConvertUtil;
import wiki.xsx.core.util.RedisUtil;

public final class StreamHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StreamOperations<String, String, Object> streamOperations;
    private int dbIndex;

    StreamHandler(Integer dbIndex) {
        this.dbIndex = dbIndex;
        this.redisTemplate = HandlerManager.createRedisTemplate(dbIndex);
        this.streamOperations = this.redisTemplate.opsForStream();
    }

    StreamHandler(Integer dbIndex, HashMapper<String, String, Object> hashMapper) {
        this.dbIndex = dbIndex;
        this.redisTemplate = HandlerManager.createRedisTemplate(dbIndex);
        this.streamOperations = this.redisTemplate.opsForStream(hashMapper);
    }

    StreamHandler(TransactionHandler transactionHandler) {
        this.dbIndex = transactionHandler.getDbIndex();
        this.redisTemplate = transactionHandler.getRedisTemplate();
        this.streamOperations = this.redisTemplate.opsForStream();
    }

    StreamHandler(TransactionHandler transactionHandler, HashMapper<String, String, Object> hashMapper) {
        this.dbIndex = transactionHandler.getDbIndex();
        this.redisTemplate = transactionHandler.getRedisTemplate();
        this.streamOperations = this.redisTemplate.opsForStream(hashMapper);
    }

    public Long size(String key) {
        return this.streamOperations.size((Object)key);
    }

    public RecordId add(String key, Map<String, Object> value) {
        return this.streamOperations.add((Object)key, value);
    }

    public RecordId add(String key, Object value) {
        return this.streamOperations.add((Record)StreamRecords.newRecord().in((Object)key).ofObject(value));
    }

    public RecordId add(Record record) {
        return this.streamOperations.add(record);
    }

    public Long trim(String key, long count) {
        return this.streamOperations.trim((Object)key, count);
    }

    public Long remove(String key, String ... recordIds) {
        return this.streamOperations.delete((Object)key, recordIds);
    }

    public void createGroup(String key, String groupName) {
        this.streamOperations.createGroup((Object)key, groupName);
    }

    public void createGroup(String key, ReadOffset readOffset, String groupName) {
        this.streamOperations.createGroup((Object)key, readOffset, groupName);
    }

    public Boolean removeGroup(String key, String groupName) {
        return this.streamOperations.destroyGroup((Object)key, groupName);
    }

    public Boolean removeConsumer(String key, String groupName, String consumerName) {
        return this.streamOperations.deleteConsumer((Object)key, Consumer.from((String)groupName, (String)consumerName));
    }

    public Long ack(String key, String groupName, String ... recordIds) {
        return this.streamOperations.acknowledge((Object)key, groupName, recordIds);
    }

    public Object claim(String key, String groupName, String consumerName, long timeout, String ... recordIds) {
        return RedisUtil.getCustomCommandHandler(this.dbIndex).execute("XCLAIM", ConvertUtil.toByteArray(this.redisTemplate.getKeySerializer(), recordIds, new String[]{key, groupName, consumerName, String.valueOf(timeout)}));
    }

    public Map<String, Object> pending(String key, String groupName) {
        List list = (List)ConvertUtil.toJavaType(this.redisTemplate.getKeySerializer(), RedisUtil.getCustomCommandHandler(this.dbIndex).execute("XPENDING", ConvertUtil.toByteArray(this.redisTemplate.getKeySerializer(), key, groupName)));
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        if (list == null) {
            data.put("count", 0);
            data.put("minId", null);
            data.put("maxId", null);
            data.put("consumers", new ArrayList(0));
        } else {
            List dataList = (List)list.get(0);
            data.put("count", dataList.get(0));
            data.put("minId", dataList.get(1));
            data.put("maxId", dataList.get(2));
            data.put("consumers", dataList.get(3));
        }
        return data;
    }

    public List<Map<String, Object>> pending(String key, String groupName, int count) {
        return this.toPendingResult((List)ConvertUtil.toJavaType(this.redisTemplate.getKeySerializer(), RedisUtil.getCustomCommandHandler(this.dbIndex).execute("XPENDING", ConvertUtil.toByteArray(this.redisTemplate.getKeySerializer(), key, groupName, "-", "+", String.valueOf(count)))));
    }

    public List<Map<String, Object>> pending(String key, String groupName, String consumerName, int count) {
        return this.toPendingResult((List)ConvertUtil.toJavaType(this.redisTemplate.getKeySerializer(), RedisUtil.getCustomCommandHandler(this.dbIndex).execute("XPENDING", ConvertUtil.toByteArray(this.redisTemplate.getKeySerializer(), key, groupName, "-", "+", String.valueOf(count), consumerName))));
    }

    public Map<String, Object> readEarliest(String ... keys) {
        return this.readEarliest(StreamReadOptions.empty(), keys);
    }

    public <T> Map<String, T> readEarliest(Class<T> resultType, String ... keys) {
        return this.readEarliest(resultType, StreamReadOptions.empty(), keys);
    }

    public Map<String, Object> readEarliest(StreamReadOptions readOptions, String ... keys) {
        return ConvertUtil.toMap(this.streamOperations.read(readOptions.count(1L), this.createStreamOffsetByKeys(keys)), StreamDataType.EARLIEST);
    }

    public <T> Map<String, T> readEarliest(Class<T> resultType, StreamReadOptions readOptions, String ... keys) {
        return ConvertUtil.toMap(this.streamOperations.read(resultType, readOptions.count(1L), this.createStreamOffsetByKeys(keys)), StreamDataType.EARLIEST);
    }

    public Map<String, Object> readLatest(String ... keys) {
        return this.readLatest(StreamReadOptions.empty(), keys);
    }

    public <T> Map<String, T> readLatest(Class<T> resultType, String ... keys) {
        return this.readLatest(resultType, StreamReadOptions.empty(), keys);
    }

    public Map<String, Object> readLatest(StreamReadOptions readOptions, String ... keys) {
        return ConvertUtil.toMap(this.streamOperations.read(readOptions, this.createStreamOffsetByKeys(keys)), StreamDataType.LATEST);
    }

    public <T> Map<String, T> readLatest(Class<T> resultType, StreamReadOptions readOptions, String ... keys) {
        return ConvertUtil.toMap(this.streamOperations.read(resultType, readOptions, this.createStreamOffsetByKeys(keys)), StreamDataType.LATEST);
    }

    public Map<String, Object> read(String key, String ... recordIds) {
        return this.read(StreamReadOptions.empty(), key, recordIds);
    }

    public <T> Map<String, T> read(Class<T> resultType, String key, String ... recordIds) {
        return this.read(resultType, StreamReadOptions.empty(), key, recordIds);
    }

    public Map<String, Object> read(StreamReadOptions readOptions, String key, String ... recordIds) {
        return ConvertUtil.toMap(this.streamOperations.read(readOptions, this.createStreamOffsetByRecordIds(key, recordIds)), StreamDataType.ALL);
    }

    public <T> Map<String, T> read(Class<T> resultType, StreamReadOptions readOptions, String key, String ... recordIds) {
        return ConvertUtil.toMap(this.streamOperations.read(resultType, readOptions, this.createStreamOffsetByRecordIds(key, recordIds)), StreamDataType.ALL);
    }

    public Map<String, Object> read(Map<String, String> keyRecordIdMap) {
        return this.read(StreamReadOptions.empty(), keyRecordIdMap);
    }

    public <T> Map<String, T> read(Class<T> resultType, Map<String, String> keyRecordIdMap) {
        return this.read(resultType, StreamReadOptions.empty(), keyRecordIdMap);
    }

    public Map<String, Object> read(StreamReadOptions readOptions, Map<String, String> keyRecordIdMap) {
        return ConvertUtil.toMap(this.streamOperations.read(readOptions, this.createStreamOffset(keyRecordIdMap)), StreamDataType.ALL);
    }

    public <T> Map<String, T> read(Class<T> resultType, StreamReadOptions readOptions, Map<String, String> keyRecordIdMap) {
        return ConvertUtil.toMap(this.streamOperations.read(resultType, readOptions, this.createStreamOffset(keyRecordIdMap)), StreamDataType.ALL);
    }

    public Map<String, Object> readEarliestByConsumer(Consumer consumer, String ... keys) {
        return this.readEarliestByConsumer(consumer, StreamReadOptions.empty(), keys);
    }

    public <T> Map<String, T> readEarliestByConsumer(Class<T> resultType, Consumer consumer, String ... keys) {
        return this.readEarliestByConsumer(resultType, consumer, StreamReadOptions.empty(), keys);
    }

    public Map<String, Object> readEarliestByConsumer(Consumer consumer, StreamReadOptions readOptions, String ... keys) {
        return ConvertUtil.toMap(this.streamOperations.read(consumer, readOptions.count(1L), this.createStreamOffsetByKeys(keys)), StreamDataType.EARLIEST);
    }

    public <T> Map<String, T> readEarliestByConsumer(Class<T> resultType, Consumer consumer, StreamReadOptions readOptions, String ... keys) {
        return ConvertUtil.toMap(this.streamOperations.read(resultType, consumer, readOptions.count(1L), this.createStreamOffsetByKeys(keys)), StreamDataType.EARLIEST);
    }

    public Map<String, Object> readLatestByConsumer(Consumer consumer, String ... keys) {
        return this.readLatestByConsumer(consumer, StreamReadOptions.empty(), keys);
    }

    public <T> Map<String, T> readLatestByConsumer(Class<T> resultType, Consumer consumer, String ... keys) {
        return this.readLatestByConsumer(resultType, consumer, StreamReadOptions.empty(), keys);
    }

    public Map<String, Object> readLatestByConsumer(Consumer consumer, StreamReadOptions readOptions, String ... keys) {
        return ConvertUtil.toMap(this.streamOperations.read(consumer, readOptions, this.createStreamOffsetByKeys(keys)), StreamDataType.LATEST);
    }

    public <T> Map<String, T> readLatestByConsumer(Class<T> resultType, Consumer consumer, StreamReadOptions readOptions, String ... keys) {
        return ConvertUtil.toMap(this.streamOperations.read(resultType, consumer, readOptions, this.createStreamOffsetByKeys(keys)), StreamDataType.LATEST);
    }

    public Map<String, Object> readByConsumer(Consumer consumer, String key, String ... recordIds) {
        return this.readByConsumer(consumer, StreamReadOptions.empty(), key, recordIds);
    }

    public <T> Map<String, T> readByConsumer(Class<T> resultType, Consumer consumer, String key, String ... recordIds) {
        return this.readByConsumer(resultType, consumer, StreamReadOptions.empty(), key, recordIds);
    }

    public Map<String, Object> readByConsumer(Consumer consumer, StreamReadOptions readOptions, String key, String ... recordIds) {
        return ConvertUtil.toMap(this.streamOperations.read(consumer, readOptions, this.createStreamOffsetByRecordIds(key, recordIds)), StreamDataType.ALL);
    }

    public <T> Map<String, T> readByConsumer(Class<T> resultType, Consumer consumer, StreamReadOptions readOptions, String key, String ... recordIds) {
        return ConvertUtil.toMap(this.streamOperations.read(resultType, consumer, readOptions, this.createStreamOffsetByRecordIds(key, recordIds)), StreamDataType.ALL);
    }

    public Map<String, Object> readByConsumer(Consumer consumer, Map<String, String> keyRecordIdMap) {
        return this.readByConsumer(consumer, StreamReadOptions.empty(), keyRecordIdMap);
    }

    public <T> Map<String, T> readByConsumer(Class<T> resultType, Consumer consumer, Map<String, String> keyRecordIdMap) {
        return this.readByConsumer(resultType, consumer, StreamReadOptions.empty(), keyRecordIdMap);
    }

    public Map<String, Object> readByConsumer(Consumer consumer, StreamReadOptions readOptions, Map<String, String> keyRecordIdMap) {
        return ConvertUtil.toMap(this.streamOperations.read(consumer, readOptions, this.createStreamOffset(keyRecordIdMap)), StreamDataType.ALL);
    }

    public <T> Map<String, T> readByConsumer(Class<T> resultType, Consumer consumer, StreamReadOptions readOptions, Map<String, String> keyRecordIdMap) {
        return ConvertUtil.toMap(this.streamOperations.read(resultType, consumer, readOptions, this.createStreamOffset(keyRecordIdMap)), StreamDataType.ALL);
    }

    public Map<String, Object> get(String key, String recordId) {
        return this.range(key, recordId, recordId).get(recordId);
    }

    public <T> T get(Class<T> resultType, String key, String recordId) {
        return this.range(resultType, key, recordId, recordId).get(recordId);
    }

    public Map<String, Map<String, Object>> range(String key) {
        return this.range(key, "-", "+");
    }

    public <T> Map<String, T> range(Class<T> resultType, String key) {
        return this.range(resultType, key, "-", "+");
    }

    public Map<String, Map<String, Object>> range(String key, int count) {
        return this.range(key, "-", "+", count);
    }

    public <T> Map<String, T> range(Class<T> resultType, String key, int count) {
        return this.range(resultType, key, "-", "+", count);
    }

    public Map<String, Map<String, Object>> range(String key, String minRecordId, String maxRecordId) {
        return ConvertUtil.toMap(this.streamOperations.range((Object)key, Range.of((Range.Bound)Range.Bound.inclusive((Comparable)((Object)minRecordId)), (Range.Bound)Range.Bound.inclusive((Comparable)((Object)maxRecordId)))), StreamDataType.ALL);
    }

    public <T> Map<String, T> range(Class<T> resultType, String key, String minRecordId, String maxRecordId) {
        return ConvertUtil.toMap(this.streamOperations.range(resultType, (Object)key, Range.of((Range.Bound)Range.Bound.inclusive((Comparable)((Object)minRecordId)), (Range.Bound)Range.Bound.inclusive((Comparable)((Object)maxRecordId)))), StreamDataType.ALL);
    }

    public Map<String, Map<String, Object>> range(String key, String minRecordId, String maxRecordId, int count) {
        return ConvertUtil.toMap(this.streamOperations.range((Object)key, Range.of((Range.Bound)Range.Bound.inclusive((Comparable)((Object)minRecordId)), (Range.Bound)Range.Bound.inclusive((Comparable)((Object)maxRecordId))), RedisZSetCommands.Limit.limit().count(count)), StreamDataType.ALL);
    }

    public <T> Map<String, T> range(Class<T> resultType, String key, String minRecordId, String maxRecordId, int count) {
        return ConvertUtil.toMap(this.streamOperations.range(resultType, (Object)key, Range.of((Range.Bound)Range.Bound.inclusive((Comparable)((Object)minRecordId)), (Range.Bound)Range.Bound.inclusive((Comparable)((Object)maxRecordId))), RedisZSetCommands.Limit.limit().count(count)), StreamDataType.ALL);
    }

    public Map<String, Map<String, Object>> reverseRange(String key) {
        return this.reverseRange(key, "-", "+");
    }

    public <T> Map<String, T> reverseRange(Class<T> resultType, String key) {
        return this.reverseRange(resultType, key, "-", "+");
    }

    public Map<String, Map<String, Object>> reverseRange(String key, int count) {
        return this.reverseRange(key, "-", "+", count);
    }

    public <T> Map<String, T> reverseRange(Class<T> resultType, String key, int count) {
        return this.reverseRange(resultType, key, "-", "+", count);
    }

    public Map<String, Map<String, Object>> reverseRange(String key, String maxRecordId, String minRecordId) {
        return ConvertUtil.toMap(this.streamOperations.reverseRange((Object)key, Range.of((Range.Bound)Range.Bound.inclusive((Comparable)((Object)maxRecordId)), (Range.Bound)Range.Bound.inclusive((Comparable)((Object)minRecordId)))), StreamDataType.ALL);
    }

    public <T> Map<String, T> reverseRange(Class<T> resultType, String key, String maxRecordId, String minRecordId) {
        return ConvertUtil.toMap(this.streamOperations.reverseRange(resultType, (Object)key, Range.of((Range.Bound)Range.Bound.inclusive((Comparable)((Object)maxRecordId)), (Range.Bound)Range.Bound.inclusive((Comparable)((Object)minRecordId)))), StreamDataType.ALL);
    }

    public Map<String, Map<String, Object>> reverseRange(String key, String maxRecordId, String minRecordId, int count) {
        return ConvertUtil.toMap(this.streamOperations.reverseRange((Object)key, Range.of((Range.Bound)Range.Bound.inclusive((Comparable)((Object)maxRecordId)), (Range.Bound)Range.Bound.inclusive((Comparable)((Object)minRecordId))), RedisZSetCommands.Limit.limit().count(count)), StreamDataType.ALL);
    }

    public <T> Map<String, T> reverseRange(Class<T> resultType, String key, String maxRecordId, String minRecordId, int count) {
        return ConvertUtil.toMap(this.streamOperations.reverseRange(resultType, (Object)key, Range.of((Range.Bound)Range.Bound.inclusive((Comparable)((Object)maxRecordId)), (Range.Bound)Range.Bound.inclusive((Comparable)((Object)minRecordId))), RedisZSetCommands.Limit.limit().count(count)), StreamDataType.ALL);
    }

    private Object streamInfo(String key) {
        CustomCommandHandler customCommandHandler = RedisUtil.getCustomCommandHandler(this.dbIndex);
        return RedisUtil.getCustomCommandHandler(this.dbIndex).execute("XINFO", customCommandHandler.serialize("STREAM"), customCommandHandler.serialize(key));
    }

    private Object groupInfo(String key) {
        CustomCommandHandler customCommandHandler = RedisUtil.getCustomCommandHandler(this.dbIndex);
        return customCommandHandler.execute("XINFO", customCommandHandler.serialize("GROUPS"), customCommandHandler.serialize(key));
    }

    private Object consumerInfo(String key, String groupName) {
        CustomCommandHandler customCommandHandler = RedisUtil.getCustomCommandHandler(this.dbIndex);
        return customCommandHandler.execute("XINFO", customCommandHandler.serialize("CONSUMERS"), customCommandHandler.serialize(key), customCommandHandler.serialize(groupName));
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    private StreamOffset[] createStreamOffset(Map<String, String> keyRecordIdMap) {
        StreamOffset[] streamOffsets = new StreamOffset[keyRecordIdMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : keyRecordIdMap.entrySet()) {
            streamOffsets[i] = StreamOffset.create((Object)entry.getKey(), (ReadOffset)ReadOffset.from((String)entry.getValue()));
            ++i;
        }
        return streamOffsets;
    }

    private StreamOffset[] createStreamOffsetByRecordIds(String key, String ... recordIds) {
        int len = recordIds.length;
        StreamOffset[] streamOffsets = new StreamOffset[len];
        for (int i = 0; i < len; ++i) {
            streamOffsets[i] = StreamOffset.create((Object)key, (ReadOffset)ReadOffset.from((String)recordIds[i]));
        }
        return streamOffsets;
    }

    private StreamOffset[] createStreamOffsetByKeys(String ... keys) {
        int len = keys.length;
        StreamOffset[] streamOffsets = new StreamOffset[len];
        for (int i = 0; i < len; ++i) {
            streamOffsets[i] = StreamOffset.fromStart((Object)keys[i]);
        }
        return streamOffsets;
    }

    private List<Map<String, Object>> toPendingResult(List<Object> list) {
        ArrayList<Map<String, Object>> dataList;
        if (list == null) {
            dataList = new ArrayList<Map<String, Object>>(1);
            HashMap<String, Integer> data = new HashMap<String, Integer>(4);
            data.put("recordId", null);
            data.put("consumer", null);
            data.put("time", null);
            data.put("count", 0);
            dataList.add(data);
        } else {
            List oList = (List)list.get(0);
            dataList = new ArrayList(oList.size());
            for (Object o : oList) {
                List $dataList = (List)o;
                HashMap data = new HashMap(4);
                data.put("recordId", $dataList.get(0));
                data.put("consumer", $dataList.get(1));
                data.put("time", $dataList.get(2));
                data.put("count", $dataList.get(3));
                dataList.add(data);
            }
        }
        return dataList;
    }

    public static enum StreamDataType {
        ALL,
        LATEST,
        EARLIEST;

    }
}

