/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;
import wiki.xsx.core.util.ConvertUtil;

public final class ScriptHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private RedisScriptingCommands commands;
    private RedisScriptingCommands stringCommands;

    ScriptHandler(Integer dbIndex) {
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
        this.commands = this.redisTemplate.getRequiredConnectionFactory().getConnection().scriptingCommands();
        this.stringCommands = this.stringRedisTemplate.getRequiredConnectionFactory().getConnection().scriptingCommands();
    }

    ScriptHandler(TransactionHandler transactionHandler) {
        this.redisTemplate = transactionHandler.getRedisTemplate();
        this.stringRedisTemplate = transactionHandler.getStringRedisTemplate();
        this.commands = this.redisTemplate.getRequiredConnectionFactory().getConnection().scriptingCommands();
        this.stringCommands = this.stringRedisTemplate.getRequiredConnectionFactory().getConnection().scriptingCommands();
    }

    public <T> T excuteAsObj(String scriptText, Class<T> resultType, List<String> keys, Object ... args) {
        return (T)this.redisTemplate.execute(this.buildScriptWithText(scriptText, resultType), keys, args);
    }

    public <T> T excute(String scriptText, Class<T> resultType, List<String> keys, Object ... args) {
        return (T)this.stringRedisTemplate.execute(this.buildScriptWithText(scriptText, resultType), keys, args);
    }

    public <T> T excuteAsObj(String scriptLocation, Class<T> resultType, RedisSerializer<?> argsSerializer, RedisSerializer<T> resultSerializer, List<String> keys, Object ... args) {
        return (T)this.redisTemplate.execute(this.buildScriptWithLocation(scriptLocation, resultType), argsSerializer, resultSerializer, keys, args);
    }

    public <T> T excute(String scriptLocation, Class<T> resultType, RedisSerializer<?> argsSerializer, RedisSerializer<T> resultSerializer, List<String> keys, Object ... args) {
        return (T)this.stringRedisTemplate.execute(this.buildScriptWithLocation(scriptLocation, resultType), argsSerializer, resultSerializer, keys, args);
    }

    public <T> T excuteWithSHAAsObj(String scriptSHA, Class<T> resultType, List<String> keys, Object ... args) {
        return (T)this.commands.evalSha(scriptSHA, ReturnType.fromJavaType(resultType), keys.size(), ConvertUtil.toByteArray(this.redisTemplate.getKeySerializer(), this.redisTemplate.getValueSerializer(), keys, args));
    }

    public <T> T excuteWithSHA(String scriptSHA, Class<T> resultType, List<String> keys, Object ... args) {
        return (T)this.stringCommands.evalSha(scriptSHA, ReturnType.fromJavaType(resultType), keys.size(), ConvertUtil.toByteArray(this.stringRedisTemplate.getKeySerializer(), this.stringRedisTemplate.getValueSerializer(), keys, args));
    }

    public String loadAsObj(String scriptText) {
        return this.commands.scriptLoad(RedisSerializer.string().serialize((Object)scriptText));
    }

    public String load(String scriptText) {
        return this.stringCommands.scriptLoad(RedisSerializer.string().serialize((Object)scriptText));
    }

    public String loadByLocationAsObj(String scriptLocation) {
        return this.commands.scriptLoad(this.buildScriptWithLocation(scriptLocation, null).getScriptAsString().getBytes(StandardCharsets.UTF_8));
    }

    public String loadByLocation(String scriptLocation) {
        return this.stringCommands.scriptLoad(this.buildScriptWithLocation(scriptLocation, null).getScriptAsString().getBytes(StandardCharsets.UTF_8));
    }

    public List<Boolean> existsAsObj(String ... scriptSHAs) {
        return this.commands.scriptExists(scriptSHAs);
    }

    public List<Boolean> exists(String ... scriptSHAs) {
        return this.stringCommands.scriptExists(scriptSHAs);
    }

    public void clearAsObj() {
        this.commands.scriptFlush();
    }

    public void clear() {
        this.stringCommands.scriptFlush();
    }

    public void stopAsObj() {
        this.commands.scriptKill();
    }

    public void stop() {
        this.stringCommands.scriptKill();
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    private <T> RedisScript<T> buildScriptWithLocation(String scriptLocation, Class<T> resultType) {
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setLocation((Resource)new ClassPathResource(scriptLocation));
        redisScript.setResultType(resultType);
        return redisScript;
    }

    private <T> RedisScript<T> buildScriptWithText(String scriptText, Class<T> resultType) {
        return RedisScript.of((String)scriptText, resultType);
    }
}

