/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;
import wiki.xsx.core.util.ConvertUtil;

public final class ListHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private ListOperations<String, Object> listOperations;
    private ListOperations<String, String> stringListOperations;

    ListHandler(Integer dbIndex) {
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
        this.listOperations = this.redisTemplate.opsForList();
        this.stringListOperations = this.stringRedisTemplate.opsForList();
    }

    ListHandler(TransactionHandler transactionHandler) {
        this.redisTemplate = transactionHandler.getRedisTemplate();
        this.stringRedisTemplate = transactionHandler.getStringRedisTemplate();
        this.listOperations = this.redisTemplate.opsForList();
        this.stringListOperations = this.stringRedisTemplate.opsForList();
    }

    public Long sizeAsObj(String key) {
        return this.listOperations.size((Object)key);
    }

    public Long size(String key) {
        return this.stringListOperations.size((Object)key);
    }

    public List getAllAsObj(String key) {
        return this.lrangeAsObj(key, 0L, -1L);
    }

    public List<String> getAll(String key) {
        return this.lrange(key, 0L, -1L);
    }

    public List lrangeAsObj(String key, Long startIndex, Long endIndex) {
        return this.listOperations.range((Object)key, startIndex.longValue(), endIndex.longValue());
    }

    public List<String> lrange(String key, Long startIndex, Long endIndex) {
        return this.stringListOperations.range((Object)key, startIndex.longValue(), endIndex.longValue());
    }

    public List rrangeAsObj(String key, Long startIndex, Long endIndex) {
        List list = this.lrangeAsObj(key, -endIndex.longValue() - 1L, -startIndex.longValue() - 1L);
        Collections.reverse(list);
        return list;
    }

    public List<String> rrange(String key, Long startIndex, Long endIndex) {
        List<String> list = this.lrange(key, -endIndex.longValue() - 1L, -startIndex.longValue() - 1L);
        Collections.reverse(list);
        return list;
    }

    public Long lremoveAsObj(String key, Long count, Object value) {
        return this.listOperations.remove((Object)key, count.longValue(), value);
    }

    public Long lremove(String key, Long count, String value) {
        return this.stringListOperations.remove((Object)key, count.longValue(), (Object)value);
    }

    public Long rremoveAsObj(String key, Long count, Object value) {
        return this.lremoveAsObj(key, -count.longValue(), value);
    }

    public Long rremove(String key, Long count, String value) {
        return this.lremove(key, -count.longValue(), value);
    }

    public List lsubListAsObj(String key, Long startIndex, Long endIndex) {
        this.listOperations.trim((Object)key, startIndex.longValue(), endIndex.longValue());
        return this.lrangeAsObj(key, startIndex, this.sizeAsObj(key));
    }

    public List<String> lsubList(String key, Long startIndex, Long endIndex) {
        this.stringListOperations.trim((Object)key, startIndex.longValue(), endIndex.longValue());
        return this.lrange(key, startIndex, this.size(key));
    }

    public List rsubListAsObj(String key, Long startIndex, Long endIndex) {
        this.listOperations.trim((Object)key, -endIndex.longValue() - 1L, -startIndex.longValue() - 1L);
        int length = this.sizeAsObj(key).intValue();
        ArrayList list = new ArrayList(length);
        String temp = String.format("%s_temp", key);
        for (int i = 0; i < length; ++i) {
            list.add(this.rpopAndrpushAsObj(key, temp));
        }
        if (list.size() > 0) {
            this.redisTemplate.rename((Object)temp, (Object)key);
        }
        return list;
    }

    public List<String> rsubList(String key, Long startIndex, Long endIndex) {
        this.stringListOperations.trim((Object)key, -endIndex.longValue() - 1L, -startIndex.longValue() - 1L);
        int length = this.size(key).intValue();
        ArrayList<String> list = new ArrayList<String>(length);
        String temp = String.format("%s_temp", key);
        for (int i = 0; i < length; ++i) {
            list.add(this.rpopAndrpush(key, temp));
        }
        if (list.size() > 0) {
            this.stringRedisTemplate.rename((Object)temp, (Object)key);
        }
        return list;
    }

    public void lsetAsObj(String key, Long index, Object value) {
        this.listOperations.set((Object)key, index.longValue(), value);
    }

    public void lset(String key, Long index, String value) {
        this.stringListOperations.set((Object)key, index.longValue(), (Object)value);
    }

    public void rsetAsObj(String key, Long index, Object value) {
        this.listOperations.set((Object)key, -index.longValue() - 1L, value);
    }

    public void rset(String key, Long index, String value) {
        this.stringListOperations.set((Object)key, -index.longValue() - 1L, (Object)value);
    }

    public <T> T lgetAsObj(String key, Long index) {
        return (T)ConvertUtil.toJavaType(this.listOperations.index((Object)key, index.longValue()), Object.class);
    }

    public <T> T lgetAsObj(Class<T> type, String key, Long index) {
        return (T)ConvertUtil.toJavaType(this.listOperations.index((Object)key, index.longValue()), type);
    }

    public String lget(String key, Long index) {
        return (String)this.stringListOperations.index((Object)key, index.longValue());
    }

    public <T> T rgetAsObj(String key, Long index) {
        return (T)ConvertUtil.toJavaType(this.listOperations.index((Object)key, -index.longValue() - 1L), Object.class);
    }

    public <T> T rgetAsObj(Class<T> type, String key, Long index) {
        return (T)ConvertUtil.toJavaType(this.listOperations.index((Object)key, -index.longValue() - 1L), type);
    }

    public String rget(String key, Long index) {
        return (String)this.stringListOperations.index((Object)key, -index.longValue() - 1L);
    }

    public Long lpushAsObj(String key, Object value) {
        return this.listOperations.leftPush((Object)key, value);
    }

    public Long lpushAsObj(String key, Object pivot, Object value) {
        return this.listOperations.leftPush((Object)key, pivot, value);
    }

    public Long lpush(String key, String value) {
        return this.stringListOperations.leftPush((Object)key, (Object)value);
    }

    public Long lpush(String key, String pivot, String value) {
        return this.stringListOperations.leftPush((Object)key, (Object)pivot, (Object)value);
    }

    public Long lpushAllAsObj(String key, Object ... values) {
        return this.listOperations.leftPushAll((Object)key, values);
    }

    public Long lpushAll(String key, String ... values) {
        return this.stringListOperations.leftPushAll((Object)key, (Object[])values);
    }

    public Long lpushIfPresentAsObj(String key, Object value) {
        return this.listOperations.leftPushIfPresent((Object)key, value);
    }

    public Long lpushIfPresent(String key, String value) {
        return this.stringListOperations.leftPushIfPresent((Object)key, (Object)value);
    }

    public <T> T lpopAsObj(String key) {
        return (T)ConvertUtil.toJavaType(this.listOperations.leftPop((Object)key), Object.class);
    }

    public <T> T lpopAsObj(Class<T> type, String key) {
        return (T)ConvertUtil.toJavaType(this.listOperations.leftPop((Object)key), type);
    }

    public String lpop(String key) {
        return (String)this.stringListOperations.leftPop((Object)key);
    }

    public <T> T blpopAsObj(String key, Long timeout, TimeUnit unit) {
        return (T)this.listOperations.leftPop((Object)key, timeout.longValue(), unit);
    }

    public <T> T blpopAsObj(Class<T> type, String key, Long timeout, TimeUnit unit) {
        return (T)ConvertUtil.toJavaType(this.listOperations.leftPop((Object)key, timeout.longValue(), unit), type);
    }

    public String blpop(String key, Long timeout, TimeUnit unit) {
        return (String)this.stringListOperations.leftPop((Object)key, timeout.longValue(), unit);
    }

    public Long rpushAsObj(String key, Object value) {
        return this.listOperations.rightPush((Object)key, value);
    }

    public Long rpush(String key, String value) {
        return this.stringListOperations.rightPush((Object)key, (Object)value);
    }

    public Long rpushAsObj(String key, Object pivot, Object value) {
        return this.listOperations.rightPush((Object)key, pivot, value);
    }

    public Long rpush(String key, String pivot, String value) {
        return this.stringListOperations.rightPush((Object)key, (Object)pivot, (Object)value);
    }

    public Long rpushIfPresentAsObj(String key, Object value) {
        return this.listOperations.rightPushIfPresent((Object)key, value);
    }

    public Long rpushIfPresent(String key, String value) {
        return this.stringListOperations.rightPushIfPresent((Object)key, (Object)value);
    }

    public Long rpushAllAsObj(String key, Object ... value) {
        return this.listOperations.rightPushAll((Object)key, value);
    }

    public Long rpushAll(String key, String ... value) {
        return this.stringListOperations.rightPushAll((Object)key, (Object[])value);
    }

    public <T> T rpopAsObj(String key) {
        return (T)this.listOperations.rightPop((Object)key);
    }

    public <T> T rpopAsObj(Class<T> type, String key) {
        return (T)ConvertUtil.toJavaType(this.listOperations.rightPop((Object)key), type);
    }

    public String rpop(String key) {
        return (String)this.stringListOperations.rightPop((Object)key);
    }

    public <T> T brpopAsObj(String key, Long timeout, TimeUnit unit) {
        return (T)this.listOperations.rightPop((Object)key, timeout.longValue(), unit);
    }

    public <T> T brpopAsObj(Class<T> type, String key, Long timeout, TimeUnit unit) {
        return (T)ConvertUtil.toJavaType(this.listOperations.rightPop((Object)key, timeout.longValue(), unit), type);
    }

    public String brpop(String key, Long timeout, TimeUnit unit) {
        return (String)this.stringListOperations.rightPop((Object)key, timeout.longValue(), unit);
    }

    public <T> T lpopAndlpushAsObj(String key, String otherKey) {
        T t = this.lpopAsObj(key);
        this.lpushAsObj(otherKey, t);
        return t;
    }

    public String lpopAndlpush(String key, String otherKey) {
        String v = this.lpop(key);
        this.lpush(otherKey, v);
        return v;
    }

    public <T> T rpopAndlpushAsObj(String key, String otherKey) {
        return (T)this.listOperations.rightPopAndLeftPush((Object)key, (Object)otherKey);
    }

    public <T> T rpopAndlpushAsObj(Class<T> type, String key, String otherKey) {
        return (T)ConvertUtil.toJavaType(this.listOperations.rightPopAndLeftPush((Object)key, (Object)otherKey), type);
    }

    public String rpopAndlpush(String key, String otherKey) {
        return (String)this.stringListOperations.rightPopAndLeftPush((Object)key, (Object)otherKey);
    }

    public <T> T rpopAndrpushAsObj(String key, String otherKey) {
        T t = this.rpopAsObj(key);
        this.rpushAsObj(otherKey, t);
        return t;
    }

    public String rpopAndrpush(String key, String otherKey) {
        String v = this.rpop(key);
        this.rpush(otherKey, v);
        return v;
    }

    public <T> T lpopAndrpushAsObj(String key, String otherKey) {
        T t = this.lpopAsObj(key);
        this.rpushAsObj(otherKey, t);
        return t;
    }

    public String lpopAndrpush(String key, String otherKey) {
        String v = this.lpop(key);
        this.rpush(otherKey, v);
        return v;
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }
}

