/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.query.SortQueryBuilder;
import org.springframework.data.redis.serializer.SerializationException;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;
import wiki.xsx.core.util.ConvertUtil;

public final class KeyHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;

    KeyHandler(Integer dbIndex) {
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
    }

    KeyHandler(TransactionHandler transactionHandler) {
        this.redisTemplate = transactionHandler.getRedisTemplate();
        this.stringRedisTemplate = transactionHandler.getStringRedisTemplate();
    }

    public Boolean hasKeyAsObj(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean hasKey(String key) {
        return this.stringRedisTemplate.hasKey((Object)key);
    }

    public Long removeAsObj(String ... keys) {
        return this.redisTemplate.delete(Arrays.asList(keys));
    }

    public Long remove(String ... keys) {
        return this.stringRedisTemplate.delete(Arrays.asList(keys));
    }

    public Long unlinkAsObj(String ... keys) {
        return this.redisTemplate.unlink(Arrays.asList(keys));
    }

    public Long unlink(String ... keys) {
        return this.stringRedisTemplate.unlink(Arrays.asList(keys));
    }

    public Boolean expireAsObj(String key, long timeout, TimeUnit timeUnit) {
        return this.redisTemplate.expire((Object)key, timeout, timeUnit);
    }

    public Boolean expire(String key, long timeout, TimeUnit timeUnit) {
        return this.stringRedisTemplate.expire((Object)key, timeout, timeUnit);
    }

    public Boolean expireAtAsObj(String key, Date date) {
        return this.redisTemplate.expireAt((Object)key, date);
    }

    public Boolean expireAt(String key, Date date) {
        return this.stringRedisTemplate.expireAt((Object)key, date);
    }

    public Long getExpireAsObj(String key, TimeUnit timeUnit) {
        return this.redisTemplate.getExpire((Object)key, timeUnit);
    }

    public Long getExpire(String key, TimeUnit timeUnit) {
        return this.stringRedisTemplate.getExpire((Object)key, timeUnit);
    }

    public DataType getTypeAsObj(String key) {
        return this.redisTemplate.type((Object)key);
    }

    public DataType getType(String key) {
        return this.stringRedisTemplate.type((Object)key);
    }

    public Set<String> keysAsObj(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public Set<String> keys(String pattern) {
        return this.stringRedisTemplate.keys((Object)pattern);
    }

    public Long keysCountAsObj(String ... keys) {
        return this.redisTemplate.countExistingKeys(Arrays.asList(keys));
    }

    public Long keysCount(String ... keys) {
        return this.stringRedisTemplate.countExistingKeys(Arrays.asList(keys));
    }

    public String randomKeyAsObj() {
        String o;
        try {
            o = (String)this.redisTemplate.randomKey();
        }
        catch (SerializationException e) {
            o = null;
        }
        return o;
    }

    public String randomKey() {
        return (String)this.stringRedisTemplate.randomKey();
    }

    public void renameAsObj(String oldKey, String newKey) {
        this.redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public void rename(String oldKey, String newKey) {
        this.stringRedisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public Boolean renameAsObjIfAbsent(String oldKey, String newKey) {
        return this.redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    public Boolean renameIfAbsent(String oldKey, String newKey) {
        return this.stringRedisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    public Boolean persistAsObj(String key) {
        return this.redisTemplate.persist((Object)key);
    }

    public Boolean persist(String key) {
        return this.stringRedisTemplate.persist((Object)key);
    }

    public Boolean moveAsObj(int dbIndex, String key) {
        return this.redisTemplate.move((Object)key, dbIndex);
    }

    public Boolean move(int dbIndex, String key) {
        return this.stringRedisTemplate.move((Object)key, dbIndex);
    }

    public Long count() {
        Long count;
        try {
            count = this.redisTemplate.getRequiredConnectionFactory().getConnection().dbSize();
        }
        catch (IllegalStateException ex) {
            count = this.stringRedisTemplate.getRequiredConnectionFactory().getConnection().dbSize();
        }
        return count;
    }

    public byte[] dumpAsObj(String key) {
        return this.redisTemplate.dump((Object)key);
    }

    public byte[] dump(String key) {
        return this.stringRedisTemplate.dump((Object)key);
    }

    public void restoreAsObj(String key, byte[] value, Long timeout, TimeUnit unit, boolean replace) {
        this.redisTemplate.restore((Object)key, value, timeout.longValue(), unit, replace);
    }

    public void restore(String key, byte[] value, Long timeout, TimeUnit unit, boolean replace) {
        this.stringRedisTemplate.restore((Object)key, value, timeout.longValue(), unit, replace);
    }

    public Long touchAsObj(String ... keys) {
        return this.redisTemplate.getRequiredConnectionFactory().getConnection().keyCommands().touch(ConvertUtil.toByteArray(this.redisTemplate.getKeySerializer(), keys));
    }

    public Long touch(String ... keys) {
        return this.stringRedisTemplate.getRequiredConnectionFactory().getConnection().keyCommands().touch(ConvertUtil.toByteArray(this.stringRedisTemplate.getKeySerializer(), keys));
    }

    public List sortAsObj(String key) {
        return this.redisTemplate.sort(SortQueryBuilder.sort((Object)key).by("").order(SortParameters.Order.ASC).alphabetical(true).limit(0L, Long.MAX_VALUE).build());
    }

    public List<String> sort(String key) {
        return this.stringRedisTemplate.sort(SortQueryBuilder.sort((Object)key).by("").order(SortParameters.Order.ASC).alphabetical(true).limit(0L, Long.MAX_VALUE).build());
    }

    public Long sortAndCoverAsObj(String key) {
        return this.sortAndStoreAsObj(key, key);
    }

    public Long sortAndCover(String key) {
        return this.sortAndStore(key, key);
    }

    public Long sortAndStoreAsObj(String key, String storeKey) {
        return this.redisTemplate.sort(SortQueryBuilder.sort((Object)key).by("").order(SortParameters.Order.ASC).alphabetical(true).limit(0L, Long.MAX_VALUE).build(), (Object)storeKey);
    }

    public Long sortAndStore(String key, String storeKey) {
        return this.stringRedisTemplate.sort(SortQueryBuilder.sort((Object)key).by("").order(SortParameters.Order.ASC).alphabetical(true).limit(0L, Long.MAX_VALUE).build(), (Object)storeKey);
    }

    public List sortAsObj(SortQuery<String> query) {
        return this.redisTemplate.sort(query);
    }

    public List<String> sort(SortQuery<String> query) {
        return this.stringRedisTemplate.sort(query);
    }

    public Long sortAndCoverAsObj(SortQuery<String> query) {
        return this.sortAndStoreAsObj(query, (String)query.getKey());
    }

    public Long sortAndCover(SortQuery<String> query) {
        return this.sortAndStore(query, (String)query.getKey());
    }

    public Long sortAndStoreAsObj(SortQuery<String> query, String storeKey) {
        return this.redisTemplate.sort(query, (Object)storeKey);
    }

    public Long sortAndStore(SortQuery<String> query, String storeKey) {
        return this.stringRedisTemplate.sort(query, (Object)storeKey);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }
}

