/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.util.Arrays;
import java.util.List;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;
import wiki.xsx.core.util.ConvertUtil;

public final class BitmapHandler
implements RedisHandler {
    private StringRedisTemplate stringRedisTemplate;
    private RedisStringCommands commands;

    BitmapHandler(Integer dbIndex) {
        this.stringRedisTemplate = HandlerManager.createStringRedisTemplate(dbIndex);
        this.commands = this.stringRedisTemplate.getRequiredConnectionFactory().getConnection().stringCommands();
    }

    BitmapHandler(TransactionHandler transactionHandler) {
        this.stringRedisTemplate = transactionHandler.getStringRedisTemplate();
        this.commands = this.stringRedisTemplate.getRequiredConnectionFactory().getConnection().stringCommands();
    }

    public Boolean set(String key, Long offset, boolean bit) {
        return this.stringRedisTemplate.opsForValue().setBit((Object)key, offset.longValue(), bit);
    }

    public Boolean get(String key, Long offset) {
        return this.stringRedisTemplate.opsForValue().getBit((Object)key, offset.longValue());
    }

    public Long bitLength(String key) {
        String s = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (s == null) {
            return 0L;
        }
        return s.length() << 3;
    }

    public String binary(String key) {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (value == null) {
            return null;
        }
        char[] chars = value.toCharArray();
        int count = chars.length;
        int length = count << 3;
        int bit = 8;
        StringBuilder builder = new StringBuilder(length);
        for (char aChar : chars) {
            for (int j = bit - 1; j >= 0; --j) {
                builder.append(aChar >>> j & 1);
            }
            builder.append(' ');
        }
        return builder.substring(0, length + count - 1);
    }

    public Long count(String key) {
        return this.commands.bitCount(ConvertUtil.toBytes(this.stringRedisTemplate.getKeySerializer(), key));
    }

    public Long count(String key, Long startIndex, Long endIndex) {
        long startByteIndex = startIndex << 3;
        long endByteIndex = endIndex << 3;
        return this.commands.bitCount(ConvertUtil.toBytes(this.stringRedisTemplate.getKeySerializer(), key), startByteIndex, endByteIndex);
    }

    public Long position(String key, boolean bit) {
        return this.commands.bitPos(ConvertUtil.toBytes(this.stringRedisTemplate.getKeySerializer(), key), bit);
    }

    public Long position(String key, boolean bit, Long startIndex, Long endIndex) {
        Range range = Range.of((Range.Bound)Range.Bound.inclusive((Comparable)startIndex), (Range.Bound)Range.Bound.inclusive((Comparable)endIndex));
        return this.commands.bitPos(ConvertUtil.toBytes(this.stringRedisTemplate.getKeySerializer(), key), bit, range);
    }

    public Long bitOpWithAnd(String storeKey, String ... keys) {
        byte[][] keyBytes = ConvertUtil.toByteArray(RedisSerializer.string(), keys);
        return this.commands.bitOp(RedisStringCommands.BitOperation.AND, ConvertUtil.toBytes(this.stringRedisTemplate.getKeySerializer(), storeKey), keyBytes);
    }

    public Long bitOpWithOr(String storeKey, String ... keys) {
        byte[][] keyBytes = ConvertUtil.toByteArray(RedisSerializer.string(), keys);
        return this.commands.bitOp(RedisStringCommands.BitOperation.OR, ConvertUtil.toBytes(this.stringRedisTemplate.getKeySerializer(), storeKey), keyBytes);
    }

    public Long bitOpWithXor(String storeKey, String ... keys) {
        byte[][] keyBytes = ConvertUtil.toByteArray(RedisSerializer.string(), keys);
        return this.commands.bitOp(RedisStringCommands.BitOperation.XOR, ConvertUtil.toBytes(this.stringRedisTemplate.getKeySerializer(), storeKey), keyBytes);
    }

    public Long bitOpWithNot(String storeKey, String key) {
        byte[] keyBytes = ConvertUtil.toBytes(RedisSerializer.string(), key);
        return this.commands.bitOp(RedisStringCommands.BitOperation.NOT, ConvertUtil.toBytes(this.stringRedisTemplate.getKeySerializer(), storeKey), (byte[][])new byte[][]{keyBytes});
    }

    public List<Long> bitField(String key, BitFieldSubCommands commands) {
        return this.stringRedisTemplate.opsForValue().bitField((Object)key, commands);
    }

    public Long remove(String ... keys) {
        return this.stringRedisTemplate.opsForValue().getOperations().delete(Arrays.asList(keys));
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }
}

