/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.config.redisson;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.redisson.cluster.ClusterConnectionManager;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.ReplicatedConnectionManager;
import org.redisson.connection.SentinelConnectionManager;
import org.redisson.connection.SingleConnectionManager;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.util.Assert;

public class RedissonConnectionConfiguration
extends Config
implements RedisConfiguration {
    private static final Log log = LogFactory.getLog(RedissonConnectionConfiguration.class);
    private SentinelServersConfig sentinelServersConfig;
    private MasterSlaveServersConfig masterSlaveServersConfig;
    private SingleServerConfig singleServerConfig;
    private ClusterServersConfig clusterServersConfig;
    private ReplicatedServersConfig replicatedServersConfig;
    private ConnectionManager connectionManager;
    private int database = 0;

    public RedissonConnectionConfiguration() {
    }

    public RedissonConnectionConfiguration(RedissonConnectionConfiguration configuration) {
        this.sentinelServersConfig = configuration.getSentinelServersConfig();
        this.masterSlaveServersConfig = configuration.getMasterSlaveServersConfig();
        this.singleServerConfig = configuration.getSingleServerConfig();
        this.clusterServersConfig = configuration.getClusterServersConfig();
        this.replicatedServersConfig = configuration.getReplicatedServersConfig();
        this.connectionManager = configuration.getConnectionManager();
        this.initParent();
    }

    private void initParent() {
        Class<?> currentClass = ((Object)((Object)this)).getClass();
        Class<?> configClass = currentClass.getSuperclass();
        try {
            Field[] fields;
            for (Field field : fields = currentClass.getDeclaredFields()) {
                try {
                    Field configField = configClass.getDeclaredField(field.getName());
                    if (Modifier.isFinal(configField.getModifiers())) continue;
                    configField.setAccessible(true);
                    configField.set((Object)this, field.get((Object)this));
                }
                catch (NoSuchFieldException ex) {
                    log.debug((Object)("ignore the field: " + field.getName()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"init config fail", (Throwable)e);
        }
    }

    public SentinelServersConfig getSentinelServersConfig() {
        return this.sentinelServersConfig;
    }

    public void setSentinelServersConfig(SentinelServersConfig sentinelServersConfig) {
        this.sentinelServersConfig = sentinelServersConfig;
    }

    public MasterSlaveServersConfig getMasterSlaveServersConfig() {
        return this.masterSlaveServersConfig;
    }

    public void setMasterSlaveServersConfig(MasterSlaveServersConfig masterSlaveServersConfig) {
        this.masterSlaveServersConfig = masterSlaveServersConfig;
    }

    public SingleServerConfig getSingleServerConfig() {
        return this.singleServerConfig;
    }

    public void setSingleServerConfig(SingleServerConfig singleServerConfig) {
        this.singleServerConfig = singleServerConfig;
    }

    public ClusterServersConfig getClusterServersConfig() {
        return this.clusterServersConfig;
    }

    public void setClusterServersConfig(ClusterServersConfig clusterServersConfig) {
        this.clusterServersConfig = clusterServersConfig;
    }

    public ReplicatedServersConfig getReplicatedServersConfig() {
        return this.replicatedServersConfig;
    }

    public void setReplicatedServersConfig(ReplicatedServersConfig replicatedServersConfig) {
        this.replicatedServersConfig = replicatedServersConfig;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void useCustomServers(ConnectionManager connectionManager) {
        super.useCustomServers(connectionManager);
        this.connectionManager = connectionManager;
        this.initDatabase();
    }

    public static RedissonConnectionConfiguration fromJSON(String content) throws IOException {
        return new RedissonConnectionConfiguration((RedissonConnectionConfiguration)((Object)new ConfigSupport().fromJSON(content, RedissonConnectionConfiguration.class)));
    }

    public static RedissonConnectionConfiguration fromJSON(InputStream inputStream) throws IOException {
        RedissonConnectionConfiguration configuration = new RedissonConnectionConfiguration((RedissonConnectionConfiguration)((Object)new ConfigSupport().fromJSON(inputStream, RedissonConnectionConfiguration.class)));
        configuration.useCustomServers(RedissonConnectionConfiguration.createConnectionManager(configuration));
        return configuration;
    }

    public static RedissonConnectionConfiguration fromJSON(File file, ClassLoader classLoader) throws IOException {
        RedissonConnectionConfiguration configuration = new RedissonConnectionConfiguration((RedissonConnectionConfiguration)((Object)new ConfigSupport().fromJSON(file, RedissonConnectionConfiguration.class, classLoader)));
        configuration.useCustomServers(RedissonConnectionConfiguration.createConnectionManager(configuration));
        return configuration;
    }

    public static RedissonConnectionConfiguration fromJSON(File file) throws IOException {
        return RedissonConnectionConfiguration.fromJSON(file, null);
    }

    public static RedissonConnectionConfiguration fromJSON(URL url) throws IOException {
        RedissonConnectionConfiguration configuration = new RedissonConnectionConfiguration((RedissonConnectionConfiguration)((Object)new ConfigSupport().fromJSON(url, RedissonConnectionConfiguration.class)));
        configuration.useCustomServers(RedissonConnectionConfiguration.createConnectionManager(configuration));
        return configuration;
    }

    public static RedissonConnectionConfiguration fromJSON(Reader reader) throws IOException {
        RedissonConnectionConfiguration configuration = new RedissonConnectionConfiguration((RedissonConnectionConfiguration)((Object)new ConfigSupport().fromJSON(reader, RedissonConnectionConfiguration.class)));
        configuration.useCustomServers(RedissonConnectionConfiguration.createConnectionManager(configuration));
        return configuration;
    }

    public String toJSON() throws IOException {
        return new ConfigSupport().toJSON((Config)this);
    }

    public static RedissonConnectionConfiguration fromYAML(String content) throws IOException {
        RedissonConnectionConfiguration configuration = new RedissonConnectionConfiguration((RedissonConnectionConfiguration)((Object)new ConfigSupport().fromYAML(content, RedissonConnectionConfiguration.class)));
        configuration.useCustomServers(RedissonConnectionConfiguration.createConnectionManager(configuration));
        return configuration;
    }

    public static RedissonConnectionConfiguration fromYAML(InputStream inputStream) throws IOException {
        RedissonConnectionConfiguration configuration = new RedissonConnectionConfiguration((RedissonConnectionConfiguration)((Object)new ConfigSupport().fromYAML(inputStream, RedissonConnectionConfiguration.class)));
        configuration.useCustomServers(RedissonConnectionConfiguration.createConnectionManager(configuration));
        return configuration;
    }

    public static RedissonConnectionConfiguration fromYAML(File file) throws IOException {
        return RedissonConnectionConfiguration.fromYAML(file, null);
    }

    public static RedissonConnectionConfiguration fromYAML(File file, ClassLoader classLoader) throws IOException {
        RedissonConnectionConfiguration configuration = new RedissonConnectionConfiguration((RedissonConnectionConfiguration)((Object)new ConfigSupport().fromYAML(file, RedissonConnectionConfiguration.class, classLoader)));
        configuration.useCustomServers(RedissonConnectionConfiguration.createConnectionManager(configuration));
        return configuration;
    }

    public static RedissonConnectionConfiguration fromYAML(URL url) throws IOException {
        RedissonConnectionConfiguration configuration = new RedissonConnectionConfiguration((RedissonConnectionConfiguration)((Object)new ConfigSupport().fromYAML(url, RedissonConnectionConfiguration.class)));
        configuration.useCustomServers(RedissonConnectionConfiguration.createConnectionManager(configuration));
        return configuration;
    }

    public static RedissonConnectionConfiguration fromYAML(Reader reader) throws IOException {
        RedissonConnectionConfiguration configuration = new RedissonConnectionConfiguration((RedissonConnectionConfiguration)((Object)new ConfigSupport().fromYAML(reader, RedissonConnectionConfiguration.class)));
        configuration.useCustomServers(RedissonConnectionConfiguration.createConnectionManager(configuration));
        return configuration;
    }

    public String toYAML() throws IOException {
        return new ConfigSupport().toYAML((Config)this);
    }

    public static ConnectionManager createConnectionManager(RedissonConnectionConfiguration configCopy) {
        UUID id = UUID.randomUUID();
        if (configCopy.getMasterSlaveServersConfig() != null) {
            RedissonConnectionConfiguration.validate(configCopy.getMasterSlaveServersConfig());
            return new MasterSlaveConnectionManager(configCopy.getMasterSlaveServersConfig(), (Config)configCopy, id);
        }
        if (configCopy.getSingleServerConfig() != null) {
            RedissonConnectionConfiguration.validate(configCopy.getSingleServerConfig());
            return new SingleConnectionManager(configCopy.getSingleServerConfig(), (Config)configCopy, id);
        }
        if (configCopy.getSentinelServersConfig() != null) {
            RedissonConnectionConfiguration.validate(configCopy.getSentinelServersConfig());
            return new SentinelConnectionManager(configCopy.getSentinelServersConfig(), (Config)configCopy, id);
        }
        if (configCopy.getClusterServersConfig() != null) {
            RedissonConnectionConfiguration.validate(configCopy.getClusterServersConfig());
            return new ClusterConnectionManager(configCopy.getClusterServersConfig(), (Config)configCopy, id);
        }
        if (configCopy.getReplicatedServersConfig() != null) {
            RedissonConnectionConfiguration.validate(configCopy.getReplicatedServersConfig());
            return new ReplicatedConnectionManager(configCopy.getReplicatedServersConfig(), (Config)configCopy, id);
        }
        if (configCopy.getConnectionManager() != null) {
            return configCopy.getConnectionManager();
        }
        throw new IllegalArgumentException("server(s) address(es) not defined!");
    }

    private static void validate(SingleServerConfig config) {
        if (config.getConnectionPoolSize() < config.getConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("connectionPoolSize can't be lower than connectionMinimumIdleSize");
        }
    }

    private static void validate(BaseMasterSlaveServersConfig<?> config) {
        if (config.getSlaveConnectionPoolSize() < config.getSlaveConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("slaveConnectionPoolSize can't be lower than slaveConnectionMinimumIdleSize");
        }
        if (config.getMasterConnectionPoolSize() < config.getMasterConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("masterConnectionPoolSize can't be lower than masterConnectionMinimumIdleSize");
        }
        if (config.getSubscriptionConnectionPoolSize() < config.getSubscriptionConnectionMinimumIdleSize()) {
            throw new IllegalArgumentException("slaveSubscriptionConnectionMinimumIdleSize can't be lower than slaveSubscriptionConnectionPoolSize");
        }
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.database = index;
        if (this.isSentinelConfig()) {
            this.getSentinelServersConfig().setDatabase(this.database);
        } else if (this.isClusterConfig()) {
            this.database = 0;
        } else if (this.getReplicatedServersConfig() != null) {
            this.getReplicatedServersConfig().setDatabase(this.database);
        } else if (this.getMasterSlaveServersConfig() != null) {
            this.getMasterSlaveServersConfig().setDatabase(this.database);
        } else {
            this.getSingleServerConfig().setDatabase(this.database);
        }
    }

    public int getDatabase() {
        this.database = this.isSentinelConfig() ? this.getSentinelServersConfig().getDatabase() : (this.isClusterConfig() ? 0 : (this.getReplicatedServersConfig() != null ? this.getReplicatedServersConfig().getDatabase() : (this.getMasterSlaveServersConfig() != null ? this.getMasterSlaveServersConfig().getDatabase() : this.getSingleServerConfig().getDatabase())));
        return this.database;
    }

    private void initDatabase() {
        this.getDatabase();
    }
}

