/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.config.redisson;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.ReflectionUtils;
import wiki.xsx.core.config.redisson.RedissonConnectionConfiguration;
import wiki.xsx.core.config.redisson.RedissonConnectionFactory;
import wiki.xsx.core.config.redisson.RedissonProperties;

@Configuration
@ConditionalOnClass(value={Redisson.class, RedisOperations.class})
@EnableConfigurationProperties(value={RedissonProperties.class, RedisProperties.class})
public class RedissonAutoConfiguration {
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private RedisProperties redisProperties;
    @Autowired
    private ApplicationContext ctx;

    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public RedisConnectionFactory redisConnectionFactory(RedissonClient redisson) {
        return new RedissonConnectionFactory(redisson);
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redisson() {
        return Redisson.create((Config)this.createConfig(null));
    }

    public RedissonConnectionConfiguration createConfig(Integer dbIndex) {
        RedissonConnectionConfiguration redissonConnectionConfiguration;
        Method nodesMethod;
        int timeout;
        if (dbIndex == null) {
            dbIndex = this.redisProperties.getDatabase();
        }
        Method clusterMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getCluster");
        Method timeoutMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getTimeout");
        Object timeoutValue = ReflectionUtils.invokeMethod((Method)timeoutMethod, (Object)this.redisProperties);
        if (null == timeoutValue) {
            timeout = 0;
        } else if (!(timeoutValue instanceof Integer)) {
            nodesMethod = ReflectionUtils.findMethod(timeoutValue.getClass(), (String)"toMillis");
            timeout = ((Long)ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)timeoutValue)).intValue();
        } else {
            timeout = (Integer)timeoutValue;
        }
        if (this.redissonProperties.getFile() != null) {
            try {
                InputStream is = this.getConfigStream();
                redissonConnectionConfiguration = RedissonConnectionConfiguration.fromJSON(is);
            }
            catch (IOException e) {
                try {
                    InputStream is = this.getConfigStream();
                    redissonConnectionConfiguration = RedissonConnectionConfiguration.fromYAML(is);
                }
                catch (IOException e1) {
                    throw new IllegalArgumentException("Can't parse redissonConnectionConfiguration", e1);
                }
            }
        } else {
            if (this.redissonProperties.getConfig() != null) {
                try {
                    redissonConnectionConfiguration = RedissonConnectionConfiguration.fromJSON(this.redissonProperties.getConfig());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Can't parse redissonConnectionConfiguration", e);
                }
            } else {
                redissonConnectionConfiguration = new RedissonConnectionConfiguration();
            }
            if (this.redisProperties.getSentinel() != null) {
                nodesMethod = ReflectionUtils.findMethod(RedisProperties.Sentinel.class, (String)"getNodes");
                Object nodesValue = ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)this.redisProperties.getSentinel());
                String[] nodes = nodesValue instanceof String ? this.convert(Arrays.asList(((String)nodesValue).split(","))) : this.convert((List)nodesValue);
                SentinelServersConfig sentinelServersConfig = (SentinelServersConfig)((SentinelServersConfig)redissonConnectionConfiguration.useSentinelServers().setMasterName(this.redisProperties.getSentinel().getMaster()).addSentinelAddress(nodes).setDatabase(dbIndex.intValue()).setConnectTimeout(timeout)).setPassword(this.redisProperties.getPassword());
                redissonConnectionConfiguration.setSentinelServersConfig(sentinelServersConfig);
            } else if (clusterMethod != null && ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties) != null) {
                Object clusterObject = ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties);
                Method method = ReflectionUtils.findMethod(clusterObject.getClass(), (String)"getNodes");
                List nodesObject = (List)ReflectionUtils.invokeMethod((Method)method, (Object)clusterObject);
                String[] nodes = this.convert(nodesObject);
                ClusterServersConfig clusterServersConfig = (ClusterServersConfig)((ClusterServersConfig)redissonConnectionConfiguration.useClusterServers().addNodeAddress(nodes).setConnectTimeout(timeout)).setPassword(this.redisProperties.getPassword());
                redissonConnectionConfiguration.setClusterServersConfig(clusterServersConfig);
            } else {
                String prefix = "redis://";
                Method method = ReflectionUtils.findMethod(RedisProperties.class, (String)"isSsl");
                if (method != null && ((Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)this.redisProperties)).booleanValue()) {
                    prefix = "rediss://";
                }
                SingleServerConfig singleServerConfig = (SingleServerConfig)((SingleServerConfig)redissonConnectionConfiguration.useSingleServer().setAddress(prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setConnectTimeout(timeout)).setDatabase(dbIndex.intValue()).setPassword(this.redisProperties.getPassword());
                redissonConnectionConfiguration.setSingleServerConfig(singleServerConfig);
            }
        }
        return redissonConnectionConfiguration;
    }

    private String[] convert(List<String> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith("redis://") && !node.startsWith("rediss://")) {
                nodes.add("redis://" + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[0]);
    }

    private InputStream getConfigStream() throws IOException {
        return this.ctx.getResource(this.redissonProperties.getConfig()).getInputStream();
    }
}

