/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.config;

import cn.hutool.json.JSONUtil;
import java.nio.charset.StandardCharsets;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class JsonRedisSerializer
implements RedisSerializer<Object> {
    public byte[] serialize(Object t) throws SerializationException {
        byte[] bytes;
        if (t == null) {
            return new byte[0];
        }
        if (this.isSimpleType(t)) {
            bytes = t.toString().getBytes(StandardCharsets.UTF_8);
        } else {
            try {
                bytes = JSONUtil.toJsonStr((Object)t).getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                throw new SerializationException("Could not serialize: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return bytes;
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        return this.tryDeserialize(bytes);
    }

    private Object tryDeserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        String str = new String(bytes, StandardCharsets.UTF_8);
        if (JSONUtil.isJsonArray((String)str)) {
            return JSONUtil.parseArray((String)str);
        }
        if (JSONUtil.isJsonObj((String)str)) {
            return JSONUtil.parseObj((String)str);
        }
        return str;
    }

    private boolean isSimpleType(Object t) {
        if (t instanceof CharSequence) {
            return true;
        }
        if (t instanceof Number) {
            return true;
        }
        return t.getClass().isPrimitive();
    }
}

