/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class ImportSupport {
    protected ServletContext application;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected boolean isAbsoluteUrl;
    protected static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";
    protected static final String DEFAULT_ENCODING = "ISO-8859-1";

    protected String acquireString(String string) throws IOException, Exception {
        String string2;
        this.isAbsoluteUrl = ImportSupport.isAbsoluteUrl(string);
        if (this.isAbsoluteUrl) {
            int n;
            BufferedReader bufferedReader = new BufferedReader(this.acquireReader(string));
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = bufferedReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            bufferedReader.close();
            return stringBuffer.toString();
        }
        if (!(this.request instanceof HttpServletRequest) || !(this.response instanceof HttpServletResponse)) {
            throw new Exception("Relative import from non-HTTP request not allowed");
        }
        if (!string.startsWith("/")) {
            string2 = this.request.getServletPath();
            string = string2.substring(0, string2.lastIndexOf(47)) + '/' + string;
        }
        if ((string2 = this.application.getRequestDispatcher(string = ImportSupport.stripSession(string))) == null) {
            throw new Exception("Couldn't get a RequestDispatcher for \"" + string + "\"");
        }
        ImportResponseWrapper importResponseWrapper = new ImportResponseWrapper(this.response);
        try {
            string2.include((ServletRequest)this.request, (ServletResponse)importResponseWrapper);
        }
        catch (IOException iOException) {
            throw new Exception("Problem importing the relative URL \"" + string + "\". " + iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new Exception("Problem importing the relative URL \"" + string + "\". " + runtimeException);
        }
        if (importResponseWrapper.getStatus() < 200 || importResponseWrapper.getStatus() > 299) {
            throw new Exception("Invalid response code '" + importResponseWrapper.getStatus() + "' for \"" + string + "\"");
        }
        return importResponseWrapper.getString();
    }

    protected Reader acquireReader(String string) throws IOException, Exception {
        if (!this.isAbsoluteUrl) {
            return new StringReader(this.acquireString(string));
        }
        try {
            int n;
            String string2;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            InputStreamReader inputStreamReader = null;
            String string3 = uRLConnection.getContentType();
            if (string3 != null) {
                string2 = ImportSupport.getContentTypeAttribute(string3, "charset");
                if (string2 == null) {
                    string2 = DEFAULT_ENCODING;
                }
            } else {
                string2 = DEFAULT_ENCODING;
            }
            try {
                inputStreamReader = new InputStreamReader(inputStream, string2);
            }
            catch (Exception exception) {
                inputStreamReader = new InputStreamReader(inputStream, DEFAULT_ENCODING);
            }
            if (uRLConnection instanceof HttpURLConnection && ((n = ((HttpURLConnection)uRLConnection).getResponseCode()) < 200 || n > 299)) {
                throw new Exception(n + " " + string);
            }
            return inputStreamReader;
        }
        catch (IOException iOException) {
            throw new Exception("Problem accessing the absolute URL \"" + string + "\". " + iOException);
        }
        catch (RuntimeException runtimeException) {
            throw new Exception("Problem accessing the absolute URL \"" + string + "\". " + runtimeException);
        }
    }

    public static boolean isAbsoluteUrl(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (VALID_SCHEME_CHARS.indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String stripSession(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((n = stringBuffer.toString().indexOf(";jsessionid=")) != -1) {
            int n2 = stringBuffer.toString().indexOf(";", n + 1);
            if (n2 == -1) {
                n2 = stringBuffer.toString().indexOf("?", n + 1);
            }
            if (n2 == -1) {
                n2 = stringBuffer.length();
            }
            stringBuffer.delete(n, n2);
        }
        return stringBuffer.toString();
    }

    public static String getContentTypeAttribute(String string, String string2) {
        int n;
        int n2;
        int n3 = string.toUpperCase().indexOf(string2.toUpperCase());
        if (n3 == -1) {
            return null;
        }
        n3 += string2.length();
        if ((n3 = string.indexOf(61, n3)) == -1) {
            return null;
        }
        if ((string = string.substring(++n3).trim()).charAt(0) == '\"') {
            n2 = 1;
            n = string.indexOf(34, n2);
            if (n == -1) {
                return null;
            }
        } else {
            n2 = 0;
            n = string.indexOf(59);
            if (n == -1) {
                n = string.indexOf(32);
            }
            if (n == -1) {
                n = string.length();
            }
        }
        return string.substring(n2, n).trim();
    }

    protected class ImportResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter sw;
        private ByteArrayOutputStream bos;
        private boolean isWriterUsed;
        private boolean isStreamUsed;
        private int status = 200;

        public ImportResponseWrapper(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public PrintWriter getWriter() {
            if (this.isStreamUsed) {
                throw new IllegalStateException("Unexpected internal error during import: Target servlet called getWriter(), then getOutputStream()");
            }
            this.isWriterUsed = true;
            if (this.sw == null) {
                this.sw = new StringWriter();
            }
            return new PrintWriter(this.sw);
        }

        public ServletOutputStream getOutputStream() {
            if (this.isWriterUsed) {
                throw new IllegalStateException("Unexpected internal error during import: Target servlet called getOutputStream(), then getWriter()");
            }
            this.isStreamUsed = true;
            if (this.bos == null) {
                this.bos = new ByteArrayOutputStream();
            }
            ServletOutputStream servletOutputStream = new ServletOutputStream(this){
                private final /* synthetic */ ImportResponseWrapper this$1;
                {
                    this.this$1 = importResponseWrapper;
                }

                public void write(int n) throws IOException {
                    ImportResponseWrapper.access$000(this.this$1).write(n);
                }
            };
            return servletOutputStream;
        }

        public void setContentType(String string) {
        }

        public void setLocale(Locale locale) {
        }

        public void setStatus(int n) {
            this.status = n;
        }

        public int getStatus() {
            return this.status;
        }

        public String getString() throws UnsupportedEncodingException {
            if (this.isWriterUsed) {
                return this.sw.toString();
            }
            if (this.isStreamUsed) {
                return this.bos.toString(this.getCharacterEncoding());
            }
            return "";
        }

        static /* synthetic */ ByteArrayOutputStream access$000(ImportResponseWrapper importResponseWrapper) {
            return importResponseWrapper.bos;
        }
    }
}

