/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.als.suggestions.implementation;

import java.io.Serializable;
import org.mulesoft.als.suggestions.implementation.MultilineStartCheckResult;
import org.mulesoft.als.suggestions.implementation.MultilineStartCheckResult$;
import org.mulesoft.als.suggestions.interfaces.LocationKind;
import org.mulesoft.als.suggestions.interfaces.LocationKind$ANNOTATION_COMPLETION$;
import org.mulesoft.als.suggestions.interfaces.LocationKind$DIRECTIVE_COMPLETION$;
import org.mulesoft.als.suggestions.interfaces.LocationKind$INCOMMENT$;
import org.mulesoft.als.suggestions.interfaces.LocationKind$KEY_COMPLETION$;
import org.mulesoft.als.suggestions.interfaces.LocationKind$PATH_COMPLETION$;
import org.mulesoft.als.suggestions.interfaces.LocationKind$SEQUENCE_KEY_COPLETION$;
import org.mulesoft.als.suggestions.interfaces.LocationKind$VALUE_COMPLETION$;
import org.mulesoft.als.suggestions.interfaces.LocationKind$VERSION_COMPLETION$;
import org.mulesoft.positioning.IPositionsMapper;
import org.mulesoft.positioning.PositionsMapper;
import org.mulesoft.positioning.PositionsMapper$;
import org.mulesoft.typesystem.json.interfaces.Point;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class LocationKindDetectTool$ {
    public static LocationKindDetectTool$ MODULE$;
    private final boolean loop_break;
    private final boolean loop_continue;

    static {
        new LocationKindDetectTool$();
    }

    public LocationKind determineCompletionKind(String text, int offset) {
        PositionsMapper pm = PositionsMapper$.MODULE$.apply("file:///determine.completion.kind").withText(text);
        return this.determineCompletionKind((IPositionsMapper)pm, offset);
    }

    public LocationKind determineCompletionKind(IPositionsMapper pm, int offset) {
        LocationKind locationKind;
        if (this.isInsideMultilineValue(pm, offset)) {
            locationKind = LocationKind$VALUE_COMPLETION$.MODULE$;
        } else if (this.isSequenceItemStart(pm, offset)) {
            locationKind = LocationKind$SEQUENCE_KEY_COPLETION$.MODULE$;
        } else {
            Point point = pm.point(offset);
            int column = point.column();
            String posLine = (String)pm.lineString(point.line()).get();
            locationKind = this.checkIfAnnotation(posLine, column) ? LocationKind$ANNOTATION_COMPLETION$.MODULE$ : (this.checkIfPath(posLine, column) ? LocationKind$PATH_COMPLETION$.MODULE$ : (this.checkIfInVersionHeader(posLine, point) ? LocationKind$VERSION_COMPLETION$.MODULE$ : (this.checkIfInComment(posLine, column) ? LocationKind$INCOMMENT$.MODULE$ : (this.checkIfDirective(posLine, column) ? LocationKind$DIRECTIVE_COMPLETION$.MODULE$ : (posLine.lastIndexOf(58, column - 1) < 0 ? LocationKind$KEY_COMPLETION$.MODULE$ : LocationKind$VALUE_COMPLETION$.MODULE$)))));
        }
        return locationKind;
    }

    public boolean isSequenceItemStart(IPositionsMapper pm, int position) {
        boolean bl;
        Point point = pm.point(position);
        String posLine = (String)pm.lineString(point.line()).get();
        if (posLine.lastIndexOf(58, point.column()) >= 0) {
            bl = false;
        } else if (posLine.trim().startsWith("-")) {
            bl = true;
        } else if (point.line() > 0) {
            IntRef offset = IntRef.create((int)pm.lineOffset(posLine));
            BooleanRef sequenceItemStartFound = BooleanRef.create((boolean)false);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), point.line()).reverse().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)line -> {
                boolean bl;
                Option lineStrOpt = pm.lineString(line);
                Option option = lineStrOpt;
                if (option instanceof Some) {
                    boolean bl2;
                    Some some = (Some)option;
                    String lineStr = (String)some.value();
                    if (lineStr.indexOf(58) >= 0) {
                        bl2 = this.loop_break();
                    } else {
                        int lineOffset = pm.lineOffset(lineStr);
                        if (lineOffset < offset$1.elem) {
                            offset$1.elem = lineOffset;
                            if (lineStr.trim().startsWith("-")) {
                                sequenceItemStartFound$1.elem = true;
                                bl2 = this.loop_break();
                            } else {
                                bl2 = this.loop_continue();
                            }
                        } else {
                            bl2 = new StringOps(Predef$.MODULE$.augmentString(lineStr)).nonEmpty() ? this.loop_break() : this.loop_continue();
                        }
                    }
                    bl = bl2;
                } else if (None$.MODULE$.equals(option)) {
                    bl = this.loop_break();
                } else {
                    throw new MatchError((Object)option);
                }
                return bl;
            });
            bl = sequenceItemStartFound.elem;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isInsideMultilineValue(IPositionsMapper pm, int position) {
        boolean bl;
        Point point = pm.point(position);
        if (point.line() == 0) {
            bl = false;
        } else {
            IntRef offset = IntRef.create((int)pm.lineOffset(((String)pm.lineString(point.line()).get()).substring(0, point.column())));
            BooleanRef multilineStartFound = BooleanRef.create((boolean)false);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), point.line()).reverse().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)line -> {
                boolean bl;
                Option lineStrOpt = pm.lineString(line);
                Option option = lineStrOpt;
                if (option instanceof Some) {
                    boolean bl2;
                    Some some = (Some)option;
                    String lineStr = (String)some.value();
                    int lineOffset = pm.lineOffset(lineStr);
                    if (lineOffset < offset$2.elem) {
                        boolean bl3;
                        offset$2.elem = lineOffset;
                        MultilineStartCheckResult multilineStartCheckResult = this.isMultilineStringStart(lineStr);
                        MultilineStartCheckResult multilineStartCheckResult2 = MultilineStartCheckResult$.MODULE$.FALSE();
                        MultilineStartCheckResult multilineStartCheckResult3 = multilineStartCheckResult;
                        if (!(multilineStartCheckResult2 != null ? !multilineStartCheckResult2.equals(multilineStartCheckResult3) : multilineStartCheckResult3 != null)) {
                            bl3 = this.loop_continue();
                        } else {
                            MultilineStartCheckResult multilineStartCheckResult4 = MultilineStartCheckResult$.MODULE$.TRUE();
                            MultilineStartCheckResult multilineStartCheckResult5 = multilineStartCheckResult;
                            if (!(multilineStartCheckResult4 != null ? !multilineStartCheckResult4.equals(multilineStartCheckResult5) : multilineStartCheckResult5 != null)) {
                                multilineStartFound$1.elem = true;
                                bl3 = this.loop_break();
                            } else {
                                MultilineStartCheckResult multilineStartCheckResult6 = MultilineStartCheckResult$.MODULE$.FAIL();
                                MultilineStartCheckResult multilineStartCheckResult7 = multilineStartCheckResult;
                                bl3 = !(multilineStartCheckResult6 != null ? !multilineStartCheckResult6.equals(multilineStartCheckResult7) : multilineStartCheckResult7 != null) ? this.loop_break() : this.loop_break();
                            }
                        }
                        bl2 = bl3;
                    } else {
                        bl2 = this.loop_continue();
                    }
                    bl = bl2;
                } else if (None$.MODULE$.equals(option)) {
                    bl = this.loop_break();
                } else {
                    throw new MatchError((Object)option);
                }
                return bl;
            });
            bl = multilineStartFound.elem;
        }
        return bl;
    }

    private MultilineStartCheckResult isMultilineStringStart(String str) {
        MultilineStartCheckResult multilineStartCheckResult;
        int end = str.length();
        if (str.endsWith("\n")) {
            --end;
        }
        if (str.endsWith("\r")) {
            --end;
        }
        if (end == 0) {
            multilineStartCheckResult = MultilineStartCheckResult$.MODULE$.FALSE();
        } else {
            int firstNonWhiteSpaceIndex = new StringOps(Predef$.MODULE$.augmentString(str)).lastIndexWhere((Function1 & Serializable & scala.Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)LocationKindDetectTool$.$anonfun$isMultilineStringStart$1(BoxesRunTime.unboxToChar((Object)ch))), end - 1);
            if (firstNonWhiteSpaceIndex < 2) {
                multilineStartCheckResult = MultilineStartCheckResult$.MODULE$.FAIL();
            } else if (str.charAt(firstNonWhiteSpaceIndex) != '|') {
                multilineStartCheckResult = MultilineStartCheckResult$.MODULE$.FALSE();
            } else {
                int secondNonWhiteSpaceIndex = new StringOps(Predef$.MODULE$.augmentString(str)).lastIndexWhere((Function1 & Serializable & scala.Serializable)ch -> BoxesRunTime.boxToBoolean((boolean)LocationKindDetectTool$.$anonfun$isMultilineStringStart$2(BoxesRunTime.unboxToChar((Object)ch))), firstNonWhiteSpaceIndex - 1);
                if (secondNonWhiteSpaceIndex < 1) {
                    multilineStartCheckResult = MultilineStartCheckResult$.MODULE$.FAIL();
                } else if (str.charAt(secondNonWhiteSpaceIndex) != ':') {
                    multilineStartCheckResult = MultilineStartCheckResult$.MODULE$.FALSE();
                } else if (str.substring(0, secondNonWhiteSpaceIndex).trim().isEmpty()) {
                    multilineStartCheckResult = MultilineStartCheckResult$.MODULE$.FALSE();
                } else {
                    int extraColonindex = str.lastIndexOf(58, secondNonWhiteSpaceIndex - 1);
                    Object object = extraColonindex >= 0 ? MultilineStartCheckResult$.MODULE$.FALSE() : BoxedUnit.UNIT;
                    multilineStartCheckResult = MultilineStartCheckResult$.MODULE$.TRUE();
                }
            }
        }
        return multilineStartCheckResult;
    }

    public boolean checkIfAnnotation(String _line, int column) {
        int colonIndex;
        int closeBracketIndex;
        int lineStart = 0;
        int lineEnd = _line.length();
        String line = _line.substring(lineStart, lineEnd);
        int openBracketIndex = line.indexOf("(", lineStart);
        return openBracketIndex < 0 ? false : (new StringOps(Predef$.MODULE$.augmentString(line.substring(0, openBracketIndex).trim())).nonEmpty() ? false : ((closeBracketIndex = line.indexOf(")", column)) < 0 ? true : (line.substring(openBracketIndex, closeBracketIndex).indexOf(":") >= 0 ? false : (line.substring(closeBracketIndex + 1).trim().isEmpty() ? true : (colonIndex = line.indexOf(":", closeBracketIndex)) > 0 && line.substring(closeBracketIndex + 1, colonIndex).trim().isEmpty()))));
    }

    public boolean checkIfPath(String _line, int column) {
        boolean lineStart = false;
        int searchStart = column - "!include".length();
        int includeIndex = _line.lastIndexOf("!include", searchStart);
        return includeIndex >= 0;
    }

    public boolean checkIfDirective(String _line, int column) {
        boolean bl;
        int includePotentialIndex = _line.lastIndexOf("!i", column);
        if (includePotentialIndex >= 0) {
            String segment = _line.substring(includePotentialIndex, column);
            bl = "!include".startsWith(segment);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean checkIfInVersionHeader(String lineString, Point point) {
        return point.line() != 0 ? false : lineString.startsWith("#");
    }

    public boolean checkIfInComment(String _line, int column) {
        int commentStart = _line.lastIndexOf("#", column);
        return commentStart >= 0;
    }

    private boolean loop_break() {
        return this.loop_break;
    }

    private boolean loop_continue() {
        return this.loop_continue;
    }

    public static final /* synthetic */ boolean $anonfun$isMultilineStringStart$1(char ch) {
        return ch != ' ' && ch != '\t';
    }

    public static final /* synthetic */ boolean $anonfun$isMultilineStringStart$2(char ch) {
        return ch != ' ' && ch != '\t';
    }

    private LocationKindDetectTool$() {
        MODULE$ = this;
        this.loop_break = true;
        this.loop_continue = false;
    }
}

