/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.io.csv.AddCellToColumnException;

@Immutable
public class CsvReader {
    private static Predicate<String> isBoolean = s -> TypeUtils.TRUE_STRINGS_FOR_DETECTION.contains(s) || TypeUtils.FALSE_STRINGS_FOR_DETECTION.contains(s);
    private static Predicate<String> isLong = new Predicate<String>(){

        @Override
        public boolean test(@Nullable String s) {
            try {
                Long.parseLong(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    };
    private static Predicate<String> isInteger = s -> {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private static Predicate<String> isFloat = s -> {
        try {
            Float.parseFloat(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private static Predicate<String> isDouble = s -> {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private static Predicate<String> isShort = s -> {
        try {
            Short.parseShort(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    private static Predicate<String> isLocalDate = s -> {
        try {
            LocalDate.parse(s, TypeUtils.DATE_FORMATTER);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    };
    private static Predicate<String> isLocalTime = s -> {
        try {
            LocalTime.parse(s, TypeUtils.TIME_DETECTION_FORMATTER);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    };
    private static Predicate<String> isLocalDateTime = s -> {
        try {
            LocalDateTime.parse(s, TypeUtils.DATE_TIME_FORMATTER);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    };

    private CsvReader() {
    }

    public static Table read(ColumnType[] types, String ... fileNames) throws IOException {
        if (fileNames.length == 1) {
            return CsvReader.read(types, true, ',', fileNames[0]);
        }
        Table table = CsvReader.read(types, true, ',', fileNames[0]);
        for (int i = 1; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            table.append(CsvReader.read(types, true, ',', fileName));
        }
        return table;
    }

    public static Table read(ColumnType[] types, boolean header, char columnSeparator, String fileName) throws IOException {
        FileReader reader = new FileReader(new File(fileName));
        return CsvReader.read((Reader)reader, fileName, types, header, columnSeparator);
    }

    public static Table read(File file, boolean header, char delimiter) throws IOException {
        FileReader reader = new FileReader(file);
        return CsvReader.read(reader, file.getName(), true, delimiter);
    }

    public static Table read(Reader reader, String tableName, boolean header, char delimiter) throws IOException {
        return CsvReader.read(reader, tableName, true, delimiter, false);
    }

    public static Table read(Reader reader, String tableName, boolean header, char delimiter, boolean skipSampling) throws IOException {
        List<String[]> rows = CsvReader.parseCsv(reader, delimiter);
        ColumnType[] columnTypes = CsvReader.detectColumnTypes(rows, header, delimiter, skipSampling);
        return CsvReader.read(rows, tableName, columnTypes, true, delimiter);
    }

    public static Table read(Reader reader, String tableName, ColumnType[] types, boolean header, char columnSeparator) throws IOException {
        List<String[]> rows = CsvReader.parseCsv(reader, columnSeparator);
        return CsvReader.read(rows, tableName, types, header, columnSeparator);
    }

    protected static Table read(List<String[]> rows, String tableName, ColumnType[] types, boolean header, char columnSeparator) throws IOException {
        Object[] columnNames;
        ArrayList headerRow;
        if (header) {
            headerRow = Lists.newArrayList((Object[])rows.remove(0));
            columnNames = CsvReader.selectColumnNames(headerRow, types);
        } else {
            columnNames = CsvReader.makeColumnNames(types);
            headerRow = Lists.newArrayList((Object[])columnNames);
        }
        Table table = Table.create(tableName);
        for (int x = 0; x < types.length; ++x) {
            if (types[x] == ColumnType.SKIP) continue;
            String columnName = (String)headerRow.get(x);
            if (Strings.isNullOrEmpty((String)columnName)) {
                columnName = "Column " + table.columnCount();
            }
            Column newColumn = TypeUtils.newColumn(columnName.trim(), types[x]);
            table.addColumn(newColumn);
        }
        int[] columnIndexes = new int[columnNames.length];
        for (int i = 0; i < columnIndexes.length; ++i) {
            columnIndexes[i] = headerRow.indexOf(columnNames[i]);
        }
        long rowNumber = header ? 1L : 0L;
        for (String[] nextLine : rows) {
            int cellIndex = 0;
            for (int columnIndex : columnIndexes) {
                Column column = table.column(cellIndex);
                try {
                    column.appendCell(nextLine[columnIndex]);
                }
                catch (Exception e) {
                    throw new AddCellToColumnException(e, columnIndex, rowNumber, (String[])columnNames, nextLine);
                }
                ++cellIndex;
            }
            ++rowNumber;
        }
        return table;
    }

    public static Table headerOnly(ColumnType[] types, boolean header, char columnSeparator, File file) throws IOException {
        Table table;
        FileReader reader = new FileReader(file);
        BufferedReader streamReader = new BufferedReader(reader);
        try (CSVReader csvReader = new CSVReader((Reader)streamReader, columnSeparator, '\"');){
            Object[] columnNames;
            ArrayList headerRow;
            Object[] nextLine;
            if (header) {
                nextLine = csvReader.readNext();
                headerRow = Lists.newArrayList((Object[])nextLine);
                columnNames = CsvReader.selectColumnNames(headerRow, types);
            } else {
                columnNames = CsvReader.makeColumnNames(types);
                headerRow = Lists.newArrayList((Object[])columnNames);
            }
            table = Table.create(file.getName());
            for (int x = 0; x < types.length; ++x) {
                if (types[x] == ColumnType.SKIP) continue;
                Column newColumn = TypeUtils.newColumn(((String)headerRow.get(x)).trim(), types[x]);
                table.addColumn(newColumn);
            }
            int[] columnIndexes = new int[columnNames.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                columnIndexes[i] = headerRow.indexOf(columnNames[i]);
            }
            while ((nextLine = csvReader.readNext()) != null) {
                int cellIndex = 0;
                for (int columnIndex : columnIndexes) {
                    Column column = table.column(cellIndex);
                    column.appendCell((String)nextLine[columnIndex]);
                    ++cellIndex;
                }
            }
        }
        return table;
    }

    private static Table detectedColumnTypes(String csvFileName, boolean header, char delimiter) throws IOException {
        File file = new File(csvFileName);
        List<String[]> rows = CsvReader.parseCsv(new FileReader(file), delimiter);
        ColumnType[] types = CsvReader.detectColumnTypes(rows, header, delimiter, false);
        Table t = CsvReader.headerOnly(types, header, delimiter, file);
        return t.structure();
    }

    public static String printColumnTypes(String csvFileName, boolean header, char delimiter) throws IOException {
        Table structure = CsvReader.detectedColumnTypes(csvFileName, header, delimiter);
        StringBuilder buf = new StringBuilder();
        buf.append("ColumnType[] columnTypes = {");
        buf.append('\n');
        Column typeCol = structure.column("Column Type");
        Column indxCol = structure.column("Index");
        Column nameCol = structure.column("Column Name");
        int typeColIndex = structure.columnIndex(typeCol);
        int indxColIndex = structure.columnIndex(indxCol);
        int nameColIndex = structure.columnIndex(nameCol);
        int typeColWidth = typeCol.columnWidth();
        int indxColWidth = indxCol.columnWidth();
        int nameColWidth = nameCol.columnWidth();
        for (int r = 0; r < structure.rowCount(); ++r) {
            String cell = StringUtils.rightPad((String)(structure.get(typeColIndex, r) + ","), (int)typeColWidth);
            buf.append(cell);
            buf.append(" // ");
            cell = StringUtils.rightPad((String)structure.get(indxColIndex, r), (int)indxColWidth);
            buf.append(cell);
            buf.append(' ');
            cell = StringUtils.rightPad((String)structure.get(nameColIndex, r), (int)nameColWidth);
            buf.append(cell);
            buf.append(' ');
            buf.append('\n');
        }
        buf.append("}");
        buf.append('\n');
        return buf.toString();
    }

    private static String[] selectColumnNames(List<String> names, ColumnType[] types) {
        ArrayList<String> header = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == ColumnType.SKIP) continue;
            header.add(names.get(i).trim());
        }
        String[] result = new String[header.size()];
        return header.toArray(result);
    }

    private static String[] makeColumnNames(ColumnType[] types) {
        String[] header = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            header[i] = "C" + i;
        }
        return header;
    }

    protected static List<String[]> parseCsv(Reader reader, char delimiter) throws IOException {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        try (CSVReader csvReader = new CSVReader(reader, delimiter, '\"', 0);){
            String[] nextLine;
            while ((nextLine = csvReader.readNext()) != null) {
                rows.add(nextLine);
            }
        }
        return rows;
    }

    protected static ColumnType[] detectColumnTypes(List<String[]> rows, boolean header, char delimiter, boolean skipSampling) throws IOException {
        ArrayList<ColumnType> columnTypes = new ArrayList<ColumnType>();
        ArrayList columnData = new ArrayList();
        int rowCount = 0;
        int nextRow = 0;
        for (int i = 0; i < rows.size(); ++i) {
            if (header && i == 0) continue;
            String[] stringArray = rows.get(i);
            if (rowCount == 0) {
                for (int j = 0; j < stringArray.length; ++j) {
                    columnData.add(new ArrayList());
                }
            }
            int columnNumber = 0;
            if (rowCount == nextRow) {
                for (String field : stringArray) {
                    ((List)columnData.get(columnNumber)).add(field);
                    ++columnNumber;
                }
            }
            if (rowCount == nextRow) {
                nextRow = skipSampling ? CsvReader.nextRowWithoutSampling(nextRow) : CsvReader.nextRow(nextRow);
            }
            ++rowCount;
        }
        for (List list : columnData) {
            ColumnType detectedType = CsvReader.detectType(list);
            columnTypes.add(detectedType);
        }
        return columnTypes.toArray(new ColumnType[columnTypes.size()]);
    }

    private static int nextRowWithoutSampling(int nextRow) {
        return nextRow + 1;
    }

    private static int nextRow(int nextRow) {
        if (nextRow < 100) {
            return nextRow + 1;
        }
        if (nextRow < 1000) {
            return nextRow + 10;
        }
        if (nextRow < 10000) {
            return nextRow + 100;
        }
        if (nextRow < 100000) {
            return nextRow + 1000;
        }
        if (nextRow < 1000000) {
            return nextRow + 10000;
        }
        if (nextRow < 10000000) {
            return nextRow + 100000;
        }
        if (nextRow < 100000000) {
            return nextRow + 1000000;
        }
        return nextRow + 10000000;
    }

    private static ColumnType detectType(List<String> valuesList) {
        ColumnType[] typeArray = new ColumnType[]{ColumnType.LOCAL_DATE_TIME, ColumnType.LOCAL_TIME, ColumnType.LOCAL_DATE, ColumnType.BOOLEAN, ColumnType.SHORT_INT, ColumnType.INTEGER, ColumnType.LONG_INT, ColumnType.FLOAT, ColumnType.DOUBLE};
        CopyOnWriteArrayList<ColumnType> typeCandidates = new CopyOnWriteArrayList<ColumnType>(typeArray);
        for (String s : valuesList) {
            if (Strings.isNullOrEmpty((String)s) || TypeUtils.MISSING_INDICATORS.contains((Object)s)) continue;
            if (typeCandidates.contains((Object)ColumnType.LOCAL_DATE_TIME) && !isLocalDateTime.test(s)) {
                typeCandidates.remove((Object)ColumnType.LOCAL_DATE_TIME);
            }
            if (typeCandidates.contains((Object)ColumnType.LOCAL_TIME) && !isLocalTime.test(s)) {
                typeCandidates.remove((Object)ColumnType.LOCAL_TIME);
            }
            if (typeCandidates.contains((Object)ColumnType.LOCAL_DATE) && !isLocalDate.test(s)) {
                typeCandidates.remove((Object)ColumnType.LOCAL_DATE);
            }
            if (typeCandidates.contains((Object)ColumnType.BOOLEAN) && !isBoolean.test(s)) {
                typeCandidates.remove((Object)ColumnType.BOOLEAN);
            }
            if (typeCandidates.contains((Object)ColumnType.SHORT_INT) && !isShort.test(s)) {
                typeCandidates.remove((Object)ColumnType.SHORT_INT);
            }
            if (typeCandidates.contains((Object)ColumnType.INTEGER) && !isInteger.test(s)) {
                typeCandidates.remove((Object)ColumnType.INTEGER);
            }
            if (typeCandidates.contains((Object)ColumnType.LONG_INT) && !isLong.test(s)) {
                typeCandidates.remove((Object)ColumnType.LONG_INT);
            }
            if (typeCandidates.contains((Object)ColumnType.FLOAT) && !isFloat.test(s)) {
                typeCandidates.remove((Object)ColumnType.FLOAT);
            }
            if (!typeCandidates.contains((Object)ColumnType.DOUBLE) || isDouble.test(s)) continue;
            typeCandidates.remove((Object)ColumnType.DOUBLE);
        }
        return CsvReader.selectType(typeCandidates);
    }

    private static ColumnType selectType(List<ColumnType> typeCandidates) {
        if (typeCandidates.isEmpty()) {
            return ColumnType.CATEGORY;
        }
        return typeCandidates.get(0);
    }
}

