/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.ml.association;

import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortRBTreeSet;
import java.util.Arrays;
import java.util.List;
import smile.association.ARM;
import smile.association.AssociationRule;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.table.TemporaryView;
import tech.tablesaw.table.ViewGroup;

public class AssociationRuleMining {
    private final ARM model;

    public AssociationRuleMining(ShortColumn sets, ShortColumn items, double support) {
        Table temp = Table.create("temp");
        temp.addColumn(sets.copy());
        temp.addColumn(items.copy());
        temp.sortAscendingOn(sets.name(), items.name());
        ViewGroup baskets = temp.splitOn(temp.column(0));
        int[][] itemsets = new int[baskets.size()][];
        int basketIndex = 0;
        for (TemporaryView basket : baskets) {
            ShortRBTreeSet set = new ShortRBTreeSet((ShortCollection)basket.shortColumn(1).data());
            int itemIndex = 0;
            itemsets[basketIndex] = new int[set.size()];
            ShortBidirectionalIterator shortBidirectionalIterator = set.iterator();
            while (shortBidirectionalIterator.hasNext()) {
                short item = (Short)shortBidirectionalIterator.next();
                itemsets[basketIndex][itemIndex] = item;
                ++itemIndex;
            }
            ++basketIndex;
        }
        this.model = new ARM((int[][])itemsets, support);
    }

    public AssociationRuleMining(IntColumn sets, CategoryColumn items, double support) {
        Table temp = Table.create("temp");
        temp.addColumn(sets.copy());
        temp.addColumn(items.toIntColumn());
        temp.sortAscendingOn(sets.name(), items.name());
        ViewGroup baskets = temp.splitOn(temp.column(0));
        int[][] itemsets = new int[baskets.size()][];
        int basketIndex = 0;
        for (TemporaryView basket : baskets) {
            IntRBTreeSet set = new IntRBTreeSet((IntCollection)basket.intColumn(1).data());
            int itemIndex = 0;
            itemsets[basketIndex] = new int[set.size()];
            IntBidirectionalIterator intBidirectionalIterator = set.iterator();
            while (intBidirectionalIterator.hasNext()) {
                int item;
                itemsets[basketIndex][itemIndex] = item = ((Integer)intBidirectionalIterator.next()).intValue();
                ++itemIndex;
            }
            ++basketIndex;
        }
        this.model = new ARM((int[][])itemsets, support);
    }

    public List<AssociationRule> learn(double confidenceThreshold) {
        return this.model.learn(confidenceThreshold);
    }

    public List<AssociationRule> interestingRules(double confidenceThreshold, double interestThreshold, Object2DoubleOpenHashMap confidenceMap) {
        List rules = this.model.learn(confidenceThreshold);
        for (AssociationRule rule : rules) {
            double interest = rule.confidence - confidenceMap.getDouble((Object)rule.consequent);
            if (!(Math.abs(interest) < interestThreshold)) continue;
            rules.remove(rule);
        }
        return rules;
    }

    public Table interest(double confidenceThreshold, double interestThreshold, Object2DoubleOpenHashMap<IntRBTreeSet> confidenceMap) {
        Table interestTable = Table.create("Interest");
        interestTable.addColumn(new CategoryColumn("Antecedent"));
        interestTable.addColumn(new CategoryColumn("Consequent"));
        interestTable.addColumn(new FloatColumn("Confidence"));
        interestTable.addColumn(new FloatColumn("Interest"));
        List rules = this.model.learn(confidenceThreshold);
        for (AssociationRule rule : rules) {
            double interest = rule.confidence - confidenceMap.getDouble((Object)new IntRBTreeSet(rule.consequent));
            if (!(Math.abs(interest) > interestThreshold)) continue;
            interestTable.categoryColumn(0).appendCell(Arrays.toString(rule.antecedent));
            interestTable.categoryColumn(1).appendCell(Arrays.toString(rule.consequent));
            interestTable.floatColumn(2).append(rule.confidence);
            interestTable.floatColumn(3).append(interest);
        }
        return interestTable;
    }
}

