package tech.tablesaw.util;

import it.unimi.dsi.fastutil.ints.IntComparator;

import javax.annotation.concurrent.Immutable;

/**
 * A Comparator to sort int primitives in reverse order, selectWhere the un-reversed order is defined by another
 * comparator
 */
@Immutable
public final class ReversingIntComparator implements IntComparator {

    private final IntComparator intComparator;

    private ReversingIntComparator(IntComparator intComparator) {
        this.intComparator = intComparator;
    }

    public static IntComparator reverse(IntComparator intComparator) {
        return new ReversingIntComparator(intComparator);
    }

    @Override
    public int compare(int i, int i1) {
        return -intComparator.compare(i, i1);
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return -intComparator.compare(o1, o2);
    }
}
