/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.joining;

import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TextColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.booleans.BooleanColumnType;
import tech.tablesaw.columns.dates.DateColumnType;
import tech.tablesaw.columns.datetimes.DateTimeColumnType;
import tech.tablesaw.columns.instant.InstantColumnType;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.FloatColumnType;
import tech.tablesaw.columns.numbers.IntColumnType;
import tech.tablesaw.columns.numbers.LongColumnType;
import tech.tablesaw.columns.numbers.ShortColumnType;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.columns.strings.TextColumnType;
import tech.tablesaw.columns.times.TimeColumnType;
import tech.tablesaw.index.ByteIndex;
import tech.tablesaw.index.DoubleIndex;
import tech.tablesaw.index.FloatIndex;
import tech.tablesaw.index.Index;
import tech.tablesaw.index.IntIndex;
import tech.tablesaw.index.LongIndex;
import tech.tablesaw.index.ShortIndex;
import tech.tablesaw.index.StringIndex;
import tech.tablesaw.selection.Selection;

public class DataFrameJoiner {
    private static final String TABLE_ALIAS = "T";
    private final Table table;
    private final String[] joinColumnNames;
    private final List<Integer> joinColumnIndexes;
    private final AtomicInteger joinTableId = new AtomicInteger(2);

    public DataFrameJoiner(Table table, String ... joinColumnNames) {
        this.table = table;
        this.joinColumnNames = joinColumnNames;
        this.joinColumnIndexes = this.getJoinIndexes(table, joinColumnNames);
    }

    private List<Integer> getJoinIndexes(Table table, String[] columnNames) {
        return Arrays.stream(columnNames).map(table::columnIndex).collect(Collectors.toList());
    }

    public Table inner(Table ... tables) {
        return this.inner(false, tables);
    }

    public Table inner(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table currT : tables) {
            joined = this.joinInternal(joined, currT, JoinType.INNER, allowDuplicateColumnNames, false, this.joinColumnNames);
        }
        return joined;
    }

    public Table inner(Table table2, String col2Name) {
        return this.inner(table2, false, col2Name);
    }

    public Table inner(Table table2, String[] col2Names) {
        return this.inner(table2, false, col2Names);
    }

    public Table inner(Table table2, String col2Name, boolean allowDuplicateColumnNames) {
        return this.inner(table2, allowDuplicateColumnNames, col2Name);
    }

    public Table inner(Table table2, boolean allowDuplicateColumnNames, String ... col2Names) {
        Table joinedTable = this.joinInternal(this.table, table2, JoinType.INNER, allowDuplicateColumnNames, false, col2Names);
        return joinedTable;
    }

    public Table inner(Table table2, boolean allowDuplicateColumnNames, boolean keepAllJoinKeyColumns, String ... col2Names) {
        return this.joinInternal(this.table, table2, JoinType.INNER, allowDuplicateColumnNames, keepAllJoinKeyColumns, col2Names);
    }

    private Table joinInternal(Table table1, Table table2, JoinType joinType, boolean allowDuplicates, boolean keepAllJoinKeyColumns, String ... table2JoinColumnNames) {
        List<Integer> table2JoinColumnIndexes = this.getJoinIndexes(table2, table2JoinColumnNames);
        List<Index> table1Indexes = this.buildIndexesForJoinColumns(this.joinColumnIndexes, table1);
        List<Index> table2Indexes = this.buildIndexesForJoinColumns(table2JoinColumnIndexes, table2);
        Table result = Table.create(table1.name());
        Set<Integer> resultIgnoreColIndexes = this.emptyTableFromColumns(result, table1, table2, joinType, allowDuplicates, table2JoinColumnIndexes, keepAllJoinKeyColumns);
        this.validateIndexes(table1Indexes, table2Indexes);
        if (table1.rowCount() == 0 && (joinType == JoinType.LEFT_OUTER || joinType == JoinType.INNER)) {
            if (!keepAllJoinKeyColumns) {
                result.removeColumns(Ints.toArray(resultIgnoreColIndexes));
            }
            return result;
        }
        Selection table1DoneRows = Selection.with(new int[0]);
        Selection table2DoneRows = Selection.with(new int[0]);
        if (table1.rowCount() > table2.rowCount() && joinType == JoinType.INNER) {
            for (Row row : table2) {
                int ri = row.getRowNumber();
                if (table2DoneRows.contains(ri)) continue;
                Selection table1Rows = this.createMultiColSelection(table2, ri, table1Indexes, table1.rowCount(), table2JoinColumnIndexes);
                Selection table2Rows = this.createMultiColSelection(table2, ri, table2Indexes, table2.rowCount(), table2JoinColumnIndexes);
                this.crossProduct(result, table1, table2, table1Rows, table2Rows, resultIgnoreColIndexes, keepAllJoinKeyColumns);
                if ((table2DoneRows = table2DoneRows.or(table2Rows)).size() != table2.rowCount()) continue;
                if (!keepAllJoinKeyColumns) {
                    result.removeColumns(Ints.toArray(resultIgnoreColIndexes));
                }
                return result;
            }
        } else {
            for (Row row : table1) {
                int ri = row.getRowNumber();
                if (table1DoneRows.contains(ri)) continue;
                Selection table1Rows = this.createMultiColSelection(table1, ri, table1Indexes, table1.rowCount(), this.joinColumnIndexes);
                Selection table2Rows = this.createMultiColSelection(table1, ri, table2Indexes, table2.rowCount(), this.joinColumnIndexes);
                if ((joinType == JoinType.LEFT_OUTER || joinType == JoinType.FULL_OUTER) && table2Rows.isEmpty()) {
                    this.withMissingLeftJoin(result, table1, table1Rows, resultIgnoreColIndexes, keepAllJoinKeyColumns);
                } else {
                    this.crossProduct(result, table1, table2, table1Rows, table2Rows, resultIgnoreColIndexes, keepAllJoinKeyColumns);
                }
                table1DoneRows = table1DoneRows.or(table1Rows);
                if (joinType == JoinType.FULL_OUTER || joinType == JoinType.RIGHT_OUTER) {
                    table2DoneRows = table2DoneRows.or(table2Rows);
                    continue;
                }
                if (table1DoneRows.size() != table1.rowCount()) continue;
                if (!keepAllJoinKeyColumns) {
                    result.removeColumns(Ints.toArray(resultIgnoreColIndexes));
                }
                return result;
            }
        }
        Selection table2Rows = table2DoneRows.flip(0, table2.rowCount());
        this.withMissingRight(result, table1.columnCount(), table2, table2Rows, joinType, table2JoinColumnIndexes, resultIgnoreColIndexes, keepAllJoinKeyColumns);
        if (!keepAllJoinKeyColumns) {
            result.removeColumns(Ints.toArray(resultIgnoreColIndexes));
        }
        return result;
    }

    private void validateIndexes(List<Index> table1Indexes, List<Index> table2Indexes) {
        if (table1Indexes.size() != table2Indexes.size()) {
            throw new IllegalArgumentException("Cannot join using a different number of indices on each table: " + table1Indexes + " and " + table2Indexes);
        }
        for (int i = 0; i < table1Indexes.size(); ++i) {
            if (table1Indexes.get(i).getClass().equals(table2Indexes.get(i).getClass())) continue;
            throw new IllegalArgumentException("Cannot join using different index types: " + table1Indexes + " and " + table2Indexes);
        }
    }

    private List<Index> buildIndexesForJoinColumns(List<Integer> joinColumnIndexes, Table table) {
        return joinColumnIndexes.stream().map(c -> this.indexFor(table, (int)c)).collect(Collectors.toList());
    }

    private Index indexFor(Table table, int colIndex) {
        ColumnType type = table.column(colIndex).type();
        if (type instanceof DateColumnType) {
            return new IntIndex(table.dateColumn(colIndex));
        }
        if (type instanceof DateTimeColumnType) {
            return new LongIndex(table.dateTimeColumn(colIndex));
        }
        if (type instanceof InstantColumnType) {
            return new LongIndex(table.instantColumn(colIndex));
        }
        if (type instanceof TimeColumnType) {
            return new IntIndex(table.timeColumn(colIndex));
        }
        if (type instanceof StringColumnType) {
            return new StringIndex(table.stringColumn(colIndex));
        }
        if (type instanceof TextColumnType) {
            return new StringIndex(table.textColumn(colIndex));
        }
        if (type instanceof IntColumnType) {
            return new IntIndex(table.intColumn(colIndex));
        }
        if (type instanceof LongColumnType) {
            return new LongIndex(table.longColumn(colIndex));
        }
        if (type instanceof ShortColumnType) {
            return new ShortIndex(table.shortColumn(colIndex));
        }
        if (type instanceof BooleanColumnType) {
            return new ByteIndex(table.booleanColumn(colIndex));
        }
        if (type instanceof DoubleColumnType) {
            return new DoubleIndex(table.doubleColumn(colIndex));
        }
        if (type instanceof FloatColumnType) {
            return new FloatIndex(table.floatColumn(colIndex));
        }
        throw new IllegalArgumentException("Joining attempted on unsupported column type " + type);
    }

    private Selection selectionForColumn(Column<?> valueColumn, int rowIndex, Index rawIndex) {
        ColumnType type = valueColumn.type();
        if (type instanceof DateColumnType) {
            IntIndex index = (IntIndex)rawIndex;
            int value = ((DateColumn)valueColumn).getIntInternal(rowIndex);
            return index.get(value);
        }
        if (type instanceof TimeColumnType) {
            IntIndex index = (IntIndex)rawIndex;
            int value = ((TimeColumn)valueColumn).getIntInternal(rowIndex);
            return index.get(value);
        }
        if (type instanceof DateTimeColumnType) {
            LongIndex index = (LongIndex)rawIndex;
            long value = ((DateTimeColumn)valueColumn).getLongInternal(rowIndex);
            return index.get(value);
        }
        if (type instanceof InstantColumnType) {
            LongIndex index = (LongIndex)rawIndex;
            long value = ((InstantColumn)valueColumn).getLongInternal(rowIndex);
            return index.get(value);
        }
        if (type instanceof StringColumnType) {
            StringIndex index = (StringIndex)rawIndex;
            String value = ((StringColumn)valueColumn).get(rowIndex);
            return index.get(value);
        }
        if (type instanceof TextColumnType) {
            StringIndex index = (StringIndex)rawIndex;
            String value = ((TextColumn)valueColumn).get(rowIndex);
            return index.get(value);
        }
        if (type instanceof IntColumnType) {
            IntIndex index = (IntIndex)rawIndex;
            int value = ((IntColumn)valueColumn).getInt(rowIndex);
            return index.get(value);
        }
        if (type instanceof LongColumnType) {
            LongIndex index = (LongIndex)rawIndex;
            long value = ((LongColumn)valueColumn).getLong(rowIndex);
            return index.get(value);
        }
        if (type instanceof ShortColumnType) {
            ShortIndex index = (ShortIndex)rawIndex;
            short value = ((ShortColumn)valueColumn).getShort(rowIndex);
            return index.get(value);
        }
        if (type instanceof BooleanColumnType) {
            ByteIndex index = (ByteIndex)rawIndex;
            byte value = ((BooleanColumn)valueColumn).getByte(rowIndex);
            return index.get(value);
        }
        if (type instanceof DoubleColumnType) {
            DoubleIndex index = (DoubleIndex)rawIndex;
            double value = ((DoubleColumn)valueColumn).getDouble(rowIndex);
            return index.get(value);
        }
        if (type instanceof FloatColumnType) {
            FloatIndex index = (FloatIndex)rawIndex;
            float value = ((FloatColumn)valueColumn).getFloat(rowIndex);
            return index.get(value);
        }
        throw new IllegalArgumentException("Joining is supported on numeric, string, and date-like columns. Column " + valueColumn.name() + " is of type " + valueColumn.type());
    }

    private Selection createMultiColSelection(Table table, int ri, List<Index> indexes, int selectionSize, List<Integer> joinColumnIndexes) {
        Selection multiColSelection = Selection.withRange(0, selectionSize);
        int i = 0;
        for (Integer joinColumnIndex : joinColumnIndexes) {
            Column<?> col = table.column(joinColumnIndex);
            Selection oneColSelection = this.selectionForColumn(col, ri, indexes.get(i));
            multiColSelection = multiColSelection.and(oneColSelection);
            ++i;
        }
        return multiColSelection;
    }

    private String newName(String table2Alias, String columnName) {
        return table2Alias + "." + columnName;
    }

    public Table fullOuter(Table ... tables) {
        return this.fullOuter(false, tables);
    }

    public Table fullOuter(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table currT : tables) {
            joined = this.joinInternal(joined, currT, JoinType.FULL_OUTER, allowDuplicateColumnNames, false, this.joinColumnNames);
        }
        return joined;
    }

    public Table fullOuter(Table table2, boolean allowDuplicateColumnNames, boolean keepAllJoinKeyColumns, String ... col2Names) {
        return this.joinInternal(this.table, table2, JoinType.FULL_OUTER, allowDuplicateColumnNames, keepAllJoinKeyColumns, col2Names);
    }

    public Table fullOuter(Table table2, String col2Name) {
        return this.joinInternal(this.table, table2, JoinType.FULL_OUTER, false, false, col2Name);
    }

    public Table leftOuter(Table ... tables) {
        return this.leftOuter(false, tables);
    }

    public Table leftOuter(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.joinInternal(joined, table2, JoinType.LEFT_OUTER, allowDuplicateColumnNames, false, this.joinColumnNames);
        }
        return joined;
    }

    public Table leftOuter(Table table2, String[] col2Names) {
        return this.leftOuter(table2, false, col2Names);
    }

    public Table leftOuter(Table table2, String col2Name) {
        return this.leftOuter(table2, false, col2Name);
    }

    public Table leftOuter(Table table2, boolean allowDuplicateColumnNames, String ... col2Names) {
        return this.joinInternal(this.table, table2, JoinType.LEFT_OUTER, allowDuplicateColumnNames, false, col2Names);
    }

    public Table leftOuter(Table table2, boolean allowDuplicateColumnNames, boolean keepAllJoinKeyColumns, String ... col2Names) {
        return this.joinInternal(this.table, table2, JoinType.LEFT_OUTER, allowDuplicateColumnNames, keepAllJoinKeyColumns, col2Names);
    }

    public Table rightOuter(Table ... tables) {
        return this.rightOuter(false, tables);
    }

    public Table rightOuter(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.joinInternal(joined, table2, JoinType.RIGHT_OUTER, allowDuplicateColumnNames, false, this.joinColumnNames);
            this.joinColumnIndexes.clear();
            this.joinColumnIndexes.addAll(this.getJoinIndexes(joined, this.joinColumnNames));
        }
        return joined;
    }

    public Table rightOuter(Table table2, String col2Name) {
        return this.rightOuter(table2, false, col2Name);
    }

    public Table rightOuter(Table table2, String[] col2Names) {
        return this.rightOuter(table2, false, col2Names);
    }

    public Table rightOuter(Table table2, boolean allowDuplicateColumnNames, String ... col2Names) {
        return this.joinInternal(this.table, table2, JoinType.RIGHT_OUTER, allowDuplicateColumnNames, false, col2Names);
    }

    public Table rightOuter(Table table2, boolean allowDuplicateColumnNames, boolean keepAllJoinKeyColumns, String ... col2Names) {
        return this.joinInternal(this.table, table2, JoinType.RIGHT_OUTER, allowDuplicateColumnNames, keepAllJoinKeyColumns, col2Names);
    }

    private Set<Integer> emptyTableFromColumns(Table destination, Table table1, Table table2, JoinType joinType, boolean allowDuplicates, List<Integer> table2JoinColumnIndexes, boolean keepTable2JoinKeyColumns) {
        Column[] cols = (Column[])Streams.concat((Stream[])new Stream[]{table1.columns().stream(), table2.columns().stream()}).map(Column::emptyCopy).toArray(Column[]::new);
        HashSet<Integer> ignoreColumns = new HashSet<Integer>();
        for (int c = 0; c < cols.length; ++c) {
            if (joinType == JoinType.RIGHT_OUTER) {
                if (c >= table1.columnCount() || !this.joinColumnIndexes.contains(c)) continue;
                if (!keepTable2JoinKeyColumns) {
                    cols[c].setName("Placeholder_" + ignoreColumns.size());
                }
                ignoreColumns.add(c);
                continue;
            }
            int table2Index = c - table1.columnCount();
            if (c < table1.columnCount() || !table2JoinColumnIndexes.contains(table2Index)) continue;
            if (!keepTable2JoinKeyColumns) {
                cols[c].setName("Placeholder_" + ignoreColumns.size());
            }
            ignoreColumns.add(c);
        }
        if (allowDuplicates) {
            Set table1ColNames = Arrays.stream(cols).map(Column::name).map(String::toLowerCase).limit(table1.columnCount()).collect(Collectors.toSet());
            String table2Alias = TABLE_ALIAS + this.joinTableId.getAndIncrement();
            for (int c = table1.columnCount(); c < cols.length; ++c) {
                String columnName = cols[c].name();
                if (!table1ColNames.contains(columnName.toLowerCase())) continue;
                cols[c].setName(this.newName(table2Alias, columnName));
            }
        }
        destination.addColumns(cols);
        return ignoreColumns;
    }

    private void crossProduct(Table destination, Table table1, Table table2, Selection table1Rows, Selection table2Rows, Set<Integer> ignoreColumns, boolean keepTable2JoinKeyColumns) {
        for (int c = 0; c < table1.columnCount() + table2.columnCount(); ++c) {
            if (!keepTable2JoinKeyColumns && ignoreColumns.contains(c)) continue;
            int table2Index = c - table1.columnCount();
            IntIterator intIterator = table1Rows.iterator();
            while (intIterator.hasNext()) {
                int r1 = (Integer)intIterator.next();
                IntIterator intIterator2 = table2Rows.iterator();
                while (intIterator2.hasNext()) {
                    int r2 = (Integer)intIterator2.next();
                    if (c < table1.columnCount()) {
                        Column<?> t1Col = table1.column(c);
                        destination.column(c).append(t1Col, r1);
                        continue;
                    }
                    Column<?> t2Col = table2.column(table2Index);
                    destination.column(c).append(t2Col, r2);
                }
            }
        }
    }

    private void withMissingLeftJoin(Table destination, Table table1, Selection table1Rows, Set<Integer> ignoreColumns, boolean keepTable2JoinKeyColumns) {
        for (int c = 0; c < destination.columnCount(); ++c) {
            if (!keepTable2JoinKeyColumns && ignoreColumns.contains(c)) continue;
            if (c < table1.columnCount()) {
                Column<?> t1Col = table1.column(c);
                IntIterator intIterator = table1Rows.iterator();
                while (intIterator.hasNext()) {
                    int index = (Integer)intIterator.next();
                    destination.column(c).append(t1Col, index);
                }
                continue;
            }
            for (int r1 = 0; r1 < table1Rows.size(); ++r1) {
                destination.column(c).appendMissing();
            }
        }
    }

    private void withMissingRight(Table destination, int table1ColCount, Table table2, Selection table2Rows, JoinType joinType, List<Integer> col2Indexes, Set<Integer> ignoreColumns, boolean keepTable2JoinKeyColumns) {
        int index;
        IntIterator intIterator;
        if (joinType == JoinType.FULL_OUTER) {
            for (int i = 0; i < col2Indexes.size(); ++i) {
                Column<?> t2Col = table2.column(col2Indexes.get(i));
                intIterator = table2Rows.iterator();
                while (intIterator.hasNext()) {
                    index = (Integer)intIterator.next();
                    destination.column(this.joinColumnIndexes.get(i)).append(t2Col, index);
                }
            }
        }
        for (int c = 0; c < destination.columnCount(); ++c) {
            if (!keepTable2JoinKeyColumns && (ignoreColumns.contains(c) || this.joinColumnIndexes.contains(c))) continue;
            if (c < table1ColCount) {
                for (int r1 = 0; r1 < table2Rows.size(); ++r1) {
                    destination.column(c).appendMissing();
                }
                continue;
            }
            Column<?> t2Col = table2.column(c - table1ColCount);
            intIterator = table2Rows.iterator();
            while (intIterator.hasNext()) {
                index = (Integer)intIterator.next();
                destination.column(c).append(t2Col, index);
            }
        }
    }

    private static enum JoinType {
        INNER,
        LEFT_OUTER,
        RIGHT_OUTER,
        FULL_OUTER;

    }
}

