/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.fixed;

import com.univocity.parsers.fixed.FieldAlignment;
import com.univocity.parsers.fixed.FixedWidthFields;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.WriteOptions;

public class FixedWidthWriteOptions
extends WriteOptions {
    private final boolean header;
    private final char[] lineSeparator;
    private final String lineSeparatorString;
    private final FixedWidthFields columnSpecs;
    private final boolean defaultPaddingForHeaders;
    private final boolean skipBitsAsWhitespace;
    private final FieldAlignment defaultAlignmentForHeaders;
    private final boolean skipEmptyLines;
    private final boolean expandIncompleteRows;
    private final boolean autoConfigurationEnabled;
    private final int errorContentLength;
    private final boolean writeLineSeparatorAfterRecord;
    private final boolean ignoreTrailingWhitespaces;
    private final boolean ignoreLeadingWhitespaces;
    private final boolean columnReorderingEnabled;
    private final String emptyValue;
    private final String nullValue;
    private final char comment;
    private final char padding;
    private final char lookupWildcard;
    private final char normalizedNewline;

    private FixedWidthWriteOptions(Builder builder) {
        super(builder);
        this.header = builder.header;
        this.lineSeparator = builder.lineSeparator;
        this.lineSeparatorString = builder.lineSeparatorString;
        this.columnSpecs = builder.columnSpecs;
        this.defaultAlignmentForHeaders = builder.defaultAlignmentForHeaders;
        this.defaultPaddingForHeaders = builder.defaultPaddingForHeaders;
        this.skipBitsAsWhitespace = builder.skipBitsAsWhitespace;
        this.skipEmptyLines = builder.skipEmptyLines;
        this.expandIncompleteRows = builder.expandIncompleteRows;
        this.autoConfigurationEnabled = builder.autoConfigurationEnabled;
        this.writeLineSeparatorAfterRecord = builder.writeLineSeparatorAfterRecord;
        this.ignoreTrailingWhitespaces = builder.ignoreTrailingWhitespaces;
        this.ignoreLeadingWhitespaces = builder.ignoreLeadingWhitespaces;
        this.columnReorderingEnabled = builder.columnReorderingEnabled;
        this.errorContentLength = builder.errorContentLength;
        this.emptyValue = builder.emptyValue;
        this.nullValue = builder.nullValue;
        this.comment = builder.comment;
        this.padding = builder.padding;
        this.lookupWildcard = builder.lookupWildcard;
        this.normalizedNewline = builder.normalizedNewline;
    }

    public boolean header() {
        return this.header;
    }

    public char[] lineSeparator() {
        return this.lineSeparator;
    }

    public String lineSeparatorString() {
        return this.lineSeparatorString;
    }

    public FixedWidthFields columnSpecs() {
        return this.columnSpecs;
    }

    public boolean defaultPaddingForHeaders() {
        return this.defaultPaddingForHeaders;
    }

    public boolean skipBitsAsWhitespace() {
        return this.skipBitsAsWhitespace;
    }

    public FieldAlignment defaultAlignmentForHeaders() {
        return this.defaultAlignmentForHeaders;
    }

    public boolean skipEmptyLines() {
        return this.skipEmptyLines;
    }

    public boolean expandIncompleteRows() {
        return this.expandIncompleteRows;
    }

    public boolean autoConfigurationEnabled() {
        return this.autoConfigurationEnabled;
    }

    public int errorContentLength() {
        return this.errorContentLength;
    }

    public boolean writeLineSeparatorAfterRecord() {
        return this.writeLineSeparatorAfterRecord;
    }

    public boolean ignoreTrailingWhitespaces() {
        return this.ignoreTrailingWhitespaces;
    }

    public boolean ignoreLeadingWhitespaces() {
        return this.ignoreLeadingWhitespaces;
    }

    public boolean columnReorderingEnabled() {
        return this.columnReorderingEnabled;
    }

    public String emptyValue() {
        return this.emptyValue;
    }

    public String nullValue() {
        return this.nullValue;
    }

    public char comment() {
        return this.comment;
    }

    public char padding() {
        return this.padding;
    }

    public char lookupWildcard() {
        return this.lookupWildcard;
    }

    public char normalizedNewline() {
        return this.normalizedNewline;
    }

    public boolean autoClose() {
        return this.autoClose;
    }

    public static Builder builder(Destination destination) throws IOException {
        return new Builder(destination);
    }

    public static Builder builder(File file) throws IOException {
        return new Builder(file);
    }

    public static Builder builder(String fileName) throws IOException {
        return FixedWidthWriteOptions.builder(new File(fileName));
    }

    public static Builder builder(OutputStream stream) {
        return new Builder(stream);
    }

    public static Builder builder(Writer writer) {
        return new Builder(writer);
    }

    public static class Builder
    extends WriteOptions.Builder {
        private boolean header = true;
        private char[] lineSeparator;
        private String lineSeparatorString;
        private FixedWidthFields columnSpecs;
        private boolean defaultPaddingForHeaders = true;
        private boolean skipBitsAsWhitespace = true;
        private FieldAlignment defaultAlignmentForHeaders;
        private boolean skipEmptyLines = true;
        private boolean expandIncompleteRows = false;
        private boolean autoConfigurationEnabled = true;
        private int errorContentLength = -1;
        private boolean writeLineSeparatorAfterRecord = true;
        private boolean ignoreTrailingWhitespaces = true;
        private boolean ignoreLeadingWhitespaces = true;
        private boolean columnReorderingEnabled = true;
        private String emptyValue;
        private String nullValue;
        private char comment = (char)35;
        private char padding = (char)95;
        private char lookupWildcard = (char)63;
        private char normalizedNewline = (char)10;

        protected Builder(Destination destination) throws IOException {
            super(destination);
        }

        protected Builder(File file) throws IOException {
            super(file);
        }

        protected Builder(Writer writer) {
            super(writer);
        }

        protected Builder(OutputStream stream) {
            super(stream);
        }

        public Builder lineSeparator(char[] lineSeparator) {
            this.lineSeparator = lineSeparator;
            return this;
        }

        public Builder lineSeparatorString(String lineSeparatorString) {
            this.lineSeparatorString = lineSeparatorString;
            return this;
        }

        public Builder header(boolean header) {
            this.header = header;
            return this;
        }

        public Builder columnSpecs(FixedWidthFields columnSpecs) {
            this.columnSpecs = columnSpecs;
            return this;
        }

        public Builder defaultPaddingForHeaders(boolean defaultPaddingForHeaders) {
            this.defaultPaddingForHeaders = defaultPaddingForHeaders;
            return this;
        }

        public Builder skipBitsAsWhitespace(boolean skipBitsAsWhitespace) {
            this.skipBitsAsWhitespace = skipBitsAsWhitespace;
            return this;
        }

        public Builder defaultAlignmentForHeaders(FieldAlignment defaultAlignmentForHeaders) {
            this.defaultAlignmentForHeaders = defaultAlignmentForHeaders;
            return this;
        }

        public Builder skipEmptyLines(boolean skipEmptyLines) {
            this.skipEmptyLines = skipEmptyLines;
            return this;
        }

        public Builder expandIncompleteRows(boolean expandIncompleteRows) {
            this.expandIncompleteRows = expandIncompleteRows;
            return this;
        }

        public Builder autoConfigurationEnabled(boolean autoConfigurationEnabled) {
            this.autoConfigurationEnabled = autoConfigurationEnabled;
            return this;
        }

        public Builder errorContentLength(int errorContentLength) {
            this.errorContentLength = errorContentLength;
            return this;
        }

        public Builder writeLineSeparatorAfterRecord(boolean writeLineSeparatorAfterRecord) {
            this.writeLineSeparatorAfterRecord = writeLineSeparatorAfterRecord;
            return this;
        }

        public Builder ignoreTrailingWhitespaces(boolean ignoreTrailingWhitespaces) {
            this.ignoreTrailingWhitespaces = ignoreTrailingWhitespaces;
            return this;
        }

        public Builder ignoreLeadingWhitespaces(boolean ignoreLeadingWhitespaces) {
            this.ignoreLeadingWhitespaces = ignoreLeadingWhitespaces;
            return this;
        }

        public Builder columnReorderingEnabled(boolean columnReorderingEnabled) {
            this.columnReorderingEnabled = columnReorderingEnabled;
            return this;
        }

        public Builder emptyValue(String emptyValue) {
            this.emptyValue = emptyValue;
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder comment(char comment) {
            this.comment = comment;
            return this;
        }

        public Builder padding(char padding) {
            this.padding = padding;
            return this;
        }

        public Builder lookupWildcard(char lookupWildcard) {
            this.lookupWildcard = lookupWildcard;
            return this;
        }

        public Builder normalizedNewline(char normalizedNewline) {
            this.normalizedNewline = normalizedNewline;
            return this;
        }

        public FixedWidthWriteOptions build() {
            return new FixedWidthWriteOptions(this);
        }
    }
}

