/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.table.TableSlice;

public class TableSliceGroup
implements Iterable<TableSlice> {
    protected static final String SPLIT_STRING = "~~~";
    private static final Splitter SPLITTER = Splitter.on((String)"~~~");
    private final List<TableSlice> subTables = new ArrayList<TableSlice>();
    private final String[] splitColumnNames;
    private Table sourceTable;

    protected TableSliceGroup(Table original) {
        if (this.containsAnyTextColumns(original)) {
            this.sourceTable = original.copy();
            this.replaceTextColumnsWithStringColumns();
        } else {
            this.sourceTable = original;
        }
        this.splitColumnNames = new String[0];
    }

    private boolean containsAnyTextColumns(Table original) {
        for (Column<?> column : original.columns()) {
            if (!column.type().equals(ColumnType.TEXT)) continue;
            return true;
        }
        return false;
    }

    private void replaceTextColumnsWithStringColumns() {
        for (int i = 0; i < this.sourceTable.columnCount(); ++i) {
            if (!this.sourceTable.column(i).type().equals(ColumnType.TEXT)) continue;
            String originalName = this.sourceTable.column(i).name();
            this.sourceTable.replaceColumn(i, this.sourceTable.textColumn(i).asStringColumn());
            this.sourceTable.column(i).setName(originalName);
        }
    }

    protected TableSliceGroup(Table sourceTable, String[] groupColumnNames) {
        if (this.containsAnyTextColumns(sourceTable)) {
            this.sourceTable = sourceTable.copy();
            this.replaceTextColumnsWithStringColumns();
        } else {
            this.sourceTable = sourceTable;
        }
        this.splitColumnNames = groupColumnNames;
    }

    protected String[] getSplitColumnNames() {
        return this.splitColumnNames;
    }

    protected int getByteSize(List<Column<?>> columns) {
        int byteSize = 0;
        for (Column<?> c : columns) {
            byteSize += c.byteSize();
        }
        return byteSize;
    }

    protected void addSlice(TableSlice slice) {
        this.subTables.add(slice);
    }

    public List<TableSlice> getSlices() {
        return this.subTables;
    }

    public TableSlice get(int i) {
        return this.subTables.get(i);
    }

    public Table getSourceTable() {
        return this.sourceTable;
    }

    public int size() {
        return this.subTables.size();
    }

    private Table splitGroupingColumn(Table groupTable) {
        if (this.splitColumnNames.length > 0) {
            ArrayList newColumns = new ArrayList();
            List<Column<?>> columns = this.sourceTable.columns(this.splitColumnNames);
            for (Column<?> column : columns) {
                Column<?> newColumn = column.emptyCopy();
                newColumns.add(newColumn);
            }
            for (int row = 0; row < groupTable.rowCount(); ++row) {
                List strings = SPLITTER.splitToList((CharSequence)groupTable.stringColumn("Group").get(row));
                for (int col = 0; col < newColumns.size(); ++col) {
                    ((Column)newColumns.get(col)).appendCell((String)strings.get(col));
                }
            }
            for (int col = 0; col < newColumns.size(); ++col) {
                Column c = (Column)newColumns.get(col);
                groupTable.insertColumn(col, c);
            }
            groupTable.removeColumns("Group");
        }
        return groupTable;
    }

    public Table aggregate(String colName1, AggregateFunction<?, ?> ... functions) {
        ArrayListMultimap columnFunctionMap = ArrayListMultimap.create();
        columnFunctionMap.putAll((Object)colName1, (Iterable)Lists.newArrayList((Object[])functions));
        return this.aggregate((ListMultimap<String, AggregateFunction<?, ?>>)columnFunctionMap);
    }

    public Table aggregate(ListMultimap<String, AggregateFunction<?, ?>> functions) {
        Table groupTable = TableSliceGroup.summaryTableName(this.sourceTable);
        StringColumn groupColumn = StringColumn.create("Group");
        groupTable.addColumns(new Column[]{groupColumn});
        boolean firstFunction = true;
        for (Map.Entry entry : functions.asMap().entrySet()) {
            String columnName = (String)entry.getKey();
            for (AggregateFunction function : (Collection)entry.getValue()) {
                String colName = TableSliceGroup.aggregateColumnName(columnName, function.functionName());
                ColumnType type = function.returnType();
                Column<?> resultColumn = type.create(colName);
                for (TableSlice subTable : this.getSlices()) {
                    Object result = function.summarize(subTable.column(columnName));
                    if (firstFunction) {
                        groupColumn.append(subTable.name());
                    }
                    if (result instanceof Number) {
                        Number number = (Number)result;
                        resultColumn.append(number.doubleValue());
                        continue;
                    }
                    resultColumn.append(result);
                }
                groupTable.addColumns(new Column[]{resultColumn});
                firstFunction = false;
            }
        }
        return this.splitGroupingColumn(groupTable);
    }

    public static Table summaryTableName(Table source) {
        return Table.create(source.name() + " summary");
    }

    @Override
    public Iterator<TableSlice> iterator() {
        return this.subTables.iterator();
    }

    public static String aggregateColumnName(String columnName, String functionName) {
        return String.format("%s [%s]", functionName, columnName);
    }

    public List<Table> asTableList() {
        ArrayList<Table> tableList = new ArrayList<Table>();
        for (TableSlice view : this) {
            tableList.add(view.asTable());
        }
        return tableList;
    }

    protected void setSourceTable(Table sourceTable) {
        this.sourceTable = sourceTable;
    }
}

