/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.google.common.io.CharStreams;
import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.math3.util.Pair;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.FileReader;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.csv.CsvReadOptions;

@Immutable
public class CsvReader
extends FileReader
implements DataReader<CsvReadOptions> {
    private static final CsvReader INSTANCE = new CsvReader();

    public static void register(ReaderRegistry registry) {
        registry.registerExtension("csv", INSTANCE);
        registry.registerMimeType("text/csv", INSTANCE);
        registry.registerOptions(CsvReadOptions.class, INSTANCE);
    }

    private Pair<Reader, ColumnType[]> getReaderAndColumnTypes(Source source, CsvReadOptions options) throws IOException {
        ColumnType[] types = options.columnTypes();
        byte[] bytesCache = null;
        if (types == null) {
            Reader reader = source.createReader(bytesCache);
            if (source.file() == null) {
                String s = CharStreams.toString((Readable)reader);
                bytesCache = source.getCharset() != null ? s.getBytes(source.getCharset()) : s.getBytes();
                reader = source.createReader(bytesCache);
            }
            types = this.detectColumnTypes(reader, options);
        }
        return Pair.create((Object)source.createReader(bytesCache), (Object)types);
    }

    @Override
    public Table read(CsvReadOptions options) throws IOException {
        return this.read(options, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table read(CsvReadOptions options, boolean headerOnly) throws IOException {
        Pair<Reader, ColumnType[]> pair = this.getReaderAndColumnTypes(options.source(), options);
        Reader reader = (Reader)pair.getKey();
        ColumnType[] types = (ColumnType[])pair.getValue();
        CsvParser parser = this.csvParser(options);
        try {
            Table table = this.parseRows(options, headerOnly, reader, types, (AbstractParser<?>)parser, options.sampleSize());
            return table;
        }
        finally {
            if (options.source().reader() == null) {
                parser.stopParsing();
                reader.close();
            }
        }
    }

    public String printColumnTypes(CsvReadOptions options) throws IOException {
        Table structure = this.read(options, true).structure();
        return this.getTypeString(structure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ColumnType[] detectColumnTypes(Reader reader, CsvReadOptions options) {
        boolean header = options.header();
        int linesToSkip = header ? 1 : 0;
        CsvParser parser = this.csvParser(options);
        try {
            ColumnType[] columnTypeArray = this.getColumnTypes(reader, options, linesToSkip, (AbstractParser<?>)parser);
            return columnTypeArray;
        }
        finally {
            parser.stopParsing();
        }
    }

    private CsvParser csvParser(CsvReadOptions options) {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setLineSeparatorDetectionEnabled(options.lineSeparatorDetectionEnabled());
        settings.setFormat((Format)this.csvFormat(options));
        settings.setMaxCharsPerColumn(options.maxCharsPerColumn());
        if (options.maxNumberOfColumns() != null) {
            settings.setMaxColumns(options.maxNumberOfColumns().intValue());
        }
        return new CsvParser(settings);
    }

    private CsvFormat csvFormat(CsvReadOptions options) {
        CsvFormat format = new CsvFormat();
        if (options.quoteChar() != null) {
            format.setQuote(options.quoteChar().charValue());
        }
        if (options.escapeChar() != null) {
            format.setQuoteEscape(options.escapeChar().charValue());
        }
        if (options.separator() != null) {
            format.setDelimiter(options.separator().charValue());
        }
        if (options.lineEnding() != null) {
            format.setLineSeparator(options.lineEnding());
        }
        if (options.commentPrefix() != null) {
            format.setComment(options.commentPrefix().charValue());
        }
        return format;
    }

    @Override
    public Table read(Source source) throws IOException {
        return this.read(CsvReadOptions.builder(source).build());
    }

    static {
        CsvReader.register(Table.defaultReaderRegistry);
    }
}

