/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.Selection;

public abstract class AbstractColumn<C extends Column<T>, T>
implements Column<T> {
    public static final int DEFAULT_ARRAY_SIZE = 128;
    private String name;
    private final ColumnType type;

    public AbstractColumn(ColumnType type, String name) {
        this.type = type;
        this.setName(name);
    }

    @Override
    public String name() {
        return this.name;
    }

    public C setName(String name) {
        this.name = name.trim();
        return (C)this;
    }

    @Override
    public ColumnType type() {
        return this.type;
    }

    @Override
    public abstract Column<T> emptyCopy();

    public C filter(Predicate<? super T> test) {
        return (C)Column.super.filter(test);
    }

    public C sorted(Comparator<? super T> comp) {
        return (C)Column.super.sorted(comp);
    }

    public C map(Function<? super T, ? extends T> fun) {
        return (C)Column.super.map(fun);
    }

    public C min(Column<T> other) {
        return (C)Column.super.min(other);
    }

    public C max(Column<T> other) {
        return (C)Column.super.max(other);
    }

    public C set(Selection condition, Column<T> other) {
        return (C)Column.super.set(condition, other);
    }

    public C set(Selection rowSelection, T newValue) {
        return (C)Column.super.set(rowSelection, newValue);
    }

    public C first(int numRows) {
        return (C)Column.super.first(numRows);
    }

    public C last(int numRows) {
        return (C)Column.super.last(numRows);
    }

    public C sampleN(int n) {
        return (C)Column.super.sampleN(n);
    }

    public C sampleX(double proportion) {
        return (C)Column.super.sampleX(proportion);
    }

    public C subset(int[] rows) {
        return (C)Column.super.subset(rows);
    }

    public C inRange(int start, int end) {
        return (C)Column.super.inRange(start, end);
    }

    public String toString() {
        return this.type().getPrinterFriendlyName() + " column: " + this.name();
    }

    @Override
    public StringColumn asStringColumn() {
        StringColumn sc = StringColumn.create(this.name() + " strings");
        for (int i = 0; i < this.size(); ++i) {
            sc.append(this.getUnformattedString(i));
        }
        return sc;
    }

    @Override
    public int indexOf(Object o) {
        return IntStream.range(0, this.size()).filter((int i) -> this.get(i).equals(o)).findFirst().orElse(-1);
    }
}

