/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes;

import java.time.LocalDate;
import java.time.LocalDateTime;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.columns.datetimes.DateTimePredicates;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.columns.temporal.TemporalFilters;
import tech.tablesaw.columns.temporal.TemporalPredicates;
import tech.tablesaw.filtering.DateTimeFilterSpec;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface DateTimeFilters
extends TemporalFilters<LocalDateTime>,
DateTimeFilterSpec<Selection> {
    @Override
    default public Selection isAfter(LocalDateTime value) {
        return this.eval(TemporalPredicates.isGreaterThan, PackedLocalDateTime.pack(value));
    }

    @Override
    default public Selection isAfter(LocalDate value) {
        return this.isOnOrAfter(value.plusDays(1L));
    }

    @Override
    default public Selection isOnOrAfter(LocalDate value) {
        return this.isOnOrAfter(value.atStartOfDay());
    }

    @Override
    default public Selection isOnOrAfter(LocalDateTime value) {
        return this.eval(TemporalPredicates.isGreaterThanOrEqualTo, PackedLocalDateTime.pack(value));
    }

    @Override
    default public Selection isBefore(LocalDateTime value) {
        return this.eval(TemporalPredicates.isLessThan, PackedLocalDateTime.pack(value));
    }

    @Override
    default public Selection isBefore(LocalDate value) {
        return this.isBefore(value.atStartOfDay());
    }

    @Override
    default public Selection isOnOrBefore(LocalDate value) {
        return this.isOnOrBefore(value.atStartOfDay());
    }

    @Override
    default public Selection isOnOrBefore(LocalDateTime value) {
        return this.eval(TemporalPredicates.isLessThanOrEqualTo, PackedLocalDateTime.pack(value));
    }

    @Override
    default public Selection isAfter(DateTimeColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getLongInternal(i) <= column.getLongInternal(i)) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    default public Selection isBefore(DateTimeColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getLongInternal(i) >= column.getLongInternal(i)) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    default public Selection isEqualTo(LocalDateTime value) {
        long packed = PackedLocalDateTime.pack(value);
        return this.eval(TemporalPredicates.isEqualTo, packed);
    }

    @Override
    default public Selection isNotEqualTo(LocalDateTime value) {
        long packed = PackedLocalDateTime.pack(value);
        return this.eval(TemporalPredicates.isNotEqualTo, packed);
    }

    @Override
    default public Selection isEqualTo(DateTimeColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (this.getLongInternal(i) != column.getLongInternal(i)) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    default public Selection isNotEqualTo(DateTimeColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isEqualTo(column));
    }

    @Override
    default public Selection isOnOrAfter(DateTimeColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isBefore(column));
    }

    @Override
    default public Selection isOnOrBefore(DateTimeColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isAfter(column));
    }

    @Override
    default public Selection isMonday() {
        return this.eval(PackedLocalDateTime::isMonday);
    }

    @Override
    default public Selection isTuesday() {
        return this.eval(PackedLocalDateTime::isTuesday);
    }

    @Override
    default public Selection isWednesday() {
        return this.eval(PackedLocalDateTime::isWednesday);
    }

    @Override
    default public Selection isThursday() {
        return this.eval(PackedLocalDateTime::isThursday);
    }

    @Override
    default public Selection isFriday() {
        return this.eval(PackedLocalDateTime::isFriday);
    }

    @Override
    default public Selection isSaturday() {
        return this.eval(PackedLocalDateTime::isSaturday);
    }

    @Override
    default public Selection isSunday() {
        return this.eval(PackedLocalDateTime::isSunday);
    }

    @Override
    default public Selection isInJanuary() {
        return this.eval(PackedLocalDateTime::isInJanuary);
    }

    @Override
    default public Selection isInFebruary() {
        return this.eval(PackedLocalDateTime::isInFebruary);
    }

    @Override
    default public Selection isInMarch() {
        return this.eval(PackedLocalDateTime::isInMarch);
    }

    @Override
    default public Selection isInApril() {
        return this.eval(PackedLocalDateTime::isInApril);
    }

    @Override
    default public Selection isInMay() {
        return this.eval(PackedLocalDateTime::isInMay);
    }

    @Override
    default public Selection isInJune() {
        return this.eval(PackedLocalDateTime::isInJune);
    }

    @Override
    default public Selection isInJuly() {
        return this.eval(PackedLocalDateTime::isInJuly);
    }

    @Override
    default public Selection isInAugust() {
        return this.eval(PackedLocalDateTime::isInAugust);
    }

    @Override
    default public Selection isInSeptember() {
        return this.eval(PackedLocalDateTime::isInSeptember);
    }

    @Override
    default public Selection isInOctober() {
        return this.eval(PackedLocalDateTime::isInOctober);
    }

    @Override
    default public Selection isInNovember() {
        return this.eval(PackedLocalDateTime::isInNovember);
    }

    @Override
    default public Selection isInDecember() {
        return this.eval(PackedLocalDateTime::isInDecember);
    }

    @Override
    default public Selection isFirstDayOfMonth() {
        return this.eval(PackedLocalDateTime::isFirstDayOfMonth);
    }

    @Override
    default public Selection isLastDayOfMonth() {
        return this.eval(PackedLocalDateTime::isLastDayOfMonth);
    }

    @Override
    default public Selection isInQ1() {
        return this.eval(PackedLocalDateTime::isInQ1);
    }

    @Override
    default public Selection isInQ2() {
        return this.eval(PackedLocalDateTime::isInQ2);
    }

    @Override
    default public Selection isInQ3() {
        return this.eval(PackedLocalDateTime::isInQ3);
    }

    @Override
    default public Selection isInQ4() {
        return this.eval(PackedLocalDateTime::isInQ4);
    }

    @Override
    default public Selection isNoon() {
        return this.eval(PackedLocalDateTime::isNoon);
    }

    @Override
    default public Selection isMidnight() {
        return this.eval(PackedLocalDateTime::isMidnight);
    }

    @Override
    default public Selection isBeforeNoon() {
        return this.eval(PackedLocalDateTime::AM);
    }

    @Override
    default public Selection isAfterNoon() {
        return this.eval(PackedLocalDateTime::PM);
    }

    @Override
    default public Selection isBetweenExcluding(LocalDateTime lowValue, LocalDateTime highValue) {
        return this.isBetweenExcluding(PackedLocalDateTime.pack(lowValue), PackedLocalDateTime.pack(highValue));
    }

    @Override
    default public Selection isBetweenIncluding(LocalDateTime lowValue, LocalDateTime highValue) {
        return this.isBetweenIncluding(PackedLocalDateTime.pack(lowValue), PackedLocalDateTime.pack(highValue));
    }

    @Override
    default public Selection isInYear(int year) {
        return this.eval(DateTimePredicates.isInYear, year);
    }

    @Override
    default public Selection isMissing() {
        return this.eval(TemporalPredicates.isMissing);
    }

    @Override
    default public Selection isNotMissing() {
        return this.eval(TemporalPredicates.isNotMissing);
    }
}

