/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.table.Rows;
import tech.tablesaw.util.Selection;

public class Projection {
    private final Table table;
    private final Column[] columns;

    public Projection(Table table, String[] columnNames) {
        this.table = table;
        this.columns = new Column[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            String name = columnNames[i];
            this.columns[i] = table.column(name);
        }
    }

    public Table where(Filter filter) {
        Table projectedTable = Table.create(this.table.name(), this.columns);
        Table newTable = projectedTable.emptyCopy();
        Selection map = filter.apply(this.table);
        Rows.copyRowsToTable(map, projectedTable, newTable);
        return newTable;
    }
}

