/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.mapping;

import it.unimi.dsi.fastutil.longs.LongIterator;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.columns.LongColumnUtils;

public interface LongMapUtils
extends LongColumnUtils {
    default public LongColumn plus(LongColumn ... columns) {
        String nString = this.names(columns);
        String name = String.format("sum(%s)", nString);
        LongColumn newColumn = new LongColumn(name);
        for (int r = 0; r < columns[0].size(); ++r) {
            long result = 0L;
            for (LongColumn column : columns) {
                result += column.get(r);
            }
            newColumn.append(result);
        }
        return newColumn;
    }

    default public String names(LongColumn[] columns) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (LongColumn column : columns) {
            builder.append(column.name());
            if (count < columns.length - 1) {
                builder.append(", ");
            }
            ++count;
        }
        return builder.toString();
    }

    default public FloatColumn asRatio() {
        FloatColumn pctColumn = new FloatColumn(this.name() + " percents");
        float total = this.sum();
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            long next = (Long)longIterator.next();
            if (total != 0.0f) {
                pctColumn.append((float)next / total);
                continue;
            }
            pctColumn.append(FloatColumn.MISSING_VALUE);
        }
        return pctColumn;
    }

    default public FloatColumn asPercent() {
        FloatColumn pctColumn = new FloatColumn(this.name() + " percents");
        float total = this.sum();
        LongIterator longIterator = this.iterator();
        while (longIterator.hasNext()) {
            long next = (Long)longIterator.next();
            if (total != 0.0f) {
                pctColumn.append((float)next / total * 100.0f);
                continue;
            }
            pctColumn.append(FloatColumn.MISSING_VALUE);
        }
        return pctColumn;
    }

    public long sum();

    public long get(int var1);

    default public LongColumn difference(LongColumn column2) {
        LongColumn result = new LongColumn(this.name() + " - " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) - column2.get(r));
        }
        return result;
    }
}

