/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.mapping;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.DateColumnUtils;
import tech.tablesaw.columns.packeddata.PackedLocalDate;
import tech.tablesaw.columns.packeddata.PackedLocalDateTime;
import tech.tablesaw.columns.packeddata.PackedLocalTime;

public interface DateMapUtils
extends DateColumnUtils {
    public static String dateColumnName(Column column1, int value, TemporalUnit unit) {
        return column1.name() + ": " + value + " " + unit.toString() + "(s)";
    }

    default public FloatColumn differenceInDays(DateColumn column2) {
        DateColumn column1 = (DateColumn)this;
        return this.difference(column1, column2, ChronoUnit.DAYS);
    }

    default public FloatColumn differenceInWeeks(DateColumn column2) {
        DateColumn column1 = (DateColumn)this;
        return this.difference(column1, column2, ChronoUnit.WEEKS);
    }

    default public FloatColumn differenceInMonths(DateColumn column2) {
        DateColumn column1 = (DateColumn)this;
        return this.difference(column1, column2, ChronoUnit.MONTHS);
    }

    default public FloatColumn differenceInYears(DateColumn column2) {
        DateColumn column1 = (DateColumn)this;
        return this.difference(column1, column2, ChronoUnit.YEARS);
    }

    default public FloatColumn difference(DateColumn column1, DateColumn column2, ChronoUnit unit) {
        FloatColumn newColumn = new FloatColumn(column1.name() + " - " + column2.name());
        for (int r = 0; r < column1.size(); ++r) {
            int c1 = column1.getIntInternal(r);
            int c2 = column2.getIntInternal(r);
            if ((float)c1 == FloatColumn.MISSING_VALUE || (float)c2 == FloatColumn.MISSING_VALUE) {
                newColumn.append(FloatColumn.MISSING_VALUE);
                continue;
            }
            LocalDate value1 = PackedLocalDate.asLocalDate(c1);
            LocalDate value2 = PackedLocalDate.asLocalDate(c2);
            newColumn.append(unit.between(value1, value2));
        }
        return newColumn;
    }

    default public DateColumn plusDays(int days) {
        return this.plus(days, ChronoUnit.DAYS);
    }

    default public DateColumn plusWeeks(int weeks) {
        return this.plus(weeks, ChronoUnit.WEEKS);
    }

    default public DateColumn plusYears(int years) {
        return this.plus(years, ChronoUnit.YEARS);
    }

    default public DateColumn plusMonths(int months) {
        return this.plus(months, ChronoUnit.MONTHS);
    }

    default public DateColumn minusDays(int days) {
        return this.plusDays(-days);
    }

    default public DateColumn minusWeeks(int weeks) {
        return this.plusWeeks(-weeks);
    }

    default public DateColumn minusYears(int years) {
        return this.plusYears(-years);
    }

    default public DateColumn minusMonths(int months) {
        return this.plusMonths(-months);
    }

    default public DateColumn plus(int value, TemporalUnit unit) {
        DateColumn newColumn = new DateColumn(DateMapUtils.dateColumnName(this, value, unit));
        DateColumn column1 = (DateColumn)this;
        for (int r = 0; r < column1.size(); ++r) {
            LocalDate c1 = column1.get(r);
            if (c1 == null) {
                newColumn.append(c1);
                continue;
            }
            newColumn.append(c1.plus(value, unit));
        }
        return newColumn;
    }

    default public DateColumn minus(int value, TemporalUnit unit) {
        DateColumn column1 = (DateColumn)this;
        DateColumn newColumn = new DateColumn(DateMapUtils.dateColumnName(column1, value, unit));
        for (int r = 0; r < column1.size(); ++r) {
            LocalDate c1 = column1.get(r);
            if (c1 == null) {
                newColumn.append(c1);
                continue;
            }
            newColumn.append(c1.minus(value, unit));
        }
        return newColumn;
    }

    default public DateTimeColumn atStartOfDay() {
        DateTimeColumn newColumn = new DateTimeColumn(this.name() + "  start");
        for (int r = 0; r < this.size(); ++r) {
            LocalDate c1 = this.get(r);
            if (c1 == null) {
                newColumn.add(null);
                continue;
            }
            newColumn.add(c1.atStartOfDay());
        }
        return newColumn;
    }

    default public DateTimeColumn atTime(LocalTime time) {
        Preconditions.checkNotNull((Object)time);
        DateTimeColumn newColumn = new DateTimeColumn(this.name() + " " + time.toString());
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 == DateColumn.MISSING_VALUE) {
                newColumn.appendInternal(Long.MIN_VALUE);
                continue;
            }
            LocalDate value1 = PackedLocalDate.asLocalDate(c1);
            newColumn.appendInternal(PackedLocalDateTime.pack(value1, time));
        }
        return newColumn;
    }

    default public DateTimeColumn atTime(TimeColumn timeColumn) {
        DateTimeColumn newColumn = new DateTimeColumn(this.name() + " " + timeColumn.name());
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            int c2 = timeColumn.getIntInternal(r);
            if (c1 == DateColumn.MISSING_VALUE || c2 == TimeColumn.MISSING_VALUE) {
                newColumn.appendInternal(Long.MIN_VALUE);
                continue;
            }
            LocalDate value1 = PackedLocalDate.asLocalDate(c1);
            newColumn.appendInternal(PackedLocalDateTime.pack(value1, PackedLocalTime.asLocalTime(c2)));
        }
        return newColumn;
    }

    public int getIntInternal(int var1);

    public LocalDate get(int var1);
}

