/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import tech.tablesaw.api.ColumnType;

public final class CsvReadOptions {
    private final File file;
    private final Reader reader;
    private final String tableName;
    private final ColumnType[] columnTypes;
    private final boolean header;
    private final char separator;
    private final boolean sample;

    public static CsvReadOptionsBuilder builder(InputStream stream, String tableName) {
        return CsvReadOptions.builder(new InputStreamReader(stream), tableName);
    }

    public static CsvReadOptionsBuilder builder(Reader reader, String tableName) {
        return CsvReadOptions.hiddenBuilder().reader(reader).tableName(tableName);
    }

    public static CsvReadOptionsBuilder builder(File file) throws FileNotFoundException {
        return CsvReadOptions.hiddenBuilder().file(file).tableName(file.getName());
    }

    public static CsvReadOptionsBuilder builder(String file) throws FileNotFoundException {
        return CsvReadOptions.builder(new File(file));
    }

    private static boolean $default$header() {
        return true;
    }

    private static char $default$separator() {
        return ',';
    }

    private static boolean $default$sample() {
        return true;
    }

    @ConstructorProperties(value={"file", "reader", "tableName", "columnTypes", "header", "separator", "sample"})
    CsvReadOptions(File file, Reader reader, String tableName, ColumnType[] columnTypes, boolean header, char separator, boolean sample) {
        this.file = file;
        this.reader = reader;
        this.tableName = tableName;
        this.columnTypes = columnTypes;
        this.header = header;
        this.separator = separator;
        this.sample = sample;
    }

    public static CsvReadOptionsBuilder hiddenBuilder() {
        return new CsvReadOptionsBuilder();
    }

    public File file() {
        return this.file;
    }

    public Reader reader() {
        return this.reader;
    }

    public String tableName() {
        return this.tableName;
    }

    public ColumnType[] columnTypes() {
        return this.columnTypes;
    }

    public boolean header() {
        return this.header;
    }

    public char separator() {
        return this.separator;
    }

    public boolean sample() {
        return this.sample;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsvReadOptions)) {
            return false;
        }
        CsvReadOptions other = (CsvReadOptions)o;
        File this$file = this.file();
        File other$file = other.file();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        Reader this$reader = this.reader();
        Reader other$reader = other.reader();
        if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
            return false;
        }
        String this$tableName = this.tableName();
        String other$tableName = other.tableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.columnTypes(), (Object[])other.columnTypes())) {
            return false;
        }
        if (this.header() != other.header()) {
            return false;
        }
        if (this.separator() != other.separator()) {
            return false;
        }
        return this.sample() == other.sample();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        File $file = this.file();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        Reader $reader = this.reader();
        result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
        String $tableName = this.tableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.columnTypes());
        result = result * 59 + (this.header() ? 79 : 97);
        result = result * 59 + this.separator();
        result = result * 59 + (this.sample() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "CsvReadOptions(file=" + this.file() + ", reader=" + this.reader() + ", tableName=" + this.tableName() + ", columnTypes=" + Arrays.deepToString((Object[])this.columnTypes()) + ", header=" + this.header() + ", separator=" + this.separator() + ", sample=" + this.sample() + ")";
    }

    public static class CsvReadOptionsBuilder {
        private File file;
        private Reader reader;
        private String tableName;
        private ColumnType[] columnTypes;
        private boolean header$set;
        private boolean header;
        private boolean separator$set;
        private char separator;
        private boolean sample$set;
        private boolean sample;

        CsvReadOptionsBuilder() {
        }

        public CsvReadOptionsBuilder file(File file) {
            this.file = file;
            return this;
        }

        public CsvReadOptionsBuilder reader(Reader reader) {
            this.reader = reader;
            return this;
        }

        public CsvReadOptionsBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public CsvReadOptionsBuilder columnTypes(ColumnType[] columnTypes) {
            this.columnTypes = columnTypes;
            return this;
        }

        public CsvReadOptionsBuilder header(boolean header) {
            this.header = header;
            this.header$set = true;
            return this;
        }

        public CsvReadOptionsBuilder separator(char separator) {
            this.separator = separator;
            this.separator$set = true;
            return this;
        }

        public CsvReadOptionsBuilder sample(boolean sample) {
            this.sample = sample;
            this.sample$set = true;
            return this;
        }

        public CsvReadOptions build() {
            return new CsvReadOptions(this.file, this.reader, this.tableName, this.columnTypes, this.header$set ? this.header : CsvReadOptions.$default$header(), this.separator$set ? this.separator : CsvReadOptions.$default$separator(), this.sample$set ? this.sample : CsvReadOptions.$default$sample());
        }

        public String toString() {
            return "CsvReadOptions.CsvReadOptionsBuilder(file=" + this.file + ", reader=" + this.reader + ", tableName=" + this.tableName + ", columnTypes=" + Arrays.deepToString((Object[])this.columnTypes) + ", header=" + this.header + ", separator=" + this.separator + ", sample=" + this.sample + ")";
        }
    }
}

