/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refaster.runner;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import com.google.errorprone.CodeTransformer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;

public final class CodeTransformers {
    private static final String REFASTER_RULE_SUFFIX = ".refaster";
    private static final Supplier<ImmutableListMultimap<String, CodeTransformer>> ALL_CODE_TRANSFORMERS = Suppliers.memoize(CodeTransformers::loadAllCodeTransformers);

    private CodeTransformers() {
    }

    public static ImmutableListMultimap<String, CodeTransformer> getAllCodeTransformers() {
        return ALL_CODE_TRANSFORMERS.get();
    }

    private static ImmutableListMultimap<String, CodeTransformer> loadAllCodeTransformers() {
        ImmutableListMultimap.Builder transformers = ImmutableListMultimap.builder();
        for (ClassPath.ResourceInfo resource : CodeTransformers.getClassPathResources()) {
            CodeTransformers.getRefasterRuleName(resource).ifPresent(ruleName -> CodeTransformers.loadCodeTransformer(resource).ifPresent(transformer -> transformers.put(ruleName, transformer)));
        }
        return transformers.build();
    }

    private static ImmutableSet<ClassPath.ResourceInfo> getClassPathResources() {
        try {
            return ClassPath.from((ClassLoader)CodeTransformers.class.getClassLoader()).getResources();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to scan classpath for resources", e);
        }
    }

    private static Optional<String> getRefasterRuleName(ClassPath.ResourceInfo resource) {
        String resourceName = resource.getResourceName();
        if (!resourceName.endsWith(REFASTER_RULE_SUFFIX)) {
            return Optional.empty();
        }
        int lastPathSeparator = resourceName.lastIndexOf(47);
        int beginIndex = lastPathSeparator < 0 ? 0 : lastPathSeparator + 1;
        int endIndex = resourceName.length() - REFASTER_RULE_SUFFIX.length();
        return Optional.of(resourceName.substring(beginIndex, endIndex));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Optional<CodeTransformer> loadCodeTransformer(ClassPath.ResourceInfo resource) {
        try (InputStream in = resource.url().openStream();){
            Optional<CodeTransformer> optional;
            try (ObjectInputStream ois = new ObjectInputStream(in);){
                CodeTransformer codeTransformer = (CodeTransformer)ois.readObject();
                optional = Optional.of(codeTransformer);
            }
            return optional;
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Can't load `CodeTransformer` from " + String.valueOf(resource), e);
        }
    }
}

