/*
 * Decompiled with CFR 0.152.
 */
package tech.mhuang.ext.jwt.admin;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.time.LocalDateTime;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import tech.mhuang.core.date.DateTimeUtil;
import tech.mhuang.ext.jwt.admin.bean.Jwt;
import tech.mhuang.ext.jwt.admin.external.IJwtProducer;

public class JwtHelper
implements IJwtProducer {
    private String name;
    private Jwt.JwtBean jwt;
    private static final String TYPE = "type";
    private static final String VALUE = "JWT";

    @Override
    public void name(String name) {
        this.name = name;
    }

    @Override
    public void add(Jwt.JwtBean jwt) {
        this.jwt = jwt;
    }

    @Override
    public Map<String, Object> parse(String jsonWebToken) {
        return (Map)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)this.jwt.getSecret())).parseClaimsJws(jsonWebToken).getBody();
    }

    @Override
    public String refresh(Map<String, Object> claims) {
        return this.create(claims);
    }

    @Override
    public String create(Map<String, Object> claims) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS512;
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)this.jwt.getSecret());
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setHeaderParam(TYPE, (Object)VALUE).setClaims(claims).setIssuer(this.jwt.getName()).setAudience(this.jwt.getClientId()).signWith(signatureAlgorithm, (Key)signingKey);
        LocalDateTime currentTime = LocalDateTime.now();
        LocalDateTime dateTime = currentTime.plusMinutes(this.jwt.getExpireMinute());
        builder.setExpiration(DateTimeUtil.localDateTimeToDate((LocalDateTime)dateTime)).setNotBefore(DateTimeUtil.localDateTimeToDate((LocalDateTime)currentTime));
        return builder.compact();
    }
}

