/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.web.util;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public interface PageUtil {
    public static <T> Page<T> createPageFromList(List<T> list, Pageable pageable) {
        if (list == null) {
            throw new IllegalArgumentException("To create a Page, the list mustn't be null!");
        }
        int startOfPage = pageable.getPageNumber() * pageable.getPageSize();
        if (startOfPage > list.size()) {
            return new PageImpl(new ArrayList(), pageable, 0L);
        }
        int endOfPage = Math.min(startOfPage + pageable.getPageSize(), list.size());
        return new PageImpl(list.subList(startOfPage, endOfPage), pageable, (long)list.size());
    }
}

