/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.config.apidoc;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.oas.configuration.OpenApiDocumentationConfiguration;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Server;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationConfiguration;
import tech.jhipster.config.JHipsterProperties;
import tech.jhipster.config.apidoc.customizer.JHipsterSpringfoxCustomizer;
import tech.jhipster.config.apidoc.customizer.SpringfoxCustomizer;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={ApiInfo.class, BeanValidatorPluginsConfiguration.class, Docket.class})
@Profile(value={"api-docs"})
@AutoConfigureAfter(value={JHipsterProperties.class})
@Import(value={OpenApiDocumentationConfiguration.class, Swagger2DocumentationConfiguration.class, BeanValidatorPluginsConfiguration.class})
public class SpringfoxAutoConfiguration {
    static final String STARTING_MESSAGE = "Starting OpenAPI docs";
    static final String STARTED_MESSAGE = "Started OpenAPI docs in {} ms";
    static final String MANAGEMENT_TITLE_SUFFIX = "Management API";
    static final String MANAGEMENT_GROUP_NAME = "management";
    static final String MANAGEMENT_DESCRIPTION = "Management endpoints documentation";
    private final Logger log = LoggerFactory.getLogger(SpringfoxAutoConfiguration.class);
    private final JHipsterProperties.ApiDocs properties;

    public SpringfoxAutoConfiguration(JHipsterProperties jHipsterProperties) {
        this.properties = jHipsterProperties.getApiDocs();
    }

    @Bean
    @ConditionalOnMissingBean(name={"openAPISpringfoxApiDocket"})
    public Docket openAPISpringfoxApiDocket(List<SpringfoxCustomizer> springfoxCustomizers, ObjectProvider<AlternateTypeRule[]> alternateTypeRules) {
        this.log.debug(STARTING_MESSAGE);
        StopWatch watch = new StopWatch();
        watch.start();
        Docket docket = this.createDocket();
        springfoxCustomizers.forEach(customizer -> customizer.customize(docket));
        Optional.ofNullable((AlternateTypeRule[])alternateTypeRules.getIfAvailable()).ifPresent(arg_0 -> ((Docket)docket).alternateTypeRules(arg_0));
        watch.stop();
        this.log.debug(STARTED_MESSAGE, (Object)watch.getTotalTimeMillis());
        return docket;
    }

    @Bean
    public JHipsterSpringfoxCustomizer jHipsterSpringfoxCustomizer() {
        return new JHipsterSpringfoxCustomizer(this.properties);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties"})
    @ConditionalOnMissingBean(name={"openAPISpringfoxManagementDocket"})
    public Docket openAPISpringfoxManagementDocket(@Value(value="${spring.application.name:application}") String appName) {
        ApiInfo apiInfo = new ApiInfo(StringUtils.capitalize((String)appName) + " " + MANAGEMENT_TITLE_SUFFIX, MANAGEMENT_DESCRIPTION, this.properties.getVersion(), "", ApiInfo.DEFAULT_CONTACT, "", "", new ArrayList());
        Docket docket = this.createDocket();
        for (JHipsterProperties.ApiDocs.Server server : this.properties.getServers()) {
            docket.servers(new Server(server.getName(), server.getUrl(), server.getDescription(), Collections.emptyList(), Collections.emptyList()), new Server[0]);
        }
        return docket.apiInfo(apiInfo).useDefaultResponseMessages(this.properties.isUseDefaultResponseMessages()).groupName(MANAGEMENT_GROUP_NAME).host(this.properties.getHost()).protocols(new HashSet<String>(Arrays.asList(this.properties.getProtocols()))).forCodeGeneration(true).directModelSubstitute(ByteBuffer.class, String.class).genericModelSubstitutes(new Class[]{ResponseEntity.class}).ignoredParameterTypes(new Class[]{Pageable.class}).select().paths(PathSelectors.regex((String)this.properties.getManagementIncludePattern())).build();
    }

    protected Docket createDocket() {
        return new Docket(DocumentationType.OAS_30);
    }
}

