/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.extent.processor;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import tech.grasshopper.pdf.extent.processor.Processor;

public class StackTraceProcessor
extends Processor {
    private List<Log> logs;

    @Override
    public String process() {
        List failAndSkipLogs = this.logs.stream().filter(l -> l.getStatus() == Status.FAIL || l.getStatus() == Status.SKIP).collect(Collectors.toList());
        String stack = "";
        for (Log log : failAndSkipLogs) {
            if (log.getException() != null) {
                stack = log.getException().getStackTrace();
                continue;
            }
            stack = this.stripMarkup(log.getDetails());
        }
        return stack;
    }

    private String stripMarkup(String markup) {
        if (markup == null || markup.isEmpty()) {
            return "";
        }
        int start = markup.indexOf(">", markup.indexOf("<textarea"));
        int end = markup.indexOf("</textarea");
        if (start == -1 || end == -1) {
            return markup;
        }
        return markup.substring(start + 1, end);
    }

    private static List<Log> $default$logs() {
        return new ArrayList<Log>();
    }

    protected StackTraceProcessor(StackTraceProcessorBuilder<?, ?> b) {
        super(b);
        this.logs = ((StackTraceProcessorBuilder)b).logs$set ? ((StackTraceProcessorBuilder)b).logs$value : StackTraceProcessor.$default$logs();
    }

    public static StackTraceProcessorBuilder<?, ?> builder() {
        return new StackTraceProcessorBuilderImpl();
    }

    private static final class StackTraceProcessorBuilderImpl
    extends StackTraceProcessorBuilder<StackTraceProcessor, StackTraceProcessorBuilderImpl> {
        private StackTraceProcessorBuilderImpl() {
        }

        @Override
        protected StackTraceProcessorBuilderImpl self() {
            return this;
        }

        @Override
        public StackTraceProcessor build() {
            return new StackTraceProcessor(this);
        }
    }

    public static abstract class StackTraceProcessorBuilder<C extends StackTraceProcessor, B extends StackTraceProcessorBuilder<C, B>>
    extends Processor.ProcessorBuilder<C, B> {
        private boolean logs$set;
        private List<Log> logs$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public B logs(List<Log> logs) {
            this.logs$value = logs;
            this.logs$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StackTraceProcessor.StackTraceProcessorBuilder(super=" + super.toString() + ", logs$value=" + this.logs$value + ")";
        }
    }
}

