/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.extent.processor;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import tech.grasshopper.pdf.extent.processor.Processor;
import tech.grasshopper.pdf.pojo.cucumber.Row;

public class DataTableProcessor
extends Processor {
    @Override
    public List<Row> process() {
        ArrayList<Row> data = new ArrayList<Row>();
        for (Log log : this.logs) {
            String html;
            Document doc;
            Element element;
            if (log.getStatus() != Status.PASS || (element = (doc = Jsoup.parseBodyFragment((String)(html = log.getDetails()))).selectFirst("body > table[class*=\"markup-table table\"]")) == null) continue;
            Elements rowElements = element.select("tr");
            for (Element rowElement : rowElements) {
                ArrayList<String> cells = new ArrayList<String>();
                data.add(Row.builder().cells(cells).build());
                for (Element cell : rowElement.select("td")) {
                    cells.add(cell.text());
                }
            }
        }
        return data;
    }

    protected DataTableProcessor(DataTableProcessorBuilder<?, ?> b) {
        super(b);
    }

    public static DataTableProcessorBuilder<?, ?> builder() {
        return new DataTableProcessorBuilderImpl();
    }

    private static final class DataTableProcessorBuilderImpl
    extends DataTableProcessorBuilder<DataTableProcessor, DataTableProcessorBuilderImpl> {
        private DataTableProcessorBuilderImpl() {
        }

        @Override
        protected DataTableProcessorBuilderImpl self() {
            return this;
        }

        @Override
        public DataTableProcessor build() {
            return new DataTableProcessor(this);
        }
    }

    public static abstract class DataTableProcessorBuilder<C extends DataTableProcessor, B extends DataTableProcessorBuilder<C, B>>
    extends Processor.ProcessorBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "DataTableProcessor.DataTableProcessorBuilder(super=" + super.toString() + ")";
        }
    }
}

