/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.extent.processor;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Log;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import tech.grasshopper.pdf.pojo.cucumber.Row;

public class DataTableProcessor {
    private List<Log> logs;

    public List<Row> process() {
        ArrayList<Row> data = new ArrayList<Row>();
        for (Log log : this.logs) {
            String html;
            Document doc;
            Element element;
            if (log.getStatus() != Status.PASS || (element = (doc = Jsoup.parseBodyFragment((String)(html = log.getDetails()))).selectFirst("body > table[class*=\"markup-table table\"]")) == null) continue;
            Elements rowElements = element.select("tr");
            for (Element rowElement : rowElements) {
                ArrayList<String> cells = new ArrayList<String>();
                data.add(Row.builder().cells(cells).build());
                for (Element cell : rowElement.select("td")) {
                    cells.add(cell.text());
                }
            }
        }
        return data;
    }

    private static List<Log> $default$logs() {
        return new ArrayList<Log>();
    }

    DataTableProcessor(List<Log> logs) {
        this.logs = logs;
    }

    public static DataTableProcessorBuilder builder() {
        return new DataTableProcessorBuilder();
    }

    public static class DataTableProcessorBuilder {
        private boolean logs$set;
        private List<Log> logs$value;

        DataTableProcessorBuilder() {
        }

        public DataTableProcessorBuilder logs(List<Log> logs) {
            this.logs$value = logs;
            this.logs$set = true;
            return this;
        }

        public DataTableProcessor build() {
            List logs$value = this.logs$value;
            if (!this.logs$set) {
                logs$value = DataTableProcessor.$default$logs();
            }
            return new DataTableProcessor(logs$value);
        }

        public String toString() {
            return "DataTableProcessor.DataTableProcessorBuilder(logs$value=" + this.logs$value + ")";
        }
    }
}

