/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.renderer;

import com.google.gson.Gson;
import io.qameta.allure.attachment.AttachmentContent;
import io.qameta.allure.attachment.AttachmentData;
import io.qameta.allure.attachment.AttachmentRenderException;
import io.qameta.allure.attachment.AttachmentRenderer;
import io.qameta.allure.attachment.DefaultAttachmentContent;
import java.io.StringWriter;

public class JsonAttachmentRenderer
implements AttachmentRenderer<AttachmentData> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AttachmentContent render(AttachmentData attachmentData) throws AttachmentRenderException {
        Gson gson = new Gson();
        try (StringWriter writer = new StringWriter();){
            gson.toJson((Object)attachmentData, (Appendable)writer);
            DefaultAttachmentContent defaultAttachmentContent = new DefaultAttachmentContent(((Object)writer).toString(), "application/json", ".json");
            return defaultAttachmentContent;
        }
        catch (Exception e) {
            throw new AttachmentRenderException("Could't render http attachment file", (Throwable)e);
        }
    }
}

