/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.attachment;

import io.qameta.allure.attachment.AttachmentData;
import io.restassured.internal.support.Prettifier;
import io.restassured.parsing.Parser;
import io.restassured.specification.MultiPartSpecification;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public class ExtentHttpRequestAttachment
implements AttachmentData {
    @NonNull
    private String name;
    @NonNull
    private String url;
    @NonNull
    private String method;
    private String body;
    private Map<String, String> headers;
    private Map<String, String> cookies;
    private Map<String, String> requestParameters;
    private Map<String, String> queryParameters;
    private Map<String, String> formParameters;
    private Map<String, String> pathParameters;
    private List<Map<String, String>> multiParts;

    private static Map<String, String> $default$headers() {
        return new HashMap<String, String>();
    }

    private static Map<String, String> $default$cookies() {
        return new HashMap<String, String>();
    }

    private static Map<String, String> $default$requestParameters() {
        return new HashMap<String, String>();
    }

    private static Map<String, String> $default$queryParameters() {
        return new HashMap<String, String>();
    }

    private static Map<String, String> $default$formParameters() {
        return new HashMap<String, String>();
    }

    private static Map<String, String> $default$pathParameters() {
        return new HashMap<String, String>();
    }

    ExtentHttpRequestAttachment(@NonNull String name, @NonNull String url, @NonNull String method, String body, Map<String, String> headers, Map<String, String> cookies, Map<String, String> requestParameters, Map<String, String> queryParameters, Map<String, String> formParameters, Map<String, String> pathParameters, List<Map<String, String>> multiParts) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.name = name;
        this.url = url;
        this.method = method;
        this.body = body;
        this.headers = headers;
        this.cookies = cookies;
        this.requestParameters = requestParameters;
        this.queryParameters = queryParameters;
        this.formParameters = formParameters;
        this.pathParameters = pathParameters;
        this.multiParts = multiParts;
    }

    public static ExtentHttpRequestAttachmentBuilder builder() {
        return new ExtentHttpRequestAttachmentBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getMethod() {
        return this.method;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, String> getFormParameters() {
        return this.formParameters;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public List<Map<String, String>> getMultiParts() {
        return this.multiParts;
    }

    public static class ExtentHttpRequestAttachmentBuilder {
        private String name;
        private String url;
        private String method;
        private String body;
        private boolean headers$set;
        private Map<String, String> headers$value;
        private boolean cookies$set;
        private Map<String, String> cookies$value;
        private boolean requestParameters$set;
        private Map<String, String> requestParameters$value;
        private boolean queryParameters$set;
        private Map<String, String> queryParameters$value;
        private boolean formParameters$set;
        private Map<String, String> formParameters$value;
        private boolean pathParameters$set;
        private Map<String, String> pathParameters$value;
        private List<Map<String, String>> multiParts;

        public ExtentHttpRequestAttachmentBuilder multiParts(List<MultiPartSpecification> parts) {
            this.multiParts = new ArrayList<Map<String, String>>();
            for (MultiPartSpecification part : parts) {
                if (!Objects.nonNull(part.getControlName())) continue;
                HashMap<String, String> data = new HashMap<String, String>();
                this.multiParts.add(data);
                data.put("name", part.getControlName());
                data.put("mime", Objects.nonNull(part.getMimeType()) ? part.getMimeType() : "");
                data.put("file", Objects.nonNull(part.getFileName()) ? part.getFileName() : "");
                if (Objects.nonNull(part.getMimeType()) && Objects.nonNull(part.getContent())) {
                    if (part.getContent() instanceof InputStream) {
                        data.put("content", "<inputstream>");
                        continue;
                    }
                    if (part.getContent() instanceof byte[]) {
                        data.put("content", "<bytes>");
                        continue;
                    }
                    Parser parser = Parser.fromContentType((String)part.getMimeType());
                    String prettified = new Prettifier().prettify(part.getContent().toString(), parser);
                    data.put("content", prettified);
                    continue;
                }
                data.put("content", "");
            }
            return this;
        }

        ExtentHttpRequestAttachmentBuilder() {
        }

        public ExtentHttpRequestAttachmentBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public ExtentHttpRequestAttachmentBuilder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        public ExtentHttpRequestAttachmentBuilder method(@NonNull String method) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            this.method = method;
            return this;
        }

        public ExtentHttpRequestAttachmentBuilder body(String body) {
            this.body = body;
            return this;
        }

        public ExtentHttpRequestAttachmentBuilder headers(Map<String, String> headers) {
            this.headers$value = headers;
            this.headers$set = true;
            return this;
        }

        public ExtentHttpRequestAttachmentBuilder cookies(Map<String, String> cookies) {
            this.cookies$value = cookies;
            this.cookies$set = true;
            return this;
        }

        public ExtentHttpRequestAttachmentBuilder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters$value = requestParameters;
            this.requestParameters$set = true;
            return this;
        }

        public ExtentHttpRequestAttachmentBuilder queryParameters(Map<String, String> queryParameters) {
            this.queryParameters$value = queryParameters;
            this.queryParameters$set = true;
            return this;
        }

        public ExtentHttpRequestAttachmentBuilder formParameters(Map<String, String> formParameters) {
            this.formParameters$value = formParameters;
            this.formParameters$set = true;
            return this;
        }

        public ExtentHttpRequestAttachmentBuilder pathParameters(Map<String, String> pathParameters) {
            this.pathParameters$value = pathParameters;
            this.pathParameters$set = true;
            return this;
        }

        public ExtentHttpRequestAttachment build() {
            Map headers$value = this.headers$value;
            if (!this.headers$set) {
                headers$value = ExtentHttpRequestAttachment.$default$headers();
            }
            Map cookies$value = this.cookies$value;
            if (!this.cookies$set) {
                cookies$value = ExtentHttpRequestAttachment.$default$cookies();
            }
            Map requestParameters$value = this.requestParameters$value;
            if (!this.requestParameters$set) {
                requestParameters$value = ExtentHttpRequestAttachment.$default$requestParameters();
            }
            Map queryParameters$value = this.queryParameters$value;
            if (!this.queryParameters$set) {
                queryParameters$value = ExtentHttpRequestAttachment.$default$queryParameters();
            }
            Map formParameters$value = this.formParameters$value;
            if (!this.formParameters$set) {
                formParameters$value = ExtentHttpRequestAttachment.$default$formParameters();
            }
            Map pathParameters$value = this.pathParameters$value;
            if (!this.pathParameters$set) {
                pathParameters$value = ExtentHttpRequestAttachment.$default$pathParameters();
            }
            return new ExtentHttpRequestAttachment(this.name, this.url, this.method, this.body, headers$value, cookies$value, requestParameters$value, queryParameters$value, formParameters$value, pathParameters$value, this.multiParts);
        }

        public String toString() {
            return "ExtentHttpRequestAttachment.ExtentHttpRequestAttachmentBuilder(name=" + this.name + ", url=" + this.url + ", method=" + this.method + ", body=" + this.body + ", headers$value=" + this.headers$value + ", cookies$value=" + this.cookies$value + ", requestParameters$value=" + this.requestParameters$value + ", queryParameters$value=" + this.queryParameters$value + ", formParameters$value=" + this.formParameters$value + ", pathParameters$value=" + this.pathParameters$value + ", multiParts=" + this.multiParts + ")";
        }
    }
}

