/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.feature;

import java.util.List;
import tech.grasshopper.pdf.data.DisplayData;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.section.feature.FeatureDisplay;
import tech.grasshopper.pdf.structure.paginate.FeaturePaginator;
import tech.grasshopper.pdf.structure.paginate.PaginatedSection;
import tech.grasshopper.pdf.structure.paginate.PaginationData;

public class FeatureSection
extends PaginatedSection {
    static final String SECTION_TITLE = "FEATURES SUMMARY";
    private final int maxFeaturesPerPage;
    private FeatureData featureData;

    @Override
    public void createSection() {
        this.featureData = (FeatureData)this.displayData;
        if (this.featureData.getFeatures().isEmpty()) {
            return;
        }
        FeaturePaginator paginator = FeaturePaginator.builder().data(this.featureData).maxFeaturesPerPage(this.maxFeaturesPerPage).section(this).build();
        paginator.paginate();
    }

    @Override
    public void generateDisplay(int fromIndex, int toIndex) {
        ((FeatureDisplay)((FeatureDisplay.FeatureDisplayBuilder)((FeatureDisplay.FeatureDisplayBuilder)((FeatureDisplay.FeatureDisplayBuilder)((FeatureDisplay.FeatureDisplayBuilder)((FeatureDisplay.FeatureDisplayBuilder)FeatureDisplay.builder().displayData(this.createDisplayData(fromIndex, toIndex))).document(this.document)).reportConfig(this.reportConfig)).destinations(this.destinations)).paginationData(PaginationData.builder().itemsPerPage(this.maxFeaturesPerPage).itemFromIndex(fromIndex).itemToIndex(toIndex).build())).build()).display();
    }

    @Override
    public DisplayData createDisplayData(int fromIndex, int toIndex) {
        List<Feature> pageFeatures = this.featureData.getFeatures().subList(fromIndex, toIndex);
        return FeatureData.builder().features(pageFeatures).build();
    }

    protected FeatureSection(FeatureSectionBuilder<?, ?> b) {
        super((PaginatedSection.PaginatedSectionBuilder<?, ?>)b);
        this.maxFeaturesPerPage = this.reportConfig.getFeatureConfig().featureCount();
        this.featureData = ((FeatureSectionBuilder)b).featureData;
    }

    public static FeatureSectionBuilder<?, ?> builder() {
        return new FeatureSectionBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureSection)) {
            return false;
        }
        FeatureSection other = (FeatureSection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxFeaturesPerPage != other.maxFeaturesPerPage) {
            return false;
        }
        FeatureData this$featureData = this.featureData;
        FeatureData other$featureData = other.featureData;
        return !(this$featureData == null ? other$featureData != null : !this$featureData.equals(other$featureData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FeatureSection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxFeaturesPerPage;
        FeatureData $featureData = this.featureData;
        result = result * 59 + ($featureData == null ? 43 : $featureData.hashCode());
        return result;
    }

    private static final class FeatureSectionBuilderImpl
    extends FeatureSectionBuilder<FeatureSection, FeatureSectionBuilderImpl> {
        private FeatureSectionBuilderImpl() {
        }

        @Override
        protected FeatureSectionBuilderImpl self() {
            return this;
        }

        @Override
        public FeatureSection build() {
            return new FeatureSection(this);
        }
    }

    public static abstract class FeatureSectionBuilder<C extends FeatureSection, B extends FeatureSectionBuilder<C, B>>
    extends PaginatedSection.PaginatedSectionBuilder<C, B> {
        private FeatureData featureData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B featureData(FeatureData featureData) {
            this.featureData = featureData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FeatureSection.FeatureSectionBuilder(super=" + super.toString() + ", featureData=" + this.featureData + ")";
        }
    }
}

