/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.data;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import tech.grasshopper.pdf.data.DashboardData;
import tech.grasshopper.pdf.data.ExecutableData;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.data.ScenarioData;
import tech.grasshopper.pdf.data.TagData;
import tech.grasshopper.pdf.exception.PdfReportException;
import tech.grasshopper.pdf.pojo.cucumber.BaseEntity;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.pojo.cucumber.Scenario;
import tech.grasshopper.pdf.pojo.cucumber.Status;
import tech.grasshopper.pdf.pojo.cucumber.Step;
import tech.grasshopper.pdf.pojo.cucumber.Tag;

public class ReportData {
    private List<Feature> features;
    private DashboardData summaryData;
    private FeatureData featureData;
    private ScenarioData scenarioData;
    private ExecutableData executableData;
    private TagData tagData;

    public void checkData() {
        if (this.features == null || this.features.size() == 0) {
            throw new PdfReportException("No features present in test execution.");
        }
        for (Feature feature : this.features) {
            feature.checkData();
            for (Scenario scenario : feature.getScenarios()) {
                scenario.checkData();
                for (Executable executable : scenario.getStepsAndHooks()) {
                    executable.checkData();
                }
            }
        }
    }

    public void populateSectionData() {
        this.populateCounts();
        this.populateDashboardData();
        this.populateFeaturesScenariosStepsData();
        this.populateTagData();
    }

    private void populateCounts() {
        if (this.features == null || this.features.size() == 0) {
            throw new PdfReportException("No features present in test execution.");
        }
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                for (Step step : scenario.getSteps()) {
                    if (step.getStatus() == Status.PASSED) {
                        scenario.setPassedSteps(scenario.getPassedSteps() + 1);
                        feature.setPassedSteps(feature.getPassedSteps() + 1);
                    } else if (step.getStatus() == Status.FAILED) {
                        scenario.setFailedSteps(scenario.getFailedSteps() + 1);
                        feature.setFailedSteps(feature.getFailedSteps() + 1);
                    } else {
                        scenario.setSkippedSteps(scenario.getSkippedSteps() + 1);
                        feature.setSkippedSteps(feature.getSkippedSteps() + 1);
                    }
                    scenario.setTotalSteps(scenario.getTotalSteps() + 1);
                    feature.setTotalSteps(feature.getTotalSteps() + 1);
                }
                if (scenario.getStatus() == Status.PASSED) {
                    feature.setPassedScenarios(feature.getPassedScenarios() + 1);
                } else if (scenario.getStatus() == Status.FAILED) {
                    feature.setFailedScenarios(feature.getFailedScenarios() + 1);
                } else {
                    feature.setSkippedScenarios(feature.getSkippedScenarios() + 1);
                }
                feature.setTotalScenarios(feature.getTotalScenarios() + 1);
            }
        }
    }

    private void populateDashboardData() {
        this.summaryData = DashboardData.builder().testRunStartTime((LocalDateTime)Collections.min(this.features.stream().map(BaseEntity::getStartTime).collect(Collectors.toList()))).testRunEndTime((LocalDateTime)Collections.max(this.features.stream().map(BaseEntity::getEndTime).collect(Collectors.toList()))).build();
        for (Feature feature : this.features) {
            if (feature.getStatus() == Status.PASSED) {
                this.summaryData.setPassedFeatures(this.summaryData.getPassedFeatures() + 1);
            } else if (feature.getStatus() == Status.FAILED) {
                this.summaryData.setFailedFeatures(this.summaryData.getFailedFeatures() + 1);
            } else {
                this.summaryData.setSkippedFeatures(this.summaryData.getSkippedFeatures() + 1);
            }
            this.summaryData.setTotalFeatures(this.summaryData.getTotalFeatures() + 1);
            this.summaryData.setPassedScenarios(this.summaryData.getPassedScenarios() + feature.getPassedScenarios());
            this.summaryData.setFailedScenarios(this.summaryData.getFailedScenarios() + feature.getFailedScenarios());
            this.summaryData.setSkippedScenarios(this.summaryData.getSkippedScenarios() + feature.getSkippedScenarios());
            this.summaryData.setTotalScenarios(this.summaryData.getTotalScenarios() + feature.getTotalScenarios());
            this.summaryData.setPassedSteps(this.summaryData.getPassedSteps() + feature.getPassedSteps());
            this.summaryData.setFailedSteps(this.summaryData.getFailedSteps() + feature.getFailedSteps());
            this.summaryData.setSkippedSteps(this.summaryData.getSkippedSteps() + feature.getSkippedSteps());
            this.summaryData.setTotalSteps(this.summaryData.getTotalSteps() + feature.getTotalSteps());
        }
    }

    private void populateFeaturesScenariosStepsData() {
        this.featureData = FeatureData.builder().features(this.features).build();
        this.scenarioData = ScenarioData.builder().build();
        this.executableData = ExecutableData.builder().build();
        for (Feature feature : this.features) {
            for (Scenario scenario : feature.getScenarios()) {
                scenario.setFeature(feature);
                this.scenarioData.getScenarios().add(scenario);
                for (Executable executable : scenario.getStepsAndHooks()) {
                    executable.setScenario(scenario);
                    executable.setFeature(feature);
                    this.executableData.getExecutables().add(executable);
                }
            }
        }
    }

    private void populateTagData() {
        this.tagData = TagData.builder().build();
        List<Tag> tags = this.tagData.getTags();
        for (Feature feature : this.features) {
            ArrayList<String> featureTag = new ArrayList<String>();
            for (Scenario scenario : feature.getScenarios()) {
                Tag tag = null;
                for (String tagName : scenario.getTags()) {
                    tag = new Tag(tagName);
                    int tagIndex = tags.indexOf(tag);
                    if (tagIndex > -1) {
                        tag = tags.get(tagIndex);
                    } else {
                        tags.add(tag);
                    }
                    if (scenario.getStatus() == Status.PASSED) {
                        tag.setPassedScenarios(tag.getPassedScenarios() + 1);
                    } else if (scenario.getStatus() == Status.FAILED) {
                        tag.setFailedScenarios(tag.getFailedScenarios() + 1);
                    } else {
                        tag.setSkippedScenarios(tag.getSkippedScenarios() + 1);
                    }
                    tag.setTotalScenarios(tag.getTotalScenarios() + 1);
                    if (featureTag.contains(tagName)) continue;
                    if (feature.getStatus() == Status.PASSED) {
                        tag.setPassedFeatures(tag.getPassedFeatures() + 1);
                    } else if (feature.getStatus() == Status.FAILED) {
                        tag.setFailedFeatures(tag.getFailedFeatures() + 1);
                    } else {
                        tag.setSkippedFeatures(tag.getSkippedFeatures() + 1);
                    }
                    tag.setTotalFeatures(tag.getTotalFeatures() + 1);
                    featureTag.add(tagName);
                }
            }
        }
        for (Tag tag : this.tagData.getTags()) {
            if (tag.getFailedScenarios() > 0 || tag.getFailedFeatures() > 0) {
                tag.setStatus(Status.FAILED);
                continue;
            }
            if (tag.getPassedScenarios() == tag.getTotalScenarios() && tag.getFailedScenarios() == 0 && tag.getPassedFeatures() == tag.getTotalFeatures() && tag.getFailedFeatures() == 0) {
                tag.setStatus(Status.PASSED);
                continue;
            }
            tag.setStatus(Status.SKIPPED);
        }
    }

    ReportData(List<Feature> features, DashboardData summaryData, FeatureData featureData, ScenarioData scenarioData, ExecutableData executableData, TagData tagData) {
        this.features = features;
        this.summaryData = summaryData;
        this.featureData = featureData;
        this.scenarioData = scenarioData;
        this.executableData = executableData;
        this.tagData = tagData;
    }

    public static ReportDataBuilder builder() {
        return new ReportDataBuilder();
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public DashboardData getSummaryData() {
        return this.summaryData;
    }

    public FeatureData getFeatureData() {
        return this.featureData;
    }

    public ScenarioData getScenarioData() {
        return this.scenarioData;
    }

    public ExecutableData getExecutableData() {
        return this.executableData;
    }

    public TagData getTagData() {
        return this.tagData;
    }

    public static class ReportDataBuilder {
        private List<Feature> features;
        private DashboardData summaryData;
        private FeatureData featureData;
        private ScenarioData scenarioData;
        private ExecutableData executableData;
        private TagData tagData;

        ReportDataBuilder() {
        }

        public ReportDataBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public ReportDataBuilder summaryData(DashboardData summaryData) {
            this.summaryData = summaryData;
            return this;
        }

        public ReportDataBuilder featureData(FeatureData featureData) {
            this.featureData = featureData;
            return this;
        }

        public ReportDataBuilder scenarioData(ScenarioData scenarioData) {
            this.scenarioData = scenarioData;
            return this;
        }

        public ReportDataBuilder executableData(ExecutableData executableData) {
            this.executableData = executableData;
            return this;
        }

        public ReportDataBuilder tagData(TagData tagData) {
            this.tagData = tagData;
            return this;
        }

        public ReportData build() {
            return new ReportData(this.features, this.summaryData, this.featureData, this.scenarioData, this.executableData, this.tagData);
        }

        public String toString() {
            return "ReportData.ReportDataBuilder(features=" + this.features + ", summaryData=" + this.summaryData + ", featureData=" + this.featureData + ", scenarioData=" + this.scenarioData + ", executableData=" + this.executableData + ", tagData=" + this.tagData + ")";
        }
    }
}

